#ifndef TextShape_First
#define TextShape_First

#include "Shape.h"

//---- Text Shape Commands -----------------------------------------------------

class TextShapeSketcher: public ShapeSketcher {
    int lineHeight, baseHeight;
public:
    TextShapeSketcher(class DrawView*, class Shape *pro, SketchModes);
    void TrackConstrain(Point, Point, Point *np);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
};

class TextShapeStretcher: public ShapeStretcher {
public:
    TextShapeStretcher(class DrawView*, class Shape *pro, int sq);
    void TrackConstrain(Point, Point, Point *np);
};

//---- Text Shape --------------------------------------------------------------

class TextShape : public Shape {
    class TextView *to;
    Shape *attachedTo;     // shape i am attached to
    bool captured;         // is the text captured ?? (otherwise paragraphed)
public:
    MetaDef(TextShape);
    
    TextShape();
    ~TextShape();
    
    bool IsGarbage();
    void SetView(View *vp);
    short *GetImage();
    GrCursor SketchCursor();
    Rectangle InvalRect();    // expand to make caret visible
    void InvalDiff(Rectangle r);
    void Init(Point, Point);
    void Draw(Rectangle, Point p);
    void SetFont(class RunArray*);
    void ApplyFont(StChangeStyle, StyleSpec);
    void SetProperty(ShapeProperties, int);
    int GetProperty(ShapeProperties);
    RunArray *GetFont();
    void Highlight(HighlightState);
    class TextView *GetTextView()
	{ return to; }
    ShapeSketcher *NewSketcher(DrawView*, SketchModes);
    class ShapeStretcher *NewStretcher(DrawView*, int);
    void SetSpan(Rectangle);
    void MakeDependentOn(Shape*);
    void DoUpdate(Object*,void*);
    ostream& PrintOn(ostream&);
    istream& ReadFrom(istream&);
};

#endif TextShape_First
