//$DrawDocument,PatternItem,LineStyleItem$
#include "ET++.h"

#include "PullDownFrame.h"
#include "ObjArray.h"
#include "CollectionView.h"
#include "FileDialog.h"

#include "DrawDocument.h"
#include "DrawView.h"
#include "Commands.h"
#include "TextShape.h"
#include "ImageShape.h"
#include "TextCmd.h"

static short SunLogo[]= {
#   include  "images/SunLogo.im"
};

char *cDocTypeDraw= "DRAW";

const int cIdPalette    =   cIdFirstUser + 11,
	  cIdDrawView   =   cIdFirstUser + 12;

//---- PatternMenuItem ---------------------------------------------------------

class PatternItem : public VObject {
    GrPattern pat;
public:
    PatternItem(int id, GrPattern p) : (id)
	{ pat= p; }
    void Draw(Rectangle);
    void Highlight(HighlightState)
	{ GrSetPenSize(2); GrStrokeRect(contentRect); }
    Metric GetMinSize()
	{ return Metric(40, 20); }
};

void PatternItem::Draw(Rectangle)
{
    if (pat == ePatWhite)
	GrStrokeRect(contentRect.Inset(2));
    else
	GrPaintRect(contentRect.Inset(2), pat);
}

//---- LineStyleItem ----------------------------------------------------------

class LineStyleItem : public LineItem {
    GrLineCap cap;
    int width;
public:
    LineStyleItem(int id, int w= 1, GrLineCap lc= eDefaultCap) : (TRUE, w, 20, id)
	{ cap= lc; width= w; }
    void Draw(Rectangle);
    Metric GetMinSize()
	{ return Metric(Point(40, max(15, width+4))); }
};

void LineStyleItem::Draw(Rectangle r)
{
    r= contentRect.Inset(Point(5,0));
    GrSetPenSize(width);
    GrStrokeLine(ePatBlack, eRopCopy, cap, r.W(), r.E());
    GrSetPenSize(1);
    if (width >= 12) {
	char buf[10];
	sprintf(buf, "%d", width);
	Point p= gSysFont->AdjustString(buf, r.Center(), eAdjVCenter, eAdjHCenter);
	GrShowString(gSysFont, ePatWhite, eRopCopy, p, buf);
    }
}

//---- DrawDocument ------------------------------------------------------------

MetaImpl(DrawDocument, (I_O(prototypes), I_O(tools), I_O(info),
			    I_O(drawView), I_O(paletteView), I_O(shapes)));

DrawDocument::DrawDocument(ObjArray *pro, ObjList *too) : (cDocTypeDraw)
{
    shapes= new ObjList;
    prototypes= pro;
    tools= too;
}

DrawDocument::~DrawDocument()
{
    SafeDelete(drawView);
    // SafeDelete(paletteView);
}

class PullDownBar *DrawDocument::CreateMenuBar()
{
    GrPattern p;
    PullDownMenu *m;
    int font, size= gSysFont->Size(), fid= gSysFont->Fid();
    char *fontname;
    Point tb(4,0);  // border around textitems
    ObjList *list= new ObjList;
    
    //---- sun menu
    m= new PullDownMenu(new ImageItem(SunLogo, Point(23)));
    m->AppendItems("About Draw", cABOUT, 0);
    list->Add(new PullDownItem(m));
    
    //---- font menu
    m= new PullDownMenu("Fonts", TRUE);
    for (font= 0; fontname= gFontManager->IdToName(font); font++)
	m->Append(new TextItem(cFIRSTFONT+font, fontname, gSysFont, tb)); 
    list->Add(new PullDownItem(m));
	
    //---- styles menu
    m= new PullDownMenu("Styles");
    m->Append(new TextItem(cFIRSTFACE+eFacePlain, "Plain", 
				    new Font(fid, size, eFacePlain), tb));
    m->Append(new TextItem(cFIRSTFACE+eFaceBold, "Bold", 
				    new Font(fid, size, eFaceBold), tb));
    m->Append(new TextItem(cFIRSTFACE+eFaceItalic, "Italic", 
				    new Font(fid, size, eFaceItalic), tb));
    m->Append(new TextItem(cFIRSTFACE+eFaceUnderline, "Underline", 
				    new Font(fid, size, eFaceUnderline), tb));
    m->Append(new TextItem(cFIRSTFACE+eFaceOutline, "Outline", 
				    new Font(fid, size, eFaceOutline), tb));
    m->Append(new TextItem(cFIRSTFACE+eFaceShadow, "Shadow", 
				    new Font(fid, size, eFaceShadow), tb));
    list->Add(new PullDownItem(m));
    
    //---- sizes menu
    m= new PullDownMenu("Sizes");
    for (int sz= 9; sz <= 24; sz++)
	m->Append(new TextItem(cFIRSTSIZE+sz, strprintf("%d  ", sz), gSysFont, tb)); 
    list->Add(new PullDownItem(m));

    //---- format menu
    m= new PullDownMenu("Format");
    m->AppendItems("Align Left",     cFIRSTADJUST,
		   "Align Right",    cFIRSTADJUST + 1,
		   "Align Center",   cFIRSTADJUST + 2,
		   "Justify",        cFIRSTADJUST + 3,
		   "-",
		   "Single Spacing", cFIRSTSPACING + eOne,
		   "1-1/2 Spacing",  cFIRSTSPACING + eOneHalf,
		   "Double Spacing", cFIRSTSPACING + eTwo,
		   0);
    list->Add(new PullDownItem(m));
    
    //---- pattern menu
    m= new PullDownMenu("Pattern", FALSE, 8, 3);
    m->AppendItem("None", cFIRSTPAT+ePatNone);
    for (p= ePatWhite; p <= ePat15; p++)
	m->Append(new PatternItem(cFIRSTPAT+p, p));
    list->Add(new PullDownItem(m));
    
    //---- line menu
    m= new PullDownMenu("Lines");
    for (int cap= 0; cap < 4; cap++)
	m->Append(new LineStyleItem(cFIRSTPEN+cap, 1, cap));
    m->AppendItems("-", "Hairline",  cFIRSTPENSIZE, 0);
    for (int lw= 1; lw <= 30; lw++)
	m->Append(new LineStyleItem(cFIRSTPENSIZE+lw, lw));
    list->Add(new PullDownItem(m));
    
    //---- pen pattern menu
    m= new PullDownMenu("Pens", FALSE, 8, 3);
    m->AppendItem("None", cFIRSTPPAT+ePatNone);
    for (p= ePatWhite; p <= ePat15; p++)
	m->Append(new PatternItem(cFIRSTPPAT+p, p));
    list->Add(new PullDownItem(m));
    
    return new PullDownBar(this, list);
}

Window *DrawDocument::DoMakeWindows()
{
    drawView= new DrawView(this, Point(2000), shapes);
    drawView->SetId(cIdDrawView);
    
    paletteView= new CollectionView(this, tools, eCVGrid);
    paletteView->SetId(cIdPalette);
    paletteView->SetSelection(Rectangle(1,1));

    VObject *vop= new BorderItem(new Clipper(CreateMenuBar()), gPoint0);
    vop->SetFlag(eVObjVFixed);
    
    VObject *vop1= new BorderItem(new Clipper(paletteView), gPoint0);
    vop1->SetFlag(eVObjHFixed);
    
    //info= new TextItem("");
    //info->SetFlag(eVObjVFixed);

    return new Window(this, Point(600, 400), eWinDefault,
	new Expander(eVert, gPoint3,
	    vop,
	    new Expander(eHor, gPoint3,
		vop1,
		new Splitter(drawView),
	    0),
	    info,
	0)
    );
}

Command *DrawDocument::DoMenuCommand(int cmd)
{
    TextShape *activeText= drawView->GetActiveText();
    TextView *tv= 0;

    if (activeText)
	tv= activeText->GetTextView();
	
    if (drawView->Selected() <= 0)
	return Document::DoMenuCommand(cmd);
	
    if (cmd >= cFIRSTPAT && cmd <= cLASTPAT)
	return new PropertyCommand(drawView, eShapePattern, cmd-cFIRSTPAT, "set pattern");
    if (cmd >= cFIRSTPPAT && cmd <= cLASTPPAT)
	return new PropertyCommand(drawView, eShapePenPattern, cmd-cFIRSTPPAT, "set penpattern");
    if (cmd >= cFIRSTPEN && cmd <= cLASTPEN)
	return new PropertyCommand(drawView, eShapeArrows, cmd-cFIRSTPEN, "set arrows");
    if (cmd >= cFIRSTPENSIZE && cmd <= cLASTPENSIZE)
	return new PropertyCommand(drawView, eShapePensize, cmd-cFIRSTPENSIZE, "set pensize");
    if (cmd >= cFIRSTSIZE && cmd <= cLASTSIZE) {
	if (tv)
	    return new ChangeStyleCommand(tv,cmd,"set size", eStSize, StyleSpec(0,0,cmd-cFIRSTSIZE));
	return new FontCommand(drawView, cTEXTSIZE, cmd-cFIRSTSIZE, "set size");
    }
    if (cmd >= cFIRSTFONT && cmd <= cLASTFONT) {
	if (tv)
	    return new ChangeStyleCommand(tv,cmd,"set font", eStFont, StyleSpec(cmd-cFIRSTFONT,0,0));
	return new FontCommand(drawView, cTEXTFONT, cmd-cFIRSTFONT, "set font");
    }
    if (cmd >= cFIRSTFACE && cmd <= cLASTFACE) {
	if (tv)
	    return new ChangeStyleCommand(tv,cmd,"set face", eStFace, StyleSpec(0,cmd-cFIRSTFACE,0));
	return new FontCommand(drawView, cTEXTFACE, cmd-cFIRSTFACE, "set face");
    }
    if (cmd >= cFIRSTADJUST && cmd <= cLASTADJUST)
	return new PropertyCommand(drawView, eShapeAdjust, cmd-cFIRSTADJUST, "set just");
    if (cmd >= cFIRSTSPACING && cmd <= cLASTSPACING)
	return new PropertyCommand(drawView, eShapeSpacing, cmd-cFIRSTSPACING, "set spacing");
    return Document::DoMenuCommand(cmd);
}

void DrawDocument::Control(int id, int part, void *val)
{
    int ix= int(val);
    
    if (id == cIdPalette
		&& (part == cPartCollSelect || part == cPartCollDoubleSelect))
	drawView->SetTool(prototypes->At(ix));
    else if (id == cIdDrawView && part == 0 && (ix == 0 || ix == 1)) {
	paletteView->SetSelection(Rectangle(0, ix, 1, 1));
	drawView->SetTool(prototypes->At(ix));
    } if (info && id == cIdDrawView && part == 123) {
	info->SetString((char*) val, TRUE);
	info->UpdateEvent();
    } else
	Document::Control(id, part, val);
}

bool DrawDocument::CanLoadDocument(FileType *ft)
{
    return strismember(ft->Type(), cDocTypeDraw, cDocTypeAscii, 0);
}
    
bool DrawDocument::CanImportDocument(FileType *ft)
{
    if (!ft)
	return TRUE;
    return strismember(ft->Type(), cDocTypeAscii, cDocSunRasterFile, 0);
}

void DrawDocument::DoRead(istream &from, FileType *ft)
{
    ObjList *newshapes= 0;
    
    if (strcmp(ft->Type(), GetDocumentType()) == 0) {
	Document::DoRead(from, ft);
	from >> newshapes;
    }

    if (newshapes) {
	shapes= newshapes;
	drawView->SetShapes(newshapes);
    }
}

void DrawDocument::DoWrite(ostream &to, int type)
{
    if (type == 0) {
	Document::DoWrite(to, type);
	drawView->SetSelection(0);
	drawView->SetActiveText(0);
	drawView->RemoveDeleted();    
	to << shapes;
    }
}

Command *DrawDocument::DoImport(istream &s, FileType *ft)
{
    Shape *ns= 0;
	
    if (strcmp(ft->Type(), cDocTypeAscii) == 0) {
	GapText t;
	t.ReadFromAsPureText(s, ft->SizeHint());
	TextShape *ts;
	if (ts= drawView->GetActiveText()) {
	    Command *cmd= ts->GetTextView()->InsertText(&t);
	    ts->Invalidate();
	    return cmd;
	}
	
	ts= new TextShape;
	ts->Init(drawView->LastClick(), drawView->LastClick()+10);
	ts->GetTextView()->InsertText(&t);
	ns= ts;
	
    } else if (strcmp(ft->Type(), cDocSunRasterFile) == 0) {
	char *name= ft->PathName();
	if (name == 0)
	    return gNoChanges;
	Bitmap *bm= new Bitmap(name);
	if (bm)
	    ns= new ImageShape(bm);
    }
    if (ns)
	return new SPasteCommand(drawView, ns, drawView->LastClick());
    return gNoChanges;
}
