/*
 * funcdefs.h
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: funcdefs.h,v 3.0 89/10/27 02:05:50 craig Exp $
 *
 * $Log:	funcdefs.h,v $
 * Revision 3.0  89/10/27  02:05:50  craig
 * Baseline for first official release.
 * 
 */

/*
 * This file should eventually disappear; function declarations should
 * appear as externs where needed.  Macros should be moved to a separate file.
 */
/*
 * Normal routines
 */
int	nrmsph(), nrmbox(), nrmtri(), nrmsup(),nrmplane(), nrmcyl(),
		nrmpoly(), nrmcone(), nrmhf();
/*
 * Intersection routines
 */
double 	intsph(), intbox(), inttri(), intsup(),intplane(), crossp(), intcyl(),
		intpoly(), intcone(), inthf();
/*
 * Extent-box finding routines
 */
int	sphextent(),boxextent(),triextent(),supextent(),planeextent(),
		cylextent(), polyextent(), coneextent(), hfextent();

/*
 * Object creation routines
 */
Object *maksph(), *makbox(), *maktri(), *maksup(), *makplane(), *makcyl(),
	  *makpoly(), *makcone(), *makhf(), *new_object();
/*
 * Intersection routines.
 */
double	int_grid(), int_list(), int_primitive(), IntBounds();

/*
 * Misc.
 */
char *Malloc(), *Calloc(), *strsave();
double	normalize(), Noise();

/*
 * Transformations
 */
Trans *new_trans();
TransInfo *new_transinfo();

/*
 * Surfaces
 */
Surface	*find_surface(), *make_surface(), *get_surface();
SurfaceList *add_surface();
/*
 * Objects
 */
Object *add_child_named(), *add_child(), *get_object_named();

extern double ftmp;  /* Yick -- keeps us from evaluating twice during fabs. */

/*
 * Macros
 */

/*
 * Absolute value -- uses "ftmp" to store value of argument, which
 * keeps us from evaluating expressions more than once.
 */
#define	fabs(x)			((ftmp=(x)) < 0. ? -(ftmp) : (ftmp))
#define abs(x) 			((x) < 0 ? -(x) : (x))

#ifdef SYSV
double drand48();
/*
 * nrand() returns a uniformly distributed random variable between 0 and 1.
 */
#define nrand()			(drand48())
#else
long random();
#define nrand()			((double)random() / (double)((1 << 31) - 1))
#endif

#ifdef MULTIMAX
/*
 * On the multimax, allocate large pieces of memory as shared memory.
 */
extern char *share_malloc(), *share_calloc();
#define mallocprim()		(Primitive *)share_malloc(sizeof(Primitive))
#else
/*
 * Otherwise, malloc is malloc, etc.
 */
#define share_malloc(x)		Malloc(x)
#define share_calloc(x,y)	Calloc(x,y)
#define mallocprim()		(Primitive *)Malloc(sizeof(Primitive))
#endif

/*
 * Return a uniformly distributed random variable between -s/2 and s/2.
 */
#define jitter(s)		((nrand() * (s)) - (s)/2.)
/*
 * Dot product
 */
#define dotp(a, b)		(((a)->x*(b)->x)+((a)->y*(b)->y)+((a)->z*(b)->z))
/*
 * Close enough for us.
 */
#define equal(a, b)		(fabs((a) - (b)) < EPSILON)
/*
 * Maximum/Minimum functions
 */
#define max(a, b)		((a) > (b) ? (a) : (b))
#define min(a, b)		((a) < (b) ? (a) : (b))
/*
 * Convert from voxel number along X/Y/Z to corresponding coordinate.
 */
#define voxel2x(g,x)		((x) * g->voxsize[0]+ g->bounds[0][0])
#define voxel2y(g,y)		((y) * g->voxsize[1] + g->bounds[0][1])
#define voxel2z(g,z)		((z) * g->voxsize[2] + g->bounds[0][2])
/*
 * And vice-versa.
 */
#define x2voxel(g,x)		(((x) - g->bounds[0][0]) / g->voxsize[0])
#define y2voxel(g,y)		(((y) - g->bounds[0][1]) / g->voxsize[1])
#define z2voxel(g,z)		(((z) - g->bounds[0][2]) / g->voxsize[2])
/*
 * Is the point "p" outisde of the bounding box "b"?
 */
#define OutOfBounds(p,b) ((p)->x < b[0][0] || (p)->x > b[1][0] ||\
			  (p)->y < b[0][1] || (p)->y > b[1][1] ||\
			  (p)->z < b[0][2] || (p)->z > b[1][2])

#ifndef DUMB_CPP

#define vecsub(a,b,r)	(r)->x= (a).x-(b).x;(r)->y= (a).y-(b).y;(r)->z= (a).z-(b).z
#define vecadd(a,b,r)	(r)->x= (a).x+(b).x;(r)->y= (a).y+(b).y;(r)->z= (a).z+(b).z
#define scalar_prod(s,a,r)	(r)->x= s*(a).x;(r)->y= s*(a).y;(r)->z= s*(a).z
#define veccomb(s1,v1,s2,v2,r)	(r)->x = s1*(v1).x + s2*(v2).x; \
				 (r)->y = s1*(v1).y + s2*(v2).y; \
				 (r)->z = s1*(v1).z + s2*(v2).z;
#define addscaledvec(v1,s,v2,r)	(r)->x = (v1).x + s*(v2).x; \
				 (r)->y = (v1).y + s*(v2).y; \
				 (r)->z = (v1).z + s*(v2).z;
#endif
