'\"t
.if t .TH IMTGA 3IM "August 24, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMTGA 3IM "August 24, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imtga \- TrueVision TGA file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "tga", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "tga", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "tga", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "tga", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBtga\fR image files are generated by Truevision Targa software
products as well as an assortment of IBM PC platform graphics utilities.
.SH "FILE RECOGNITION"
Truevision \fBtga\fR files are recognized by the following
filename suffixe:  .tga.
.SH NOTES
SDSC image library support of the 
Truevision \fBtga\fR format does not require
use of any Truevision libraries or hardware and contains no proprietary code.  
Truevision \fBtga\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Truevision TGA files"
The SDSC image library reads 
uncompressed and runlength-encoded (RLE) 8-bit grayscale, 16-bit grayscale,
8-bit color mapped, 16-bit color mapped, 2 byte RGB, 3 byte RGB, and 4 byte RGB
images.  The RGB and grayscale images may also contain CLT's.  The pictures
with the screen origin bit set are handled properly.
CLT's may be 16, 24 or 32 bit.
.LP
Only non-interleaved images are supported.  Targa types 32 and 33 are not 
supported, but types 0,1,2,3,9,10 and 11 are.
.SS "Writing Truevision TGA files"
Image library \fBIMVFBRGB\fR, \fBIMVFBINDEX8\fR, and \fBIMVFBINDEX16\fR
VFBs are written 
to uncompressed or runlength-encoded 8-bit grayscale, 16-bit grayscale, 
8-bit color mapped, 16-bit color mapped, 2 byte RGB, 3 byte RGB, and 4 byte RGB
images.  Color indexed images may contain a CLT.
The screen origin bit is always set to the upper left.
CLT's are stored with 24-bit entries (8-bits per channel).
.LP
Images are stored non-interleaved.  Targa types 0, 32 and 33 are not
supported, but 1,2,3,9,10 and 11 are.
.LP
Other image library VFB types are converted to
\fBIMVFBINDEX8\fR, \fBIMVFBINDEX16\fR, or \fBIMVFBRGB\fR VFB's
prior to being written out.  See the
\fBImFileWrite\fR(3IM) \fBman\fP page for details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Truevision \fBtga\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEFORMAT	Cannot support this format
IMENOIMAGE	No image contained in file
IMENOCLT	No color color map contained if needed
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Unsupported number of bytes per pixel in image
IMESYNTAX	Type of interleaving not supported
.TE
.if t .in -0.5i
.if n .in -5
.LP
.SH DOCUMENTATION
\fITruevision TGA File Format Specification, Version 2.0\fR,
Truevision Technical Manual Version 2.2, January 1991, Truevision Inc.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Chris Groening 
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
