'\"t
.if t .TH IMCLTROLL 3IM "September 1, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY" 
.if n .TH IMCLTROLL 3IM "September 1, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
ImCltRoll - Roll a color lookup table by a number of entries
.SH SYNOPSIS
\fB
.nf
#include "im.h"

ImClt *ImCltRoll( srcClt, nEntries, dstClt )
	ImClt	*srcClt ;
	int	nEntries;
	ImClt	*dstClt ;
.fi
\fR
.SH DESCRIPTION
\fBImCltRoll\fR rolls, or cycles, a \fIsrcClt\fR color lookup table's entries by
\fInEntries\fR entries and saves the results into \fIdstClt\fR.
A pointer to the destination CLT is returned.
.LP
Sometimes rgb images have color lookup tables.  When you rotate the color lookuptable you may not perceive any changes in the image since some displaying 
programs may throw this color lookup table out and use just the rgb 
information.
.LP
Rolling a CLT copies entry 0 to entry \fInEntries\fR, entry 1 to entry
\fInEntries\fR+1, entry 2 to entry \fInEntries\fR+2 and so on.  Entries
that roll off the bottom of the CLT wrap around and
are placed at the top of the CLT, creating
a rolling, or cycling effect in the copy.
.LP
\fIdstClt\fR is the CLT to contain the rolled color lookup table.
If \fIdstClt\fR is the constant \fBIMCLTNEW\fR, a new CLT is allocated 
with the same size as \fIsrcClt\fR.  A pointer to the new CLT is returned.
.LP
Otherwise, color lookup table entries in \fIsrcClt\fR are rolled and copied
into \fIdstClt\fR.  \fIdstClt\fR must have the same number of CLT entries
as \fIsrcClt\fR.
.LP
Positive values of \fInEntries\fR roll the CLT towards the bottom, while
negative values roll it towards the top.
.SH NOTES
\fIsrcClt\fR and \fIdstClt\fR may be the same CLT without unpleasant
side-effects.
.LP
To associate the new CLT with an image, use \fBImVfbSClt\fR(3IM).
.LP
CLT rolling is a technique used to find and
highlight aspects of an image, such as
one generated by a CAT-scan.  For example, different color indexes in a
CAT-scan correspond to different types of matter, such as bone, muscle,
and air.  To highlight just the bone, a CLT may be constructed that sets
a range of color indexes to, say bright red, and the rest to black.
.LP
When the red range of the CLT corresponds to the CAT-scan's bone
indexes, then all boney matter in the image is highlighted in red.
To highlight a different set of image color indexes, roll the CLT far
enough to bring the reds into the right index range, such as those for muscle.
By sweeping the red values back and forth through the CLT, one can zero in
on color indexes of interest.
.LP
In typical use, an interactive tool would display a color indexed image
and create such a red-and-black CLT for it.  As a slider widget is dragged
back and forth, the image's CLT is rolled back and forth, with the image
redisplayed each time the CLT is changed.
.SH RETURNS
Upon success, \fBImCltRoll\fR returns a pointer to the destination CLT.
Upon failure, \fBIMCLTNULL\fR is returned and \fBImErrNo\fR set
to one of the following:
.LP
.RS 0.5i
.TS
l l.
\fBIMEMALLOC\fR	Cannot allocate enough memory for \fIdstClt\fR
\fBIMENOCLT\fR	\fIsrcClt\fR is \fBIMCLTNULL\fR
.TE
.RE
.SH SEE ALSO
\fBImIntro\fR (3IM),
\fBImErrNo\fR (3IM),
\fBimcltroll\fR (1IM),
\fBImVfbRoll\fR (3IM)
.SH AUTHORS
Chris Groening and Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br

