'\"et
.if t .TH IMSCALE 1IM "October 13, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMSCALE 1IM "October 13, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imscale  -  Scales an image up or down and saves it in a new file
.SH SYNOPSIS
\fBimscale\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimscale\fR scales an input image up or down to a new size and saves
the result in a new file.  If the input file contains multiple images,
each input image is scaled in the same way and is written to the output 
file.  The input and output image file formats may be different.
.SH OPTIONS
\fBimscale\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Manipulation	How the image can be manipulated
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.SS "Manipulation Options"
Images may be scaled in the X (horizontal) and Y (vertical) directions
by specifying a scale factor or the new image size:
.LP
.RS +0.5i
.TS
l l.
\fB-scale\fI xyf\fR	Scale horizontally and vertically by factor
\fB-xscale\fI xf\fR	Scale horizontally by factor
\fB-yscale\fI yf\fR	Scale vertically by factor
\fB-xsize\fI w\fR	Scale the image to a new size horizontally
\fB-ysize\fI h\fR	Scale the image to a new size vertically
.TE
.RE
.LP
\fB-scale\fR, \fB-xscale\fR and \fB-yscale\fR each take a positive
floating-point scale factor.
To increase the size of an image, use a scale factor greater than 1.0.
To decrease an image's size, use a scale factor less than 1.0.  The default
scale factor is 1.0 (no change).
.LP
\fB-xsize\fR and \fB-ysize\fR each take a positive integer image width or height
in pixels, respectively.  The incoming image is scaled up or down,
as necessary, to make it the desired size.  The default is to
leave the image size unchanged.
.LP
These four arguments may be given alone, or in combination with the
others as long as \fB-xscale\fR is not given with \fB-xsize\fR,
and \fB-yscale\fR is not given with \fB-ysize\fR.  \fB-scale\fR
cannot be used in combination with any of the other scale and size
arguments.
.LP
The algorithm used to resize the image may be controlled by:
.LP
.RS +0.5i
.TS
l l.
\fB-bilinear\fR	Use bilinear interpolation
\fB-pixelrep\fR	Use pixel replication
.TE
.RE
.LP
If no algorithm is selected, \fBimscale\fR defaults to bilinear interpolation.
.SH NOTES
.SS "Increasing Image Size"
.LP
Increasing the size of an image increases the number of pixels in the image.
The colors used by the new additional pixels are determined by
the resolution change algorithm chosen.
.LP
\fB-pixelrep\fR performs the pixel replication, a simple form of
resolution change.
Using pixel replication, doubling an image's size fills
in new pixels by copying, or replicating, adjacent pixels.  For instance,
an input image has the following scanline:
.LP
.in +0.5i
\fBA C E G I K M\fR
.in -0.5i
.LP
Each letter is a different color in the image.  When this
image is doubled in size using pixel replication, each pixel on the
scanline becomes two pixels, both with the same color.  The resized
scanline will be:
.LP
.in +0.5i
\fBA A C C E E G G I I K K M M\fR
.in -0.5i
.LP
This has an effect similar to looking at the image with a magnifying glass.
Small pixels become big pixels; small jaggies become big jaggies.
.LP
\fB-pixelrep\fR may only be used when the new image width and
height are each multiples of the input image width and height.  If they
are not, \fBimscale\fR will exit with an error.
.LP
\fB-bilinear\fR performs bilinear interpolation to increase the image
size.  This method resamples the input image by
overlaying atop the input image a mathematical grid with \fIwidth x height\fR
points.  This gives one
grid point for each pixel in the output image.  The input image is
then sampled at each grid point to determine the output image's
pixel colors.  Where grid points lie directly over the center of a source
pixel, the grid point's color is that of the source pixel.  Where grid points
lie between input pixel centers, the grid point's color is determined by
linearly interpolating between adjacent pixel colors (vertically and
horizontally).  For instance, an input image has the following scanline:
.LP
.in +0.5i
\fBA C E G I K M\fR
.in -0.5i
.LP
Each letter is a different color in the image.  To double this image's size,
a mathematical grid will be overlaid.  Gridpoints will fall on the center
of pixel 'A,' halfway between pixel 'A' and 'C,' on the center of
pixel 'C,' and so on.  Output image pixels for gridpoints centered
on 'A,' 'C,' 'E,' etc., will have those pixel's colors.  Output image
pixels for gridpoints in-between 'A,' 'C,' 'E,' etc., will have colors
interpolated between 'A' and 'C,' 'C' and 'E,' and so on.  The resized
scanline will be:
.LP
.in +0.5i
\fBA B C D E F G H I J K L M N\fR
.in -0.5i
.LP
When using bilinear interpolation, the larger resized image will appear
blurry.  Hard edges become softer and jaggies less obvious.  Bilinear
interpolation is the default if neither \fB-bilinear\fR or \fB-pixelrep\fR
options are given.
.LP
\fB-bilinear\fR may be used for scaling an image up by any arbitrary
scaling factor.  It is not limited to multiples of the source image size,
as is \fB-pixelrep\fR.
.SS "Decreasing Image Size"
.LP
Decreasing the size of an image decreases the number of pixels in the
image.  The choice of how to color the pixels that remain
depends upon the resizing algorithm chosen.
.LP
\fB-pixelrep\fR is only applicable to increasing image size.  The
algorithm may not be used when the image size is being decreased.
\fBimscale\fR will exit with an error if \fB-pixelrep\fR is used when
decreasing an image's size.
.LP
\fB-bilinear\fR may be used to decrease an image's size using
bilinear interpolation.  Pixel values in the resulting smaller image will
be determined by interpolating between pixel values in the input image
in much the same way used when increasing an image's size.
.LP
Bilinear
interpolation is the default if neither \fB-bilinear\fR or \fB-pixelrep\fR
options are given.
.SS "Misc"
Image scaling can take awhile, depending upon the size of the input image,
the size of the output image, and the resizing algorithm used.
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page for \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
To scale a 640x480 image up to 1280x1024 (non-uniform scaling) using
bilinear interpolation, use any of the following:
.RS 0.5i
.LP
.nf
\fBimscale small.pix -xscale 2.0 -yscale 2.133 large.pix\fR
    or
\fBimscale small.pix -xsize 1280 -ysize 1024 large.pix\fR
    or
\fBimscale small.pix -xsize 1280 -ysize 1024 -bilinear large.pix\fR
.fi
.RE
.LP
To scale a 640x480 image up to 1280x960 (uniform scaling) using pixel
replication, use:
.RS 0.5i
.LP
.nf
\fBimscale small.pix -scale 2.0 -pixelrep large.pix\fR
    or 
\fBimscale small.pix -xscale 2.0 -yscale 2.0 -pixelrep large.pix\fR
.fi
.RE
.LP
To scale the same image up using bilinear interpolation instead, use any
of the following:
.RS 0.5i
.LP
.nf
\fBimscale small.pix -scale 2.0 -bilinear large.pix\fR
    or 
\fBimscale small.pix -scale 2.0 large.pix\fR
    or 
\fBimscale small.pix -xscale 2.0 -yscale 2.0 -bilinear large.pix\fR
    or 
\fBimscale small.pix -xscale 2.0 -yscale 2.0 large.pix\fR
.fi
.RE
.LP
To reduce an image to 1/3 its original size in X, and scale it up or down
to 500 pixels high in Y, using bilinear interpolation, use the following:
.RS 0.5i
.LP
\fBimscale original.rla -xscale 0.333 -ysize 500 sized.tiff\fR
.RE
.LP
To copy an entire input GIF image to a PCX file, without scaling,
use the following:
.RS 0.5i
.LP
\fBimscale incoming.gif outgoing.pcx\fR
.RE
.LP
With no scaling arguments, the actions of \fBimscale\fR default to the
same as the SDSC image format conversion tool \fBimconv\fR(1IM), but they
take a little longer.
.SH "SEE ALSO"
\fBimcopy\fR (1IM),
\fBimflip\fR (1IM),
\fBimrotate\fR (1IM),
\fBimroll\fR (1IM),
\fBimshear\fR (1IM),
\fBImVfbResize\fR (3IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHOR
Dave Nadeau, Chris Groening, and Toan-Vinh Le
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im," followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
