'\"et
.if t .TH IMROTATE 1IM "November 24, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMROTATE 1IM "November 24, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
imrotate  -  rotate an image
.SH SYNOPSIS
\fBimrotate\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
.LP
\fBimrotate\fR reads each image in the input file, rotates it,
then writes it to the output file.
The input and output image file formats may be different.
.SH OPTIONS
\fBimrotate\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Rotation	How the image should be rotated
Filling	How to fill in blank corners in the rotated image
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.LP
.SS "Rotation Options"
.IP "\fB-rotate\fR \fIdegrees\fR"
The \fB-rotate\fR option selects the number of degrees by which to rotate
the image.  Degree values may be positive or negative floating point angles.
Using the right-hand rule, positive values rotate the image counter-clockwise
while negative values rotate the image clockwise.
.IP " "
If \fB-rotate\fR is not given, \fBimrotate\fR does not rotate the image at
all and its actions default to an expensive copy of the image from the
input file to the output file.
.LP
.SS "Filling Options"
.LP
Rotating an image creates a non-axis-aligned rectangle (image edges are
diagonal rather than horizontal and vertical).  Pixel storage,
however, must be into axis-aligned rectangles (horizontal and vertical edges
only).  So, \fBimrotate\fR copies the rotated image into a larger
background axis-aligned rectangle and stores the result to the output file.
.LP
The placement of the rotated image into a background axis-aligned rectangular
image leaves the four triangular
image corners empty.  These empty corners may be filled
in using a variety of fill options similar to those found on \fBimfill\fR.
.LP
Fill options allow specific image channels to be filled with single values
or a range of values in a horizontal or vertical gradient.
.LP
Fill values are selected using one or more of the following fill options:
.RS 0.5i
.LP
.ne 2.0i
.TS
l l.
\fBOption	Fill each pixel's\fR
_
\fB-red \fIrange	\fRred component
\fB-green \fIrange	\fRgreen component
\fB-blue \fIrange	\fRblue component
_
\fB-mono \fIrange	\fRmonochrome component
\fB-index \fIrange	\fRcolor index component
_
\fB-hue \fIrange	\fRhue component
\fB-saturation \fIrange	\fRsaturation component
\fB-intensity \fIrange	\fRintensity component
_
\fB-alpha \fIrange	\fRalpha compoent
.TE
.RE
.LP
Multiple fill options may be given, as long as color spaces are not mixed.
For instance, \fB-index\fR for filling color indexes is incompatible with
\fB-red\fR for filling the red component of RGB triplets.  Likewise,
\fB-hue\fR for filling pixels based upon an HSI color space
hue value is incompatible
with \fB-blue\fR for filling with blue in the RGB color space.
See the \fBimintro\fR(3IM) \fBman\fR page for a description of the RGB
and HSI color spaces.
.LP
If \fBimrotate\fR is directed to fill the alpha component of an image that
does not have an alpha channel, an alpha channel is created and initialized
to 0s (transparent).
.LP
If \fBimrotate\fR is directed to fill a pixel component that does not exist
in the input image (except for alpha), an error is reported.
.LP
Input image components not selected for filling by a fill option are
initialized to zeroes.
.LP
Each of the fill options can accept an argument giving a single value, or
range of values with which to fill.
Value \fIrange\fR syntax takes any one of the following forms:
.RS 0.5i
.LP
.TS
l l.
\fIrange\fR	\fBFill with values of\fR
_
\fIn\fR	\fIn\fR only.
\fIn-\fR	\fIn\fR through the maximum legal value for the component.
\fIn-m\fR	\fIn\fR through \fIm\fR.
.TE
.RE
.LP
There is no space between \fIn\fR, the dash, and \fIm\fR.  \fIn\fR need not
be a value less than \fIm\fR.
.LP
When filling with a single value, the entire background rectnagle
is set to the same value.
.LP
When a range of fill values are given, such as \fB-red 0-255\fR
or \fB-intensity 0.6-0.2\fR, the fill region will be filled with a
gradation, or ramp, as selected by the \fB-graduate\fR option's argument:
.RS 0.5i
.LP
.TS
l l.
\fBoption\fR	\fBMeaning\fR
_
\fB-graduate none\fR	Fill with a constant value
\fB-graduate horizontal\fR	Fill with a horizontal ramp (default)
\fB-graduate vertical\fR	Fill with a vertical ramp
.TE
.RE
.LP
\fBnone\fR, \fBhorizontal\fR, and \fBvertical\fR may each be abbreviated
to the fewest unique letters.
.LP
The horizontal ramp for a graduated fill starts from the first fill 
value at the left edge of the image and goes to the second fill 
value at the right edge.  The vertical ramp for a graduated fill 
goes from the first fill value at the top edge of the image to 
the second fill value at the bottom edge.
.LP
.SH NOTES
\fBimrotate\fR's fill options may used for a variety of effects.  In the
simplest case, the fill options may be set to fill the image corners with a
color that matches the background color of the rotated image.
.LP
In a more complex use of \fBimrotate\fR's fill options, the background corners
may be set to transparent alpha channel values.  Then, using the Image Tools
digital compositor \fBimcomp\fR(1IM), the rotated image can be composited onto
a background image of arbitrary complexity.
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
Rotate an image 170 degrees:
.RS 0.5i
.RE
\fBimrotate image.rgb -rotate 170 rotated_image.rgb\fR
.RE
.LP
Rotate an image 45 dgrees and fill the corners with bright red and alpha
of 128:
.RS 0.5i
.LP
\fBimrotate image.ras -rotate 45 -red 255 -alpha 128 rotated.ras\fR
.RE
.LP
Rotate an image -60 degrees and fill with a hue of 120.0, a saturation
of 1.0, and an intensity of 0.5:
.RS 0.5i
.LP
\fBimrotate image.ras -rotate -60 -hue 120 -sat 1.0 -inten 0.5 rotated.ras 
.RE
.SH "SEE ALSO"
\fBimcopy\fR(1IM),
\fBimflip\fR(1IM),
\fBimroll\fR(1IM),
\fBimshear\fR(1IM),
\fBimscale\fR(1IM),
\fBImVfbRotate\fR(3IM),
\fBImVfbXShear\fR(3IM),
\fBImVfbYShear\fR(3IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
