'\"et
.if t .TH IMMONO 1IM "August 26, 1992" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMMONO 1IM "August 26, 1992" "SDSC" "IMAGE TOOLS"
.SH NAME
immono  -  Convert an image to monochrome
.SH SYNOPSIS
\fBimmono\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimmono\fR converts an input image to monochrome, then writes
it to an output image file.  If the input file contains multiple images,
\fBimmono\fR converts each one and writes it to the output file.
The input and output image file formats may be different.
.SH OPTIONS
\fBimmono\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Manipulation	How the image can be manipulated
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.SS "Manipulation Options"
Conversion of an input image to monochrome is a two-step process:
.LP
.RS +0.5i
.TS
l l.
1.	Convert the color image to grayscale.
2.	Convert the grayscale image to monochrome.
.TE
.RE
.LP
In step 1,
conversion from color to grayscale computes the gray value for each pixel
using the NTSC Y equation:
.sp 1
.ce
.EQ
Gray ~~=~~ 0.30*R ~+~ 0.59*G ~+~ 0.11*B
.EN
.LP
In step 2, conversion from grayscale pixel values (0-255) to monochrome
pixel values (0 or 1) uses a simple thresholding technique.  Pixel values
equal to or higher than the threshold are considered white.  Pixel values below
the threshold are considered black.
.LP
By default, the threshold is set at 127.  This threshold may be selected
explicitly using \fB-threshold\fR followed by a positive integer.
.SH NOTES
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
To convert an RGB Alias \fBpix\fR file image to monochrome and store it
in a Sun \fBras\fR file, enter any of the following command lines:
.RS 0.5i
.LP
.nf
\fBimmono picture.pix picture.ras\fR
    or
\fBimmono -pix picture.pix -ras picture.ras\fR
    or
\fBimmono -pix - picture.ras < picture.pix\fR
    or
\fBimmono -pix picture.pix -ras - > picture.ras\fR
    or
\fBimmono -pix - -ras - < picture.pix > picture.ras\fR
    or
\fBcat picture.pix | immono -pix - -ras - | cat > picture.ras\fR
.fi
.RE
.SH "SEE ALSO"
\fBimconv\fR (1IM),
\fBimfile\fR (1IM),
\fBimformat\fR (1IM),
\fBimgray\fR (1IM),
\fBImVfbToMono\fR (3IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimbmp\fR (3IM),
\fBimcur\fR (3IM),
\fBimeps\fR (3IM),
\fBimgif\fR (3IM),
\fBimhdf\fR (3IM),
\fBimico\fR (3IM),
\fBimicon\fR (3IM),
\fBimiff\fR (3IM),
\fBimmpnt\fR (3IM),
\fBimpbm\fR (3IM),
\fBimpcx\fR (3IM),
\fBimpgm\fR (3IM),
\fBimpic\fR (3IM),
\fBimpict\fR (3IM),
\fBimpix\fR (3IM),
\fBimpnm\fR (3IM),
\fBimppm\fR (3IM),
\fBimps\fR (3IM),
\fBimras\fR (3IM),
\fBimrgb\fR (3IM),
\fBimrla\fR (3IM),
\fBimrle\fR (3IM),
\fBimrpbm\fR (3IM),
\fBimrpgm\fR (3IM),
\fBimrpnm\fR (3IM),
\fBimrppm\fR (3IM),
\fBimsynu\fR (3IM),
\fBimtga\fR (3IM),
\fBimtiff\fR (3IM),
\fBimviff\fR (3IM),
\fBimx\fR (3IM),
\fBimxbm\fR (3IM),
\fBimxwd\fR (3IM)
.SH "KNOWN PROBLEMS"
Dithering should be supported.
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
