/* SCCS @(#)transvois.c	1.1  12/2/92 */
/*****************************************************************************/
/* module transvois.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

#define  A   01
#define  B   02
#define  C   04
#define  D   010
#define  A1  02
#define  A2  020
#define  A3  040
#define  A4  0100
#define  A5  0200
#define  A6  04
#define  B1  0400
#define  B2  01000
#define  B3  020
#define  B4  01
#define  B5  04
#define  B6  010
#define  C1  010
#define  C2  02
#define  C3  01
#define  C4  0200
#define  C5  02000
#define  C6  04000
#define  D1  010000
#define  D2  0400
#define  D3  02
#define  D4  04
#define  D5  04000
#define  D6  020000

#define  X   01
#define  X1  02
#define  X2  04
#define  X3  010
#define  X4  020
#define  X5  040
#define  X6  0100

#define ABCD 017
#define ABCD_VOIS 037777

#define A_VOISINS 0366
#define B_VOISINS 01435
#define C_VOISINS 06213
#define D_VOISINS 034406


#define INFINI  -1
#define NULL    0
#define MAX_OP  12

extern unsigned short **liste_point;

static unsigned short A0_mask[MAX_OP], A1_mask[MAX_OP], 
                      B0_mask[MAX_OP], B1_mask[MAX_OP], 
                      C0_mask[MAX_OP], C1_mask[MAX_OP], 
                      D0_mask[MAX_OP], D1_mask[MAX_OP];
                

mask_vois(x0_mask, x1_mask, i)
unsigned short x0_mask,  x1_mask;
short  i;
{
    A1_mask[i] = 0;  B1_mask[i] = 0;
    C1_mask[i] = 0;  D1_mask[i] = 0;
    A0_mask[i] = 0;  B0_mask[i] = 0;
    C0_mask[i] = 0;  D0_mask[i] = 0;

    if(( x1_mask & X) == X)
       {
	   A1_mask[i] += A;     B1_mask[i] += B;
           C1_mask[i] += C;     D1_mask[i] += D;
       }
    if(( x0_mask & X) == X)
       {
	   A0_mask[i] += A;     B0_mask[i] += B;
           C0_mask[i] += C;     D0_mask[i] += D;
       } 

    if(( x1_mask & X1) == X1)
       {
	   A1_mask[i] += A1;     B1_mask[i] += B1;
           C1_mask[i] += C1;     D1_mask[i] += D1;
       }
    if(( x0_mask & X1) == X1)
       {
	   A0_mask[i] += A1;     B0_mask[i] += B1;
           C0_mask[i] += C1;     D0_mask[i] += D1;
       }

    if(( x1_mask & X2) == X2)
       {
	   A1_mask[i] += A2;     B1_mask[i] += B2;
           C1_mask[i] += C2;     D1_mask[i] += D2;
       }
    if(( x0_mask & X2) == X2)
       {
	   A0_mask[i] += A2;     B0_mask[i] += B2;
           C0_mask[i] += C2;     D0_mask[i] += D2;
       }

    if(( x1_mask & X3) == X3)
       {
	   A1_mask[i] += A3;     B1_mask[i] += B3;
           C1_mask[i] += C3;     D1_mask[i] += D3;
       }
    if(( x0_mask & X3) == X3)
       {
	   A0_mask[i] += A3;     B0_mask[i] += B3;
           C0_mask[i] += C3;     D0_mask[i] += D3;
       }

    if(( x1_mask & X4) == X4)
       {
	   A1_mask[i] += A4;     B1_mask[i] += B4;
           C1_mask[i] += C4;     D1_mask[i] += D4;
       }
    if(( x0_mask & X4) == X4)
       {
	   A0_mask[i] += A4;     B0_mask[i] += B4;
           C0_mask[i] += C4;     D0_mask[i] += D4;
       }

    if(( x1_mask & X5) == X5)
       {
	   A1_mask[i] += A5;     B1_mask[i] += B5;
           C1_mask[i] += C5;     D1_mask[i] += D5;
       }
    if(( x0_mask & X5) == X5)
       {
	   A0_mask[i] += A5;     B0_mask[i] += B5;
           C0_mask[i] += C5;     D0_mask[i] += D5;
       }

    if(( x1_mask & X6) == X6)
       {
	   A1_mask[i] += A6;     B1_mask[i] += B6;
           C1_mask[i] += C6;     D1_mask[i] += D6;
       }
    if(( x0_mask & X6) == X6)
       {
	   A0_mask[i] += A6;     B0_mask[i] += B6;
           C0_mask[i] += C6;     D0_mask[i] += D6;
       }

} /* end mask_vois */
 



long ab_transvois(nl, nc, image, num)
/* amincissement binaire de taille 1 */
int nl, nc;
unsigned short **image;
short  num;
{
  unsigned short **liste;
  unsigned short *c_liste;
  int i;
  register int j;
  register unsigned short *point;
  unsigned short pt, **ima;
  long n = 0;                  /* nombre de points qui changent */
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            pt = *point;

            if(( pt & ABCD ) != 0) 
                 /* exclu le cas A=B=C=D=0 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if((pt & A) == A)     /* A=1  */ 
                   {
                      if((( pt & A1_mask[num]) == A1_mask[num]) && (pt | ~A0_mask[num]) == ~A0_mask[num])
                           {
		              *point -= A;  /* A -> 0 */
                              *c_liste += A;
			   }
		   }
                 if((pt & B) == B)     /* B=1  */ 
                   {
                      if((( pt & B1_mask[num]) == B1_mask[num]) && (pt | ~B0_mask[num]) == ~B0_mask[num])
                           {
		              *point -= B;  /* B -> 0 */
                              *c_liste += B;
			   }
		   }
                 if((pt & C) == C)     /* C=1  */ 
                   {
                      if((( pt & C1_mask[num]) == C1_mask[num]) && (pt | ~C0_mask[num]) == ~C0_mask[num])
                           {
		              *point -= C;  /* C -> 0 */
                              *c_liste += C;
			   }
		   }
                 if((pt & D) == D)     /* D=1  */ 
                   {
                      if((( pt & D1_mask[num]) == D1_mask[num]) && (pt | ~D0_mask[num]) == ~D0_mask[num])
                           {
		              *point -= D;  /* D -> 0 */
                              *c_liste += D;
			   }
		   } 

                 if((*c_liste & ABCD) != 0 )
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
   {
       x0_voisins(nl, ima, liste_point);
   }
return(n);

} /* ab_transvois */


a_transvois(nl, nc, image, taille, x0_mask, x1_mask, n_op)
int nl, nc;
unsigned short **image , x0_mask[MAX_OP],  x1_mask[MAX_OP];
short taille ,  n_op;
{
  int i, j;
  long n = 1;

  for( i = 0; i < n_op; i++)
      {
	  mask_vois(x0_mask[i], x1_mask[i], i);
      }

  if(taille == INFINI)
     {
	 while( n != 0 )
             {
		 n = 0;
                 for( i = 0; i < n_op; i++)
                     {
			 n += ab_transvois(nl, nc, image, i);
		     }
	     }
     }
  else
     {
          for( j=1; j<=taille; j++)
             {
                 n = 0;
                 for( i = 0; i < n_op; i++)
        	     { 
                        n += ab_transvois(nl, nc, image, i);
		     }
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end a_transvois */ 


/****************************************************************/

long eb_transvois(nl, nc, image, num)
/* epaississement binaire de taille 1 */
int nl, nc;
unsigned short **image;
short  num;
{
  unsigned short **liste;
  unsigned short *c_liste;
  int i;
  register int j;
  register unsigned short *point;
  unsigned short pt, **ima;
  long n = 0;                  /* nombre de points qui changent */
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            pt = *point;

            if((( pt & ABCD ) != ABCD ) && ( pt & ABCD_VOIS)!= 0) 
                 /* exclu le cas A=B=C=D=1 et ABCD+Voisins = 0 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if((pt & A) != A)     /* A=0  */ 
                   {
                      if((( pt & A1_mask[num]) == A1_mask[num]) && (pt | ~A0_mask[num]) == ~A0_mask[num])
                           {
		              *point += A;  /* A -> 1 */
                              *c_liste += A;
			   }
		   }
                 if((pt & B) != B)     /* B=0  */ 
                   {
                      if((( pt & B1_mask[num]) == B1_mask[num]) && (pt | ~B0_mask[num]) == ~B0_mask[num])
                           {
		              *point += B;  /* B -> 1 */
                              *c_liste += B;
			   }
		   }
                 if((pt & C) != C)     /* C=0  */ 
                   {
                      if((( pt & C1_mask[num]) == C1_mask[num]) && (pt | ~C0_mask[num]) == ~C0_mask[num])
                           {
		              *point += C;  /* C -> 1 */
                              *c_liste += C;
			   }
		   }
                 if((pt & D) != D)     /* D=0  */ 
                   {
                      if((( pt & D1_mask[num]) == D1_mask[num]) && (pt | ~D0_mask[num]) == ~D0_mask[num])
                           {
		              *point += D;  /* D -> 1 */
                              *c_liste += D;
			   }
		   } 

                 if((*c_liste & ABCD) != 0 )
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
   {
       x1_voisins(nl, ima, liste_point);
   }
return(n);

} /* eb_transvois */


e_transvois(nl, nc, image, taille, x0_mask, x1_mask, n_op)
int nl, nc;
unsigned short **image,  x0_mask[MAX_OP],  x1_mask[MAX_OP];
short taille,  n_op;
{
  int i, j;
  long n = 1;

  for( i = 0; i < n_op; i++)
      {
	  mask_vois(x0_mask[i], x1_mask[i], i);
      }

  if(taille == INFINI)
     {
	 while( n != 0 )
             {
		 n = 0;
                 for( i = 0; i < n_op; i++)
                     {
			 n += eb_transvois(nl, nc, image, i);
		     }
	     }
     }
  else
     {
          for( j=1; j<=taille; j++)
             {
                 n = 0;
                 for( i = 0; i < n_op; i++)
        	     { 
                        n += eb_transvois(nl, nc, image, i);
		     }
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end e_transvois */ 


/****************************************************************/

long t_transvois(nl, nc, image, x0_mask, x1_mask, n_op)
/* tout ou rien binaire */
int nl, nc;
unsigned short **image, x0_mask[MAX_OP],  x1_mask[MAX_OP];
short  n_op;
{
  unsigned short **liste;
  unsigned short *c_liste;
  int i, flag;
  register int j, num;
  register unsigned short *point;
  unsigned short pt, **ima;
  long n = 0;                  /* nombre de points qui changent */
    
  for( i = 0; i < n_op; i++)
      {
	  mask_vois(x0_mask[i], x1_mask[i], i);
      }

  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            pt = *point;

            if(( pt & ABCD ) != 0) 
                 /* exclu le cas A=B=C=D=0 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if((pt & A) == A)     /* A=1  */ 
                   {
                      flag = 1;
                      for( num = 0; num < n_op; num++)
                          {
                              if((( pt & A1_mask[num]) == A1_mask[num]) &&                                  (pt | ~A0_mask[num]) == ~A0_mask[num])
                                 {
                                    flag = 0;
                                    n++;
                                    break;
			         }
			  }
                      if(flag)
                         {
	         	            *point -= A;  /* A -> 0 */
                                    *c_liste += A;
			 }
		   }
                 if((pt & B) == B)     /* B=1  */ 
                   {
                      flag = 1;
                      for( num = 0; num < n_op; num++)
                          {
                              if((( pt & B1_mask[num]) == B1_mask[num]) &&                                   (pt | ~B0_mask[num]) == ~B0_mask[num])
                                 {
                                    flag = 0;
                                    n++;
                                    break;
			         }
			  }
                      if(flag)
                         {
	         	            *point -= B;  /* B -> 0 */
                                    *c_liste += B;
			 }
		   }
                 if((pt & C) == C)     /* C=1  */ 
                   {
                      flag = 1;
                      for( num = 0; num < n_op; num++)
                          {
                              if((( pt & C1_mask[num]) == C1_mask[num]) &&                                   (pt | ~C0_mask[num]) == ~C0_mask[num])
                                 {
                                    flag = 0;
                                    n++;
                                    break;
			         }
			  }
                      if(flag)
                         {
	         	            *point -= C;  /* C -> 0 */
                                    *c_liste += C;
			 }
		   }
                 if((pt & D) == D)     /* D=1  */ 
                   {
                      flag = 1;
                      for( num = 0; num < n_op; num++)
                          {
                              if((( pt & D1_mask[num]) == D1_mask[num]) &&                                   (pt | ~D0_mask[num]) == ~D0_mask[num])
                                 {
                                    flag = 0;
                                    n++;
                                    break;
			         }
			  }
                      if(flag)
                         {
	         	            *point -= D;  /* D -> 0 */
                                    *c_liste += D;
			 }
		   } 

                 if((*c_liste & ABCD) != 0 )
                   {
                      c_liste++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
   { 
       x0_voisins(nl, ima, liste_point);
   }
return(n);

} /* t_transvois */

/************************************************************************************/

long ab_condvois(nl, nc, image, ima_cond, num)
/* amincissement binaire de taille 1 */
int nl, nc;
unsigned short **image, **ima_cond;
short  num;
{
  unsigned short **liste;
  unsigned short *c_liste;
  int i;
  register int j;
  register unsigned short *point, *point_cond;
  unsigned short pt, pt_cond, **ima;
  long n = 0;                  /* nombre de points qui changent */
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  ima_cond++;
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      point_cond = *ima_cond++;
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            point_cond++;
            pt = *point;
            pt_cond = *point_cond;

            if((( pt & ABCD ) != 0) && (( pt_cond & ABCD ) != ABCD)) 
                 /* exclu le cas A=B=C=D=0  et pt_cond = ABCD */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if(((pt & A) == A) && ((pt_cond & A) != A))     /* A=1 , pt_cond A = 0 */ 
                   {
                      if((( pt & A1_mask[num]) == A1_mask[num]) && (pt | ~A0_mask[num]) == ~A0_mask[num])
                           {
		              *point -= A;  /* A -> 0 */
                              *c_liste += A;
			   }
		   }
                 if(((pt & B) == B) && ((pt_cond & B) != B))     /* B=1 , pt_cond B = 0 */ 
                   {
                      if((( pt & B1_mask[num]) == B1_mask[num]) && (pt | ~B0_mask[num]) == ~B0_mask[num])
                           {
		              *point -= B;  /* B -> 0 */
                              *c_liste += B;
			   }
		   }
                 if(((pt & C) == C) && ((pt_cond & C) != C))     /* C=1 , pt_cond C = 0 */ 
                   {
                      if((( pt & C1_mask[num]) == C1_mask[num]) && (pt | ~C0_mask[num]) == ~C0_mask[num])
                           {
		              *point -= C;  /* C -> 0 */
                              *c_liste += C;
			   }
		   }
                 if(((pt & D) == D) && ((pt_cond & D) != D))     /* D=1 , pt_cond D = 0 */ 
                   {
                      if((( pt & D1_mask[num]) == D1_mask[num]) && (pt | ~D0_mask[num]) == ~D0_mask[num])
                           {
		              *point -= D;  /* D -> 0 */
                              *c_liste += D;
			   }
		   } 

                 if((*c_liste & ABCD) != 0 )
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
   {
       x0_voisins(nl, ima, liste_point);
   }
return(n);

} /* ab_condvois */


a_condvois(nl, nc, image, ima_cond, taille, x0_mask, x1_mask, n_op)
int nl, nc;
unsigned short **image , **ima_cond, x0_mask[MAX_OP],  x1_mask[MAX_OP];
short taille ,  n_op;
{
  int i, j;
  long n = 1;

  for( i = 0; i < n_op; i++)
      {
	  mask_vois(x0_mask[i], x1_mask[i], i);
      }

  if(taille == INFINI)
     {
	 while( n != 0 )
             {
		 n = 0;
                 for( i = 0; i < n_op; i++)
                     {
			 n += ab_condvois(nl, nc, image, ima_cond, i);
		     }
	     }
     }
  else
     {
          for( j=1; j<=taille; j++)
             {
                 n = 0;
                 for( i = 0; i < n_op; i++)
        	     { 
                        n += ab_condvois(nl, nc, image, ima_cond, i);
		     }
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end a_condvois */ 


/************************************************************************************/

long eb_condvois(nl, nc, image, ima_cond, num)
/* amincissement binaire de taille 1 */
int nl, nc;
unsigned short **image, **ima_cond;
short  num;
{
  unsigned short **liste;
  unsigned short *c_liste;
  int i;
  register int j;
  register unsigned short *point, *point_cond;
  unsigned short pt, pt_cond, **ima;
  long n = 0;                  /* nombre de points qui changent */
    
  liste = liste_point;
  ima = image;
  image++;               /* premiere ligne */
  ima_cond++;
  for(i=1;i<=nl;i++)
    { 
      point = *image++;    /* ligne suivante */
      point_cond = *ima_cond++;
      c_liste = *liste++;
      for(j=1;j<=nc;j++)
          {
            point++;         /*  colonne suivante */
            point_cond++;
            pt = *point;
            pt_cond = *point_cond;

            if((( pt & ABCD ) != ABCD) && (( pt_cond & ABCD ) != 0)) 
                 /* exclu le cas A=B=C=D=1  et pt_cond = 0 */
              {
                 *c_liste = ( j << 4);  /* deplacement */

                 if(((pt & A) != A) && ((pt_cond & A) == A))     /* A=0 , pt_cond A = 1 */ 
                   {
                      if((( pt & A1_mask[num]) == A1_mask[num]) && (pt | ~A0_mask[num]) == ~A0_mask[num])
                           {
		              *point += A;  /* A -> 1 */
                              *c_liste += A;
			   }
		   }
                 if(((pt & B) != B) && ((pt_cond & B) == B))     /* B=0 , pt_cond B = 1 */ 
                   {
                      if((( pt & B1_mask[num]) == B1_mask[num]) && (pt | ~B0_mask[num]) == ~B0_mask[num])
                           {
		              *point += B;  /* B -> 1 */
                              *c_liste += B;
			   }
		   }
                 if(((pt & C) != C) && ((pt_cond & C) == C))     /* C=0 , pt_cond C = 1 */ 
                   {
                      if((( pt & C1_mask[num]) == C1_mask[num]) && (pt | ~C0_mask[num]) == ~C0_mask[num])
                           {
		              *point += C;  /* C -> 1 */
                              *c_liste += C;
			   }
		   }
                 if(((pt & D) != D) && ((pt_cond & D) == D))     /* D=0 , pt_cond D = 1 */ 
                   {
                      if((( pt & D1_mask[num]) == D1_mask[num]) && (pt | ~D0_mask[num]) == ~D0_mask[num])
                           {
		              *point += D;  /* D -> 1 */
                              *c_liste += D;
			   }
		   } 

                 if((*c_liste & ABCD) != 0 )
                   {
                      c_liste++;
                      n++;
		   }
	      }
          }   /* for j */

      *c_liste = 0;
  
    }   /* for i */
if(n != 0)
   {
       x1_voisins(nl, ima, liste_point);
   }
return(n);

} /* eb_condvois */


e_condvois(nl, nc, image, ima_cond, taille, x0_mask, x1_mask, n_op)
int nl, nc;
unsigned short **image , **ima_cond, x0_mask[MAX_OP],  x1_mask[MAX_OP];
short taille ,  n_op;
{
  int i, j;
  long n = 1;

  for( i = 0; i < n_op; i++)
      {
	  mask_vois(x0_mask[i], x1_mask[i], i);
      }

  if(taille == INFINI)
     {
	 while( n != 0 )
             {
		 n = 0;
                 for( i = 0; i < n_op; i++)
                     {
			 n += eb_condvois(nl, nc, image, ima_cond, i);
		     }
	     }
     }
  else
     {
          for( j=1; j<=taille; j++)
             {
                 n = 0;
                 for( i = 0; i < n_op; i++)
        	     { 
                        n += eb_condvois(nl, nc, image, ima_cond, i);
		     }
                 if(n == 0)
                   {
	               break;
	           }
	     }
     }
} /* end e_condvois */ 








