/* TILE-Gx ELF support for BFD.
   Copyright (C) 2011-2024 Free Software Foundation, Inc.

   This file is part of BFD, the Binary File Descriptor library.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#ifndef _ELF_TILEGX_H
#define _ELF_TILEGX_H

#include "elf/reloc-macros.h"

/* Relocations.  */
START_RELOC_NUMBERS (elf_tilegx_reloc_type)
  RELOC_NUMBER (R_TILEGX_NONE,              0)

  /* Standard relocations */
  RELOC_NUMBER (R_TILEGX_64,                1)
  RELOC_NUMBER (R_TILEGX_32,                2)
  RELOC_NUMBER (R_TILEGX_16,                3)
  RELOC_NUMBER (R_TILEGX_8,                 4)
  RELOC_NUMBER (R_TILEGX_64_PCREL,          5)
  RELOC_NUMBER (R_TILEGX_32_PCREL,          6)
  RELOC_NUMBER (R_TILEGX_16_PCREL,          7)
  RELOC_NUMBER (R_TILEGX_8_PCREL,           8)

  /* Custom relocations */

  RELOC_NUMBER (R_TILEGX_HW0,               9)
  RELOC_NUMBER (R_TILEGX_HW1,               10)
  RELOC_NUMBER (R_TILEGX_HW2,               11)
  RELOC_NUMBER (R_TILEGX_HW3,               12)
  RELOC_NUMBER (R_TILEGX_HW0_LAST,          13)
  RELOC_NUMBER (R_TILEGX_HW1_LAST,          14)
  RELOC_NUMBER (R_TILEGX_HW2_LAST,          15)

  RELOC_NUMBER (R_TILEGX_COPY,              16)
  RELOC_NUMBER (R_TILEGX_GLOB_DAT,          17)
  RELOC_NUMBER (R_TILEGX_JMP_SLOT,          18)
  RELOC_NUMBER (R_TILEGX_RELATIVE,          19)

  /* Branch/jump offsets */
  RELOC_NUMBER (R_TILEGX_BROFF_X1,          20)
  RELOC_NUMBER (R_TILEGX_JUMPOFF_X1,        21)
  RELOC_NUMBER (R_TILEGX_JUMPOFF_X1_PLT,    22)

  /* Immediate operands. */
  RELOC_NUMBER (R_TILEGX_IMM8_X0,           23)
  RELOC_NUMBER (R_TILEGX_IMM8_Y0,           24)
  RELOC_NUMBER (R_TILEGX_IMM8_X1,           25)
  RELOC_NUMBER (R_TILEGX_IMM8_Y1,           26)
  RELOC_NUMBER (R_TILEGX_DEST_IMM8_X1,      27)
  RELOC_NUMBER (R_TILEGX_MT_IMM14_X1,       28)
  RELOC_NUMBER (R_TILEGX_MF_IMM14_X1,       29)
  RELOC_NUMBER (R_TILEGX_MMSTART_X0,        30)
  RELOC_NUMBER (R_TILEGX_MMEND_X0,          31)
  RELOC_NUMBER (R_TILEGX_SHAMT_X0,          32)
  RELOC_NUMBER (R_TILEGX_SHAMT_X1,          33)
  RELOC_NUMBER (R_TILEGX_SHAMT_Y0,          34)
  RELOC_NUMBER (R_TILEGX_SHAMT_Y1,          35)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0,       36)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0,       37)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1,       38)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1,       39)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW2,       40)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW2,       41)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW3,       42)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW3,       43)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_LAST,  44)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_LAST,  45)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_LAST,  46)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_LAST,  47)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW2_LAST,  48)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW2_LAST,  49)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_PCREL,        50)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_PCREL,        51)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_PCREL,        52)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_PCREL,        53)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW2_PCREL,        54)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW2_PCREL,        55)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW3_PCREL,        56)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW3_PCREL,        57)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_LAST_PCREL,   58)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_LAST_PCREL,   59)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_LAST_PCREL,   60)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_LAST_PCREL,   61)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW2_LAST_PCREL,   62)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW2_LAST_PCREL,   63)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_GOT,          64)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_GOT,          65)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_PLT_PCREL,    66)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_PLT_PCREL,    67)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_PLT_PCREL,    68)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_PLT_PCREL,    69)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW2_PLT_PCREL,    70)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW2_PLT_PCREL,    71)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_LAST_GOT,     72)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_LAST_GOT,     73)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_LAST_GOT,     74)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_LAST_GOT,     75)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW3_PLT_PCREL,    76)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW3_PLT_PCREL,    77)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_TLS_GD,       78)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_TLS_GD,       79)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_TLS_LE,       80)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_TLS_LE,       81)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_LAST_TLS_LE,  82)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_LAST_TLS_LE,  83)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_LAST_TLS_LE,  84)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_LAST_TLS_LE,  85)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_LAST_TLS_GD,  86)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_LAST_TLS_GD,  87)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_LAST_TLS_GD,  88)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_LAST_TLS_GD,  89)
  /* Relocs 90-91 are currently not defined.  */

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_TLS_IE,       92)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_TLS_IE,       93)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_LAST_PLT_PCREL, 94)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_LAST_PLT_PCREL, 95)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_LAST_PLT_PCREL, 96)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_LAST_PLT_PCREL, 97)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW2_LAST_PLT_PCREL, 98)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW2_LAST_PLT_PCREL, 99)

  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW0_LAST_TLS_IE, 100)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW0_LAST_TLS_IE, 101)
  RELOC_NUMBER (R_TILEGX_IMM16_X0_HW1_LAST_TLS_IE, 102)
  RELOC_NUMBER (R_TILEGX_IMM16_X1_HW1_LAST_TLS_IE, 103)
  /* Relocs 104-105 are currently not defined.  */

  RELOC_NUMBER (R_TILEGX_TLS_DTPMOD64,             106)
  RELOC_NUMBER (R_TILEGX_TLS_DTPOFF64,             107)
  RELOC_NUMBER (R_TILEGX_TLS_TPOFF64,              108)
  RELOC_NUMBER (R_TILEGX_TLS_DTPMOD32,             109)
  RELOC_NUMBER (R_TILEGX_TLS_DTPOFF32,             110)
  RELOC_NUMBER (R_TILEGX_TLS_TPOFF32,              111)

  RELOC_NUMBER (R_TILEGX_TLS_GD_CALL,              112)
  RELOC_NUMBER (R_TILEGX_IMM8_X0_TLS_GD_ADD,       113)
  RELOC_NUMBER (R_TILEGX_IMM8_X1_TLS_GD_ADD,       114)
  RELOC_NUMBER (R_TILEGX_IMM8_Y0_TLS_GD_ADD,       115)
  RELOC_NUMBER (R_TILEGX_IMM8_Y1_TLS_GD_ADD,       116)
  RELOC_NUMBER (R_TILEGX_TLS_IE_LOAD,              117)
  RELOC_NUMBER (R_TILEGX_IMM8_X0_TLS_ADD,          118)
  RELOC_NUMBER (R_TILEGX_IMM8_X1_TLS_ADD,          119)
  RELOC_NUMBER (R_TILEGX_IMM8_Y0_TLS_ADD,          120)
  RELOC_NUMBER (R_TILEGX_IMM8_Y1_TLS_ADD,          121)

/* These are GNU extensions to enable C++ vtable garbage collection.  */
  RELOC_NUMBER (R_TILEGX_GNU_VTINHERIT, 128)
  RELOC_NUMBER (R_TILEGX_GNU_VTENTRY, 129)
END_RELOC_NUMBERS (R_TILEGX_max)

#endif /* _ELF_TILEGX_H */
