/*---------------------------------------------
                 S I M P A C K
            Simulation Tool Package
        Copyright 1991, Paul A. Fishwick
---------------------------------------------*/

#define TRUE 1
#define FALSE 0
#define MAX_ORDER 2
#define INTERVALS_PER_UNIT 100
#define BUFFER_SIZE (INTERVALS_PER_UNIT * MAX_ORDER + 1)

float time,delta_time,in[2],out[2];
float a,f[2],savevar[2],buffer[BUFFER_SIZE];
int num_equations,ptr;

main()
{
  init_conditions();
  while (time < 5.0) {
   state_cont();
   integrate(); 
   state_disc();
   /* output time,x */
   printf("%f %f\n",time,out[1]);
  } /* end while */
} /* end main */

init_conditions()
{
  int i;
  out[1] = 1.0;
  ptr = BUFFER_SIZE - 1; 
  /* initialize the buffer */
  for (i=0;i<BUFFER_SIZE;i++)
    buffer[i] = 1.0;
  a = 1.0;
  delta_time = 1.0/INTERVALS_PER_UNIT;
  time = 0.0;
  num_equations = 1;
}

state_cont()
{ 
/* Calculate state: x' = a*x(t-1) */
 in[1] = a*buffer[t(-1)] + 0.8*buffer[t(-2)];
}


integrate()
{
  int i;

  for (i=1;i<=num_equations;i++) {
    f[i] = delta_time*in[i];
    savevar[i] = out[i];
    out[i] += f[i]/2;
  }
  time += delta_time/2;
  state_cont();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i]/2;
  }
  state_cont();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i];
  }
  time += delta_time/2;
  state_cont();

  for (i=1;i<=num_equations;i++) 
    out[i] = savevar[i] + (f[i] + delta_time*in[i])/6;
}

state_disc()
{ 
 ptr = (ptr + 1) % BUFFER_SIZE;
 buffer[ptr] = out[1];
}


int t(index)
int index;
{int new_pointer;
 new_pointer = ptr + index*INTERVALS_PER_UNIT;
 if (new_pointer < 0)
   return(BUFFER_SIZE + new_pointer);
 else
   return(new_pointer % BUFFER_SIZE);
}

