#include <stream.h>
#include <math.h>

float delta_time = 0.01;

// Base Class
class Block {
 public:
  float output;
  typedef Block *Input;
  Input *inputs;
  void virtual process(void) = 0;
  friend ostream& operator<<(ostream &, Block &);
};


//
// Constant Class
// 
class Constant : public Block {
public:
    Constant() { };
    Constant(float f) { output = f; };
    ~Constant(void) {};
    void process() {};
};

//
// Add Class
// 
class Add : public Block {
 public:
  Add();
  Add(Block&,Block&);
  ~Add(void);
  void process();

};

// Add constructors
Add::Add(void) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 output = 0;
}

Add::Add(Block& block1, Block& block2) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 output = 0;
 inputs[0] = &block1;  inputs[1] = &block2;
}

// Add destructor
Add::~Add(void) {delete inputs;}

// Add process
void Add::process(void) {
    this->output = inputs[0]->output + inputs[1]->output;
}

//
// Subtract Class
// 
class Subtract : public Block {
 public:
  Subtract();
  Subtract(Block&,Block&);
  ~Subtract(void);
  void process();

};

// Subtract constructors
Subtract::Subtract(void) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 output = 0;
}

Subtract::Subtract(Block& block1, Block& block2) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 inputs[0] = &block1;  inputs[1] = &block2;
 output = 0;
}

// Subtract destructor
Subtract::~Subtract(void) {delete inputs;}

// Add process
void Subtract::process(void) {
    this->output = inputs[0]->output - inputs[1]->output;
}

//
// Multiply Class
// 
class Multiply : public Block {
 public:
  Multiply();
  Multiply(Block&,Block&);
  ~Multiply(void);
  void process();

};

// Multiply constructors
Multiply::Multiply(void) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 output = 0;
}

Multiply::Multiply(Block& block1, Block& block2) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 inputs[0] = &block1;  inputs[1] = &block2;
 output = 0;
}

// Multiply destructor
Multiply::~Multiply(void) {delete inputs;}

// Multiply process
void Multiply::process(void) {
    this->output = inputs[0]->output * inputs[1]->output;
}

//
// Divide Class
// 
class Divide : public Block {
 public:
  Divide();
  Divide(Block&,Block&);
  ~Divide(void);
  void process();

};

// Divide constructors
Divide::Divide(void) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 output = 0;
}

Divide::Divide(Block& block1, Block& block2) {
 int num_inputs = 2;
 inputs = new Input[num_inputs];
 inputs[0] = &block1;  inputs[1] = &block2;
 output = 0;
}

// Divide destructor
Divide::~Divide(void) {delete inputs;}

// Divide process
void Divide::process(void) {
    this->output = inputs[0]->output / inputs[1]->output;
}

//
// Integrate Class
// 
class Integrate : public Block {
 public:
  Integrate(float);
  Integrate(Block&,float);
  ~Integrate(void);
  void process();

};

// Integrate constructors
Integrate::Integrate(float initial_value) {
 int num_inputs = 1;
 inputs = new Input[num_inputs];
 output = initial_value;
}

Integrate::Integrate(Block& block,float initial_value) {
 int num_inputs = 1;
 inputs = new Input[num_inputs];
 inputs[0] = &block;
 output = initial_value;
}

// Integrate destructor
Integrate::~Integrate(void) {delete inputs;}

// Integrate process
void Integrate::process(void) {
    this->output = this->output + inputs[0]->output * delta_time;
}

ostream& operator<<(ostream &o, Block &b)
{
    o << b.output;
    return o;
}

main()
{
  float time = 0.0,end_time = 20.0;
  // Specify block network topology
  Constant b1(-1);
  Multiply b2;
  Integrate b3(b2,1.0);
  Integrate b4(b3,1.0);
  b2.inputs[0] = &b3;
  b2.inputs[1] = &b1; 

  // Simulate network
  while (time < end_time) { 
   b1.process(); b2.process(); b3.process(); b4.process(); 
   /* output time,x */
   cout << time << " " << b4 << "\n"; 
   time += delta_time;
  }  // end while
} // end main 

 

