/*
 * File: main_loop.m.c
 *   By: Dave Hiebeler
 *       July 1989
 *
 * Generate a transition-table for Moore neighborhood
 */

#include <stdio.h>
#include <math.h>
#include "nborhood.h"

#define add_index(k)	index <<= L;  index |= k

func_ptr update_function;

main()
{
    char    *ta;			/* t-table array       */
    FILE   *fopen(), *fp;
    int L, N, TSIZE, index, AMASK;
    int     tl, l, bl, t, c, b, tr, r, br;
    moore_nbors nbors;


    L = (short) (log((double) NSTATES) / log((double) 2.0));
    N = 9;
    TSIZE = 1 << (L*N);
    AMASK = NSTATES-1;
    if ((ta=(char *)malloc(TSIZE))==NULL) {
	fprintf(stderr,"Couldn't malloc memory for table\n");
	exit(1);
    }
    printf("NSTATES = %d\n",NSTATES);
    init_function();
    for (tl = 0; tl < NSTATES; tl++)
     for (l = 0; l < NSTATES; l++)
      for (bl = 0; bl < NSTATES; bl++)
       for (t = 0; t < NSTATES; t++)
	for (c = 0; c < NSTATES; c++)
	 for (b = 0; b < NSTATES; b++)
	  for (tr = 0; tr < NSTATES; tr++)
	   for (r = 0; r < NSTATES; r++)
	    for (br = 0; br < NSTATES; br++) {

		index = 0;
		add_index(tl);
		add_index(l);
		add_index(bl);
		add_index(t);
		add_index(c);
		add_index(b);
		add_index(tr);
		add_index(r);
		add_index(br);

		nbors.tl = tl;
		nbors.l = l;
		nbors.bl = bl;
		nbors.t = t;
		nbors.c = c;
		nbors.b = b;
		nbors.tr = tr;
		nbors.r = r;
		nbors.br = br;
		ta[index] = (update_function(&nbors) & AMASK);

	    }


    fp = fopen(OUTPUT, "w");
    fwrite(ta, sizeof(*ta), TSIZE, fp);
    fclose(fp);

}
