/*****
 *
 * File: cellsock.c
 *
 * Cellsim, cellular automata simulator
 *
 * Handles socket functions for doing analysis of state-counts
 *
 *****/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#include "cell.def"

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/


static int sock;
extern int *statecount;
extern short S;

init_sock(hname, portnum)		/* create socket and connect to given port */
    char   *hname;			/* host name ("" = this machine) */
    int     portnum;			/* port number */
{
    struct sockaddr_in server;
    struct hostent *hp, *gethostbyname();
    char    hostname[BUFLEN];
    int     i, num;

    /* Create socket */
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
	perror("opening stream socket");
	exit(1);
    }
    /* Find hostname, if necessary */
    if (hname[0] == 0)
	gethostname(hostname, BUFLEN);
    else
	strncpy(hostname, hname, BUFLEN);

    /* Connect socket using name specified by command line. */
    server.sin_family = AF_INET;
    hp = gethostbyname(hostname);
    if (hp == 0) {
	fprintf(stderr, "%s: unknown host\n", hostname);
	exit(1);
    }
    bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
    server.sin_port = htons(portnum);

    if (connect(sock, &server, sizeof(server)) < 0) {
	perror("connecting stream socket");
	exit(1);
    }
    num = S;
    if (write(sock, (char *) &num, sizeof(num)) < 0)
	perror("writing on stream socket");
} /* init_sock */


send_sock()
{					/* send current statecounts across
					 * socket */
    int     i;
    if (write(sock, (char *) statecount, S * sizeof(*statecount)) < 0)
	perror("writing on stream socket");
}


quit_sock()
{					/* close socket */
    close(sock);
}
