/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/crypto/RCS/KeyFromPQ.c,v $
 *
 *
 *  MODULE NAME:    KeyFromPQ.c
 *
 *
 *  AUTHORS:
 *
 *	J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>

#include "BigNum.h"
#include "BigRSA.h"
#include "bigrsacode.h"
#include "bigkeygen.h"

#ifdef DEBUG
#undef DEBUG
#endif

/* given two primes in msb-lsg order, initialize the key structure */

int KeyFromPQ ( P, PL, Q, QL, keys )
char *P, *Q;
int PL, QL;
RSAKeyStorage *keys ;
{
    BigNum  p = keys->p, q = keys->q ;
    int i;
    char *x, *y;
    unsigned pl, ql;

    memset(keys,0,sizeof(RSAKeyStorage));
    BnnInit();

    DecodeBigInteger(P, p, PL);
    DecodeBigInteger(Q, q, QL);
 
    pl = BnnNumDigits(p, (PL+sizeof(BigNumDigit))/sizeof(BigNumDigit));
    ql = BnnNumDigits(q, (QL+sizeof(BigNumDigit))/sizeof(BigNumDigit));

    if (BnnCompare(p, pl, q, ql) == -1) {
        unsigned tpl = pl;
        BigNumDigit tp[DigitLim];
        BnnSetToZero(tp,DigitLim);
        BnnAssign(tp,p,pl);
        BnnSetToZero(p,pl);
        BnnAssign(p,q,ql);
        BnnAssign(q,tp,pl);
        pl = ql;
        ql = tpl;
    }

    keys->pl = pl;
    keys->ql = ql;

    BnnSetDigit(keys->e, (BigNumDigit) ((1<<16)+1));
    keys->el = 1;

    BnnMultiply(keys->n, pl+ql, p, pl, q, ql),
    keys->nl = pl+ql;

#ifdef DEBUG
PrintTestKey(keys);
#endif

    if (FinishKey(keys)==0) return (0);

    if (TestRSAKeys(keys)!=1) {
#ifdef DEBUG
printf("\nFailed.\n");
#endif
        return(0);
    }  

    BnnClose();
    return(1);
}


