/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/verify_response.c,v $
 *
 *
 *  MODULE NAME:    verify_response.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <syslog.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "spxapi_defs.h"
#include "objid.h"
#include "gssapi_defs.h"

int Sphinx_verify_response(context_handle, verifier_cred_opaque,
			   ta_verifier_cred_opaque, input_token,
			   input_tokenlen)
ContextHandle *context_handle;
char          *verifier_cred_opaque;
char          *ta_verifier_cred_opaque;
char  *input_token;
int   input_tokenlen;
{
  int status, i, header_len = 0;
  VerifierCred   *verifier_cred;
  TrustedCred    *ta_verifier_cred;
  RSAKeyStorage  claimantRSAKey;
  char           cdc_server[ANAME_SZ];

  verifier_cred = (VerifierCred *) verifier_cred_opaque;
  ta_verifier_cred = (TrustedCred *) ta_verifier_cred_opaque;

  if ((i = read_pub_key(context_handle->issuer_fn, &claimantRSAKey,
			ta_verifier_cred, cdc_server, 0)) <= 0) {
      switch(i) {
        case -1 :
                  return(SPX_S_VERIF_UNABLE_TO_ACCESS_CDC);
                  break;
        case -2 :
                  return(SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_DN);
                  break;
        case -3 :
                  return(SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_UP);
                  break;
        case -4 :
                  return(SPX_S_VERIF_TARGET_IN_UNKNOWN_DOMAIN);
                  break;
        case -5 :
                  return(SPX_S_VERIF_CERTIFS_DONT_EXIST_IN_CDC);
                  break;
        default :
                  return(SPX_S_VERIF_READ_PUB_KEY_ERROR);
                  break;
      }
  }

  if (RSAVerify(context_handle->mutual_resp, context_handle->mutual_len,
	    &claimantRSAKey, input_token, input_tokenlen) == 0) {
    return(SPX_S_ERROR_VERIFY_MUTUAL);
  }
  return(1);
}
