
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


/*
 * Include file with authentication protocol information.
 */

#include "cdc_conf.h"

#ifndef PROT_DEFS
#define PROT_DEFS

#define		CDC_PROT_VERSION 	1
#define 	MAX_PKT_LEN		1000

/* Macro's to obtain various fields from a packet */

#define req_pkt_version(packet)  (unsigned char) *(packet->dat)
#define req_pkt_msg_type(packet) (unsigned char) *(packet->dat+1)
#define req_pkt_index(packet) (unsigned char) *(packet->dat+2)
#define req_pkt_a_name(packet)   (packet->dat+3)

#define reply_pkt_version(packet)  (unsigned char) *(packet->dat)
#define reply_pkt_msg_type(packet) (unsigned char) *(packet->dat+1)
#define reply_pkt_index(packet)    (unsigned char) *(packet->dat+2)
#define reply_pkt_y_len(packet)    (short)( *(packet->dat+3) + *(packet->dat+4) * 256)
#define reply_pkt_y(packet) (char *) (packet->dat+5)

/* Routines to create and read packets may be found in prot.c */

KTEXT create_reply();

/* Message types , always leave lsb for byte order */

#define		READ_PRIVKEY_REQ			2<<1
#define 	READ_CERTIF_REQ				3<<1
#define		READ_TA_CERTIF_REQ			4<<1
#define		READ_FLAG_REQ				6<<1
#define		ADD_PRIVKEY_REQ				10<<1
#define 	ADD_CERTIF_REQ				11<<1
#define		ADD_TA_CERTIF_REQ			12<<1
#define		ADD_FLAG_REQ				14<<1
#define		ENROLL_OPEN_REQ				20<<1
#define		ENROLL_KEY_REQ				21<<1
#define		ENROLL_CERTIF_REQ			22<<1
#define		ENROLL_TA_CERTIF_REQ			23<<1
#define		ENROLL_CLOSE_REQ			24<<1
#define		CDC_MSG_REPLY				28<<1
#define		ERR_MSG_REPLY				29<<1

/* values for sphinx error codes */

#define		CDC_ERR_OK				 0
#define		CDC_ERR_NAME_EXP			 1
#define		CDC_ERR_PKT_VER 			 4
#define		CDC_ERR_BYTE_ORDER			 7
#define		CDC_ERR_PRINCIPAL_UNKNOWN		 8
#define		CDC_ERR_PRINCIPAL_NOT_UNIQUE		 9
#define		CDC_ERR_NULL_KEY			10

#endif /* PROT_DEFS */
