
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#ifndef	CDC_DEFS
#define CDC_DEFS
#define S_AD_SZ         sizeof(struct sockaddr_in)

/* Text describing error codes */
#define		MAX_CDC_ERRORS	256
extern char *cdc_err_txt[MAX_CDC_ERRORS];

/* General definitions */

#define		ASUCCESS	0
#define		AFAILURE	255

#define CDC_BUILD_REQ_ERROR	-11
#define CDC_UNAVAILABLE		-12
#define CDC_CHECK_RES_ERROR	-13	/*  format error w/ response msg  */
#define CDC_CHECK_RES_UNKNOWN	-14	/*  unknown error w/ response msg  */

#ifndef TRUE
#define         TRUE            1
#endif
#ifndef FALSE
#define         FALSE           0
#endif

#ifdef NO_UIDGID_T
typedef unsigned short uid_t;
typedef unsigned short gid_t;
#endif /* NO_UIDGID_T */

/*
 * SPHINX specific definitions 
 *
 * CDCLOG is the log file for the CDC master server. CDC_CONF is
 * the configuration file where different host machines running master
 * and slave servers can be found. CDC_MASTER is the name of the
 * machine with the master database.  The admin_server runs on this
 * machine, and all changes to the db (as opposed to read-only
 * requests, which can go to slaves) must go to it. CDC_HOST is the
 * default machine * when looking for a CDC slave server.  Other
 * possibilities are * in the CDC_CONF file. CDC_DOMAIN is the default
 * name of the domain. 
 */

#define		CDC_CONF	"cdc.conf"
#define		CDC_SERVERS	"cdc.servers"
#define		CDC_HOST	 CDC_MASTER

/*
 *  Each domain should define the CDC_DOMAIN and CDC_PRIMARY_SERVER
 *  variables in case the above configuration files don't exist.
 *
 */

#define         CDC_DOMAIN	"/C=US/O=Digital/OU=LKG/OU=Sphinx"
#define         CDC_PRIMARY_SERVER	"filesv.lkg.dec.com"

#define         CDC_PORT         223

/* The maximum sizes for aname, domain, sname, and instance +1 */
#define 	ANAME_SZ	 40
#define		FULLNAME_SZ	 160
#define		SNAME_SZ	 20
#define		VERSION_SZ	 1
#define		MSG_TYPE_SZ	 1
#define		DATE_SZ		 26	/* RTI date output */
#define         UID_SZ           20
#define         CERTIF_SZ        512

#define		MAX_KEY_BUF	2048
#define		MAX_NAME_BUF	80

#ifndef DEF_CERTIF_LIFE		     /* allow compile-time override */
#define		DEF_CERTIF_LIFE	144   /* default lifetime for certif
					      & co., 12 hrs */
#endif

/* Definition of text structure used to pass text around */
#define         MAX_KTXT_LEN    1536  /*  should be able to hold 3 certifs  */

struct ktext {
    int     length;             /* Length of the text */
    unsigned char dat[MAX_KTXT_LEN];    /* The data itself */
    unsigned long mbz;          /* zero to catch runaway strings */
};

typedef struct ktext *KTEXT;
typedef struct ktext KTEXT_ST;

/* Definitions for send_to_cdc */

#define	CLIENT_CDC_TIMEOUT	1	/* time between retries */
#define	CLIENT_CDC_READ_TIMEOUT	5	/* timeout for read response */
#define CLIENT_CDC_RETRY	1	/* retry this many times */
#define	CLIENT_CDC_BUFLEN	512	/* max unfragmented packet */

/* Definitions for ticket file utilities */

#define	R_TKT_FIL	0
#define	W_TKT_FIL	1

/* Location of ticket file for save_cred and get_cred */

#define TKT_ROOT        "/tmp/claimant"
#define VER_ROOT        "/etc/verifier"
#define VERCTX_ROOT     "/tmp/verifier"

/* Error codes returned from the CDC */

#define		CDC_OK		0	/* Request OK */
#define		CDC_MALLOC_ERR	1	/* system error during malloc */
#define		CDC_UNKNOWN_HOST  2	/* unknown CDC hostname for server */
#define		CDC_SOCK_FAIL	3	/* can't create socket for request */
#define		CDC_CONNECT_ERR	4	/* can't connect to cdc server */
#define		CDC_WRITE_ERR	5	/* error writing request to cdc */
#define		CDC_READ_ERR	6	/* error reading response from cdc */
#define		CDC_READ_REST_ERR  7	/* error reading rest of response */
#define		CDC_TIMEOUT	8	/* cdc request timeout */
#define		CDC_PKT_VER	9	/* Protocol version unknown */
#define		CDC_BYTE_ORDER	10	/* Byte order unknown */
#define		CDC_PR_UNKNOWN	11	/* Principal unknown */
#define		CDC_PR_N_UNIQUE 12	/* Principal not unique */
#define		CDC_GEN_ERR    20	/* Generic error from CDC */

/* Values returned by send_to_cdc */

#define		SCDC_OK		0	/* Response received */
#define		SCDC_RETRY     56	/* Retry count exceeded */
#define		SCDC_CANT      57	/* Can't send request */

/* Values returned by get_adtkt */
#define         AD_OK           0       /* Ticket Obtained */
#define         AD_NOTGT       71       /* Don't have tgt */

/*
 * Values returned by get_intkt
 * (can also return SKDC_* and KDC errors)
 */

#define         INTK_OK         0       /* Ticket obtained */
#define         INTK_W_NOTALL  61       /* Not ALL tickets returned */
#define         INTK_BADPW     62       /* Incorrect password */
#define         INTK_PROT      63       /* Protocol Error */
#define         INTK_ERR       70       /* Other error */

/* Error codes returned by ticket file utilities */

#define		NO_TKT_FIL	76	/* No ticket file found */
#define		TKT_FIL_ACC	77	/* Couldn't access tkt file */
#define		TKT_FIL_LCK	78	/* Couldn't lock ticket file */
#define		TKT_FIL_FMT	79	/* Bad ticket file format */
#define		TKT_FIL_INI	80	/* tf_init not called first */

/*
 * macros for byte swapping; also scratch space
 * u_quad  0-->7, 1-->6, 2-->5, 3-->4, 4-->3, 5-->2, 6-->1, 7-->0
 * u_long  0-->3, 1-->2, 2-->1, 3-->0
 * u_short 0-->1, 1-->0
 */

#define     swap_u_16(x) {\
 unsigned long   _krb_swap_tmp[4];\
 swab(((char *) x) +0, ((char *)  _krb_swap_tmp) +14 ,2); \
 swab(((char *) x) +2, ((char *)  _krb_swap_tmp) +12 ,2); \
 swab(((char *) x) +4, ((char *)  _krb_swap_tmp) +10 ,2); \
 swab(((char *) x) +6, ((char *)  _krb_swap_tmp) +8  ,2); \
 swab(((char *) x) +8, ((char *)  _krb_swap_tmp) +6 ,2); \
 swab(((char *) x) +10,((char *)  _krb_swap_tmp) +4 ,2); \
 swab(((char *) x) +12,((char *)  _krb_swap_tmp) +2 ,2); \
 swab(((char *) x) +14,((char *)  _krb_swap_tmp) +0 ,2); \
 bcopy((char *)_krb_swap_tmp,(char *)x,16);\
                            }

#define     swap_u_12(x) {\
 unsigned long   _krb_swap_tmp[4];\
 swab(( char *) x,     ((char *)  _krb_swap_tmp) +10 ,2); \
 swab(((char *) x) +2, ((char *)  _krb_swap_tmp) +8 ,2); \
 swab(((char *) x) +4, ((char *)  _krb_swap_tmp) +6 ,2); \
 swab(((char *) x) +6, ((char *)  _krb_swap_tmp) +4 ,2); \
 swab(((char *) x) +8, ((char *)  _krb_swap_tmp) +2 ,2); \
 swab(((char *) x) +10,((char *)  _krb_swap_tmp) +0 ,2); \
 bcopy((char *)_krb_swap_tmp,(char *)x,12);\
                            }

#define     swap_C_Block(x) {\
 unsigned long   _krb_swap_tmp[4];\
 swab(( char *) x,    ((char *)  _krb_swap_tmp) +6 ,2); \
 swab(((char *) x) +2,((char *)  _krb_swap_tmp) +4 ,2); \
 swab(((char *) x) +4,((char *)  _krb_swap_tmp) +2 ,2); \
 swab(((char *) x) +6,((char *)  _krb_swap_tmp)    ,2); \
 bcopy((char *)_krb_swap_tmp,(char *)x,8);\
                            }
#define     swap_u_quad(x) {\
 unsigned long   _krb_swap_tmp[4];\
 swab(( char *) &x,    ((char *)  _krb_swap_tmp) +6 ,2); \
 swab(((char *) &x) +2,((char *)  _krb_swap_tmp) +4 ,2); \
 swab(((char *) &x) +4,((char *)  _krb_swap_tmp) +2 ,2); \
 swab(((char *) &x) +6,((char *)  _krb_swap_tmp)    ,2); \
 bcopy((char *)_krb_swap_tmp,(char *)&x,8);\
                            }

#define     swap_u_long(x) {\
 unsigned long   _krb_swap_tmp[4];\
 swab((char *)  &x,    ((char *)  _krb_swap_tmp) +2 ,2); \
 swab(((char *) &x) +2,((char *)  _krb_swap_tmp),2); \
 x = _krb_swap_tmp[0];   \
                           }

#define     swap_u_short(x) {\
 unsigned short	_krb_swap_sh_tmp; \
 swab((char *)  &x,    ( &_krb_swap_sh_tmp) ,2); \
 x = (unsigned short) _krb_swap_sh_tmp; \
                            }

#endif	CDC_DEFS
