#ifndef _MEM_E_INCLUDED_
#define _MEM_E_INCLUDED_

/*******************************************************************************
			    Public types
*******************************************************************************/

typedef int	t_mem_word;
typedef int	t_word;
typedef int	t_handle;

/*******************************************************************************
			Exported functions/macros
*******************************************************************************/

#ifndef P_
#ifdef __STDC__
#define P_(s) s
#else
#define P_(s) ()
#endif
#endif

#if 0
/*
Malloc declarations now turned off:
*/

extern void	*malloc P_((int));
extern void	*calloc P_((int, int));
extern void	*realloc P_((void *, int));
extern void	free P_((void *));
#endif

#if defined(DEVELOP) || defined(DEVELOPMENT)

extern t_mem_word	*f_mem_access P_((t_handle, char *, int));
extern t_handle	f_mem_alloc P_((int, char *, int));
extern t_handle	f_mem_alloc_words P_((int, char *, int));
extern t_handle	f_mem_alloc_zero P_((int, char *, int));
extern t_handle	f_mem_alloc_words_zero P_((int, char *, int));
extern t_handle	f_mem_alloc_aligned P_((int, int, char *, int));
extern void	f_mem_delete_h P_((t_handle, char *, int));
extern void	f_mem_delete_hptr P_((t_handle *, char *, int));
extern void	f_mem_reduce P_((t_handle, int, char *, int));
extern void	f_mem_reduce_words P_((t_handle, int, char *, int));
extern void	f_mem_extend P_((t_handle, int, char *, int));
extern void	f_mem_extend_zero P_((t_handle, int, char *, int));
extern void	f_mem_extend_words P_((t_handle, int, char *, int));
extern void	f_mem_extend_words_zero P_((t_handle, int, char *, int));
extern t_mem_word	*f_mem_check_ptr P_((t_handle, void *, char *, int));
extern t_handle	f_mem_copy P_((t_handle, char *, int));
extern void	f_mem_zero_block P_((t_handle, char *, int));
extern int	f_mem_words P_((t_handle, char *, int));
extern int	f_mem_bytes P_((t_handle, char *, int));
extern void	f_mem_assure_space P_((t_handle, void *, int, char *, int));
extern void	*f_mem_malloc P_((int, char *, int));
extern void	*f_mem_malloc_zero P_((int, char *, int));
extern void	*f_mem_calloc P_((int, int, char *, int));
extern void	*f_mem_realloc P_((void *, int, char *, int));
extern void	*f_mem_malloc_aligned P_((int, int, char *, int));
extern void	*f_mem_biffable_malloc P_((int, char *, int));

#define mem_access(h)		f_mem_access(h, __FILE__, __LINE__)
#define mem_check_handle(h)	f_mem_check_handle(h, __FILE__, __LINE__)
#define mem_alloc(n)		f_mem_alloc(n, __FILE__, __LINE__)
#define mem_alloc_words(n)	f_mem_alloc_words(n, __FILE__, __LINE__)
#define mem_alloc_zero(n)	f_mem_alloc_zero(n, __FILE__, __LINE__)
#define mem_alloc_words_zero(n)	f_mem_alloc_words_zero(n, __FILE__, __LINE__)
#define mem_alloc_aligned(a, n)	f_mem_alloc_aligned(a, n, __FILE__, __LINE__)
#define mem_delete_h(h)		f_mem_delete_h(h, __FILE__, __LINE__)
#define mem_delete_hptr(hp)	f_mem_delete_hptr(hp, __FILE__, __LINE__)
#define mem_reduce(h, n)	f_mem_reduce(h, n, __FILE__, __LINE__)
#define mem_reduce_words(h, n)	f_mem_reduce_words(h, n, __FILE__, __LINE__)
#define mem_extend(h, n)	f_mem_extend(h, n, __FILE__, __LINE__)
#define mem_extend_zero(h, n)	f_mem_extend_zero(h, n, __FILE__, __LINE__)
#define mem_extend_words(h, n)	f_mem_extend_words(h, n, __FILE__, __LINE__)
#define mem_extend_words_zero(h, n) \
		f_mem_extend_words_zero(h, n, __FILE__, __LINE__)
#define mem_check_ptr(h, p) \
		f_mem_check_ptr(h, (void *)(p), __FILE__, __LINE__)
#define mem_copy(h)		f_mem_copy(h, __FILE__, __LINE__)
#define mem_zero_block(h)	f_mem_zero_block(h, __FILE__, __LINE__)
#define mem_words(h)		f_mem_words(h, __FILE__, __LINE__)
#define mem_bytes(h)		f_mem_bytes(h, __FILE__, __LINE__)
#define mem_assure_space(h, p, e) \
		f_mem_assure_space(h, p, e, __FILE__, __LINE__)
#define mem_malloc(n)		f_mem_malloc(n, __FILE__, __LINE__)
#define mem_malloc_zero(n)	f_mem_malloc_zero(n, __FILE__, __LINE__)
#define mem_calloc(n, s)	f_mem_calloc(n, s, __FILE__, __LINE__)
#define mem_realloc(p, n)	f_mem_realloc(p, n, __FILE__, __LINE__)
#define mem_malloc_aligned(a, n) f_mem_malloc_aligned(a, n, __FILE__, __LINE__)
#define mem_biffable_malloc(n)	f_mem_biffable_malloc(n, __FILE__, __LINE__)

#else

extern t_mem_word	**mem_handle_base;

extern t_handle	f_mem_alloc P_((int));
extern t_handle	f_mem_alloc_words P_((int));
extern t_handle	f_mem_alloc_zero P_((int));
extern t_handle	f_mem_alloc_words_zero P_((int));
extern t_handle	f_mem_alloc_aligned P_((int, int));
extern void	f_mem_delete_h P_((t_handle));
extern void	f_mem_delete_hptr P_((t_handle *));
extern void	f_mem_reduce P_((t_handle, int));
extern void	f_mem_reduce_words P_((t_handle, int));
extern void	f_mem_extend P_((t_handle, int));
extern void	f_mem_extend_zero P_((t_handle, int));
extern void	f_mem_extend_words P_((t_handle, int));
extern void	f_mem_extend_words_zero P_((t_handle, int));
extern t_handle	f_mem_copy P_((t_handle));
extern void	f_mem_zero_block P_((t_handle));
extern int	f_mem_words P_((t_handle));
extern int	f_mem_bytes P_((t_handle));
extern void	f_mem_assure_space P_((t_handle, void *, int));
extern void	*f_mem_malloc P_((int));
extern void	*f_mem_biffable_malloc P_((int));
extern void	*f_mem_malloc_zero P_((int));
extern void	*f_mem_calloc P_((int, int));
extern void	*f_mem_realloc P_((void *, int));
extern void	*f_mem_malloc_aligned P_((int, int));

#define mem_access(h)			mem_handle_base[h]
#define mem_check_handle(h)
#define mem_alloc(n)			f_mem_alloc(n)
#define mem_alloc_words(n)		f_mem_alloc_words(n)
#define mem_alloc_zero(n)		f_mem_alloc_zero(n)
#define mem_alloc_words_zero(n)		f_mem_alloc_words_zero(n)
#define mem_alloc_aligned(a, n)		f_mem_alloc_aligned(a, n)
#define mem_delete_h(h)			f_mem_delete_h(h)
#define mem_delete_hptr(hp)		f_mem_delete_hptr(hp)
#define mem_reduce(h, n)		f_mem_reduce(h, n)
#define mem_reduce_words(h, n)		f_mem_reduce_words(h, n)
#define mem_extend(h, n)		f_mem_extend(h, n)
#define mem_extend_zero(h, n)		f_mem_extend_zero(h, n)
#define mem_extend_words(h, n)		f_mem_extend_words(h, n)
#define mem_extend_words_zero(h, n)	f_mem_extend_words_zero(h, n)
#define mem_check_ptr(h, p)		(p)
#define mem_copy(h)			f_mem_copy(h)
#define mem_zero_block(h)		f_mem_zero_block(h)
#define mem_words(h)			f_mem_words(h)
#define mem_bytes(h)			f_mem_bytes(h)
#define mem_assure_space(h, p, e)	f_mem_assure_space(h, p, e)
#define mem_malloc(n)			f_mem_malloc(n)
#define mem_malloc_zero(n)		f_mem_malloc_zero(n)
#define mem_calloc(n, s)		f_mem_calloc(n, s)
#define mem_realloc(p, n)		f_mem_realloc(p, n)
#define mem_malloc_aligned(a, n)	f_mem_malloc_aligned(a, n)
#define mem_biffable_malloc(n)		f_mem_biffable_malloc(n)

#endif

extern void	mem_free P_((void *));
extern void	mem_biffable_free P_((void *));
extern void	mem_biff_biffables P_((void));

#define mem_new(t)		((t *)mem_malloc(sizeof(t)))
#define mem_newa(t, n)		((t *)mem_malloc((n) * sizeof(t)))
#define mem_resize(t, p, n)	((t *)mem_realloc(p, (n) * sizeof(t)))
#define mem_newh(t)		(mem_alloc(sizeof(t)))
#define mem_newha(t, n)		(mem_alloc((n) * sizeof(t)))
#define mem_access_char(h)	((char *)mem_access(h))

extern int	mem_valid_handle P_((t_handle));
extern int	mem_creator_line_num P_((t_handle));
extern char	*mem_creator_file_name P_((t_handle));


#define MEM_BYTES_TO_WORDS(b)	(((b) + 3) >> 2)
#define MEM_WORDS_TO_BYTES(w)	((w) << 2)
#define MEM_BITS_TO_WORDS(bits) (((bits)+31)>>5)
#define MEM_NH			0
#define VARIABLE_LENGTH		1

/*******************************************************************************
			Callback function values
*******************************************************************************/

enum
{
    MEM_CALLBACK_NO_ROOM,
    MEM_CALLBACK_HIT_LIMIT,
    MEM_CALLBACK_DIE
};

#define MEM_NO_LIMIT		0

/*******************************************************************************
		Inheritance of creator place stuff
*******************************************************************************/

#ifdef DEVELOP

#define MEM_DECL_0() \
    (mem_cfile, mem_cline) char *mem_cfile; int mem_cline;
#define MEM_DECL_1(x1) \
    (x1, mem_cfile, mem_cline) char *mem_cfile; int mem_cline;
#define MEM_DECL_2(x1, x2) \
    (x1, x2, mem_cfile, mem_cline) char *mem_cfile; int mem_cline;
#define MEM_DECL_3(x1, x2, x3) \
    (x1, x2, x3, mem_cfile, mem_cline) char *mem_cfile; int mem_cline;
#define MEM_DECL_4(x1, x2, x3, x4) \
    (x1, x2, x3, x4, mem_cfile, mem_cline) char *mem_cfile; int mem_cline;
#define MEM_DECL_5(x1, x2, x3, x4, x5) \
    (x1, x2, x3, x4, x5, mem_cfile, mem_cline) char *mem_cfile; int mem_cline;
#define MEM_DECL_6(x1, x2, x3, x4, x5, x6) \
    (x1, x2, x3, x4, x5, x6, mem_cfile, mem_cline) \
	char *mem_cfile; int mem_cline;

#define MEM_CALL_0()			(__FILE__, __LINE__)
#define MEM_CALL_1(x1)			(x1, __FILE__, __LINE__)
#define MEM_CALL_2(x1, x2)		(x1, x2, __FILE__, __LINE__)
#define MEM_CALL_3(x1, x2, x3)		(x1, x2, x3, __FILE__, __LINE__)
#define MEM_CALL_4(x1, x2, x3, x4)	(x1, x2, x3, x4, __FILE__, __LINE__)
#define MEM_CALL_5(x1, x2, x3, x4, x5)	(x1, x2, x3, x4, x5, __FILE__, __LINE__)
#define MEM_CALL_6(x1, x2, x3, x4, x5, x6) \
	    (x1, x2, x3, x4, x5, x6, __FILE__, __LINE__)

#define mem_alloc_INHERIT(n) \
	    f_mem_alloc(n, mem_cfile, mem_cline)
#define mem_alloc_zero_INHERIT(n) \
	    f_mem_alloc_zero(n, mem_cfile, mem_cline)
#define mem_alloc_words_INHERIT(n) \
	    f_mem_alloc_words(n, mem_cfile, mem_cline)
#define mem_alloc_words_zero_INHERIT(n) \
	    f_mem_alloc_words_zero(n, mem_cfile, mem_cline)
#define mem_check_handle_INHERIT(h) \
	    f_mem_check_handle(h, mem_cfile, mem_cline)

#define MEM_CFILE	mem_cfile
#define MEM_CLINE	mem_cline

#ifdef P_

#define MEM_P_0()			P_((char *, int))
#define MEM_P_1(t1)			P_((t1, char *, int))
#define MEM_P_2(t1, t2)			P_((t1, t2, char *, int))
#define MEM_P_3(t1, t2, t3)		P_((t1, t2, t3, char *, int))
#define MEM_P_4(t1, t2, t3, t4)		P_((t1, t2, t3, t4, char *, int))
#define MEM_P_5(t1, t2, t3, t4, t5)	P_((t1, t2, t3, t4, t5, char *, int))
#define MEM_P_6(t1, t2, t3, t4, t5, t6)	\
	    P_((t1, t2, t3, t4, t5, t6, char *, int))

#else

#define MEM_P_0()			()
#define MEM_P_1(t1)			()
#define MEM_P_2(t1, t2)			()
#define MEM_P_3(t1, t2, t3)		()
#define MEM_P_4(t1, t2, t3, t4)		()
#define MEM_P_5(t1, t2, t3, t4, t5)	()
#define MEM_P_6(t1, t2, t3, t4, t5, t6)	()

#endif

#define MEM_INHERIT_0()			(mem_cfile, mem_cline)
#define MEM_INHERIT_1(x1)		(x1, mem_cfile, mem_cline)
#define MEM_INHERIT_2(x1, x2)		(x1, x2, mem_cfile, mem_cline)
#define MEM_INHERIT_3(x1, x2, x3)	(x1, x2, x3, mem_cfile, mem_cline)
#define MEM_INHERIT_4(x1, x2, x3, x4)	(x1, x2, x3, x4, mem_cfile, mem_cline)
#define MEM_INHERIT_5(x1, x2, x3, x4, x5) \
		(x1, x2, x3, x4, x5, mem_cfile, mem_cline)
#define MEM_INHERIT_6(x1, x2, x3, x4, x5, x6) \
		(x1, x2, x3, x4, x5, x6, mem_cfile, mem_cline)

#else

#define MEM_DECL_0()			()
#define MEM_DECL_1(x1)			(x1)
#define MEM_DECL_2(x1, x2)		(x1, x2)
#define MEM_DECL_3(x1, x2, x3)		(x1, x2, x3)
#define MEM_DECL_4(x1, x2, x3, x4)	(x1, x2, x3, x4)
#define MEM_DECL_5(x1, x2, x3, x4, x5)	(x1, x2, x3, x4, x5)
#define MEM_DECL_6(x1, x2, x3, x4, x5, x6) \
	    (x1, x2, x3, x4, x5, x6)

#define MEM_CALL_0()			()
#define MEM_CALL_1(x1)			(x1)
#define MEM_CALL_2(x1, x2)		(x1, x2)
#define MEM_CALL_3(x1, x2, x3)		(x1, x2, x3)
#define MEM_CALL_4(x1, x2, x3, x4)	(x1, x2, x3, x4)
#define MEM_CALL_5(x1, x2, x3, x4, x5)	(x1, x2, x3, x4, x5)
#define MEM_CALL_6(x1, x2, x3, x4, x5, x6) \
	    (x1, x2, x3, x4, x5, x6)

#define mem_alloc_INHERIT(n)		f_mem_alloc(n)
#define mem_alloc_zero_INHERIT(n)	f_mem_alloc_zero(n)
#define mem_alloc_words_INHERIT(n)	f_mem_alloc_words(n)
#define mem_alloc_words_zero_INHERIT(n)	f_mem_alloc_words_zero(n)
#define mem_check_handle_INHERIT(h)


#ifdef P_

#define MEM_P_0()			P_(())
#define MEM_P_1(t1)			P_((t1))
#define MEM_P_2(t1, t2)			P_((t1, t2))
#define MEM_P_3(t1, t2, t3)		P_((t1, t2, t3))
#define MEM_P_4(t1, t2, t3, t4)		P_((t1, t2, t3, t4))
#define MEM_P_5(t1, t2, t3, t4, t5)	P_((t1, t2, t3, t4, t5))
#define MEM_P_6(t1, t2, t3, t4, t5, t6) \
	    P_((t1, t2, t3, t4, t5, t6))

#else

#define MEM_P_0()			()
#define MEM_P_1(t1)			()
#define MEM_P_2(t1, t2)			()
#define MEM_P_3(t1, t2, t3)		()
#define MEM_P_4(t1, t2, t3, t4)		()
#define MEM_P_5(t1, t2, t3, t4, t5)	()
#define MEM_P_6(t1, t2, t3, t4, t5, t6)	()

#endif

#define MEM_INHERIT_0()			()
#define MEM_INHERIT_1(x1)		(x1)
#define MEM_INHERIT_2(x1, x2)		(x1, x2)
#define MEM_INHERIT_3(x1, x2, x3)	(x1, x2, x3)
#define MEM_INHERIT_4(x1, x2, x3, x4)	(x1, x2, x3, x4)
#define MEM_INHERIT_5(x1, x2, x3, x4, x5) \
	    (x1, x2, x3, x4, x5)
#define MEM_INHERIT_6(x1, x2, x3, x4, x5, x6) \
	    (x1, x2, x3, x4, x5, x6)
#endif

/*******************************************************************************
			    Archaic drivel
*******************************************************************************/

typedef union
{
    t_mem_word      bh_param_i;
    char            *bh_param_p;    /* will be void * instead at ANSI C */
} bh_param;

#endif /* _MEM_E_INCLUDED_ */
