
/*
 * create_id
 */

#define mat_z_create_id   mat_ring_create_id
#define mat_zm_create_id  mat_ring_create_id
#define mat_gf_create_id  mat_ring_create_id
#define mat_zmgf_create_id mat_ring_create_id

/*
 * row_swap
 */

#define mat_z_row_swap_sub   mat_ring_row_swap_sub
#define mat_zm_row_swap_sub  mat_ring_row_swap_sub
#define mat_gf_row_swap_sub  mat_ring_row_swap_sub

/*
 * col_swap
 */

#define mat_z_col_swap_sub   mat_ring_col_swap_sub
#define mat_zm_col_swap_sub  mat_ring_col_swap_sub
#define mat_gf_col_swap_sub  mat_ring_col_swap_sub

/*
 * power
 */

#define mat_z_power   mat_zmgf_power
#define mat_zm_power  mat_zmgf_power
#define mat_gf_power  mat_zmgf_power

#define mat_z_power_sub   mat_zmgf_power_sub
#define mat_zm_power_sub  mat_zmgf_power_sub
#define mat_gf_power_sub  mat_zmgf_power_sub

/*
 * transpose
 */

#define mat_z_trans   mat_ring_trans
#define mat_zm_trans  mat_ring_trans
#define mat_gf_trans  mat_ring_trans

/*
** copy entries from a to b
*/

#define mat_copy_entries( ring, a, b ) \
	{ \
		integer_small	n; \
		for ( n = mat_row( a ) * mat_col( b ); n >= 1; --n ) \
			mat_entry( b, n ) = mat_entry( a, n ); \
		mat_incref_entries( ring, b ); \
	}

/*
 * All sub functions of det, rank, unit, reduced echelon form, standard 
 * echelon form, reduced echelon transform matrix,  standard echelon
 * transform matrix, inverse will be done by calling echelon
 */

#define mat_z_det_sub(ring, a, det) \
			mat_z_echelon(ring, a, det, 0, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_zm_det_sub(ring, a, det) \
			mat_zm_echelon(ring, a, det, 0, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_ed_reduced_echelon_sub(ring, a, echelon) \
			mat_ed_echelon(ring, a, 0, 0, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_z_reduced_echelon_sub(ring, a, echelon) \
			mat_z_echelon(ring, a, 0, 0, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_zm_reduced_echelon_sub(ring, a, echelon) \
			mat_zm_echelon(ring, a, 0, 0, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_ed_standard_echelon_sub(ring, a, echelon) \
			mat_ed_echelon(ring, a, 0, 0, echelon, 0, FALSE, 0, FALSE, 1) 

#define mat_z_standard_echelon_sub(ring, a, echelon) \
			mat_z_echelon(ring, a, 0, 0, echelon, 0, FALSE, 0, FALSE, 1) 

#define mat_zm_standard_echelon_sub(ring, a, echelon) \
			mat_zm_echelon(ring, a, 0, 0, echelon, 0, FALSE, 0, FALSE, 1) 

#define mat_ed_reduced_echelon_rank_sub(ring, a, echelon, rank) \
			mat_ed_echelon(ring, a, 0, rank, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_z_reduced_echelon_rank_sub(ring, a, echelon, rank) \
			mat_z_echelon(ring, a, 0, rank, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_zm_reduced_echelon_rank_sub(ring, a, echelon, rank) \
			mat_zm_echelon(ring, a, 0, rank, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_ed_rank_sub(ring, a, rank) \
			mat_ed_echelon(ring, a, 0, rank, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_z_rank_sub(ring, a, rank) \
			mat_z_echelon(ring, a, 0, rank, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_zm_rank_sub(ring, a, rank) \
			mat_zm_echelon(ring, a, 0, rank, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_ed_unit_sub(ring, a, unit) \
			mat_ed_echelon(ring, a, 0, 0, 0, unit, FALSE, 0, FALSE, 1) 

#define mat_z_unit_sub(ring, a, unit) \
			mat_z_echelon(ring, a, 0, 0, 0, unit, FALSE, 0, FALSE, 1) 

#define mat_zm_unit_sub(ring, a, unit) \
			mat_zm_echelon(ring, a, 0, 0, 0, unit, FALSE, 0, FALSE, 1) 

#define mat_ed_standard_echelon_transform_sub(ring, a, transform) \
			mat_ed_echelon(ring, a, 0, 0, 0, 0, FALSE, transform, FALSE, 1) 

#define mat_z_standard_echelon_transform_sub(ring, a, transform) \
			mat_z_echelon(ring, a, 0, 0, 0, 0, FALSE, transform, FALSE, 1) 

#define mat_zm_standard_echelon_transform_sub(ring, a, transform) \
			mat_zm_echelon(ring, a, 0, 0, 0, 0, FALSE, transform, FALSE, 1) 

#define mat_ed_reduced_echelon_transform_sub(ring, a, transform) \
			mat_ed_echelon(ring, a, 0, 0, 0, 0, TRUE, transform, FALSE, 1) 

#define mat_z_reduced_echelon_transform_sub(ring, a, transform) \
			mat_z_echelon(ring, a, 0, 0, 0, 0, TRUE, transform, FALSE, 1) 

#define mat_zm_reduced_echelon_transform_sub(ring, a, transform) \
			mat_zm_echelon(ring, a, 0, 0, 0, 0, TRUE, transform, FALSE, 1) 

#define mat_ed_inverse_sub(ring, a, inverse) \
			mat_ed_echelon(ring, a, 0, 0, 0, 0, TRUE, inverse, TRUE, 1) 

#define mat_z_inverse_sub(ring, a, inverse) \
			mat_z_echelon(ring, a, 0, 0, 0, 0, TRUE, inverse, TRUE, 1) 

#define mat_zm_inverse_sub(ring, a, inverse) \
			mat_zm_echelon(ring, a, 0, 0, 0, 0, TRUE, inverse, TRUE, 1) 

#define mat_ed_subtract_sub(ring, a, b, r) \
			mat_ring_subtract_sub(ring, a, b, r) 

#define mat_ed_negate_sub(ring, a, r) \
			mat_ring_negate_sub(ring, a, r) 

#define mat_ed_add_sub(ring, a, b, r) \
			mat_ring_add_sub(ring, a, b, r) 

/*
 * ring
 */

#define mat_ring_standard_echelon_transform_sub(ring, a, trans) \
			mat_ring_echelon(ring, a, 0, 0, 0, 0, FALSE, trans, FALSE, 1) 

#define mat_ring_reduced_echelon_transform_sub(ring, a, trans) \
			mat_ring_echelon(ring, a, 0, 0, 0, 0, TRUE, trans, FALSE, 1) 

#define mat_ring_rank_sub(ring, a, rank) \
			mat_ring_echelon(ring, a, 0, rank, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_ring_standard_echelon_sub(ring, a, echelon) \
			mat_ring_echelon(ring, a, 0, 0, echelon, 0, FALSE, 0, FALSE, 1) 

#define mat_ring_reduced_echelon_sub(ring, a, echelon) \
			mat_ring_echelon(ring, a, 0, 0, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_ring_reduced_echelon_rank_sub(ring, a, echelon, rank) \
			mat_ring_echelon(ring, a, 0, rank, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_ring_inverse_sub(ring, a, inverse) \
			mat_ring_echelon(ring, a, 0, 0, 0, 0, TRUE, inverse, TRUE, 1) 

/*
 * gf
 */

#define mat_gf2_echelon mat_gf_echelon

#define mat_gf_inverse_sub(ring, a, inverse) \
			mat_gf_echelon(ring, a, 0, 0, 0, 0, TRUE, inverse, TRUE, 1) 

#define mat_gf_standard_echelon_transform_sub(ring, a, trans) \
			mat_gf_echelon(ring, a, 0, 0, 0, 0, FALSE, trans, FALSE, 1) 

#define mat_gf_reduced_echelon_transform_sub(ring, a, trans) \
			mat_gf_echelon(ring, a, 0, 0, 0, 0, TRUE, trans, FALSE, 1) 

#define mat_gf_rank_sub(ring, a, rank) \
			mat_gf_echelon(ring, a, 0, rank, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_gf_standard_echelon_sub(ring, a, echelon) \
			mat_gf_echelon(ring, a, 0, 0, echelon, 0, FALSE, 0, FALSE, 1) 

#define mat_gf_reduced_echelon_sub(ring, a, echelon) \
			mat_gf_echelon(ring, a, 0, 0, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_gf_reduced_echelon_rank_sub(ring, a, echelon, rank) \
			mat_gf_echelon(ring, a, 0, rank, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_ed_det_sub(ring, a, det) \
			mat_ed_echelon(ring, a, det, 0, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_gf_det_sub(ring, a, det) \
			mat_gf_echelon(ring, a, det, 0, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_gf_unit_sub(ring, a, unit) \
			mat_gf_echelon(ring, a, 0, 0, 0, unit, FALSE, 0, FALSE, 1) 

/*
 * fld
 */

#define mat_fld_inverse_sub(ring, a, inverse) \
			mat_fld_echelon(ring, a, 0, 0, 0, 0, TRUE, inverse, TRUE, 1) 

#define mat_fld_standard_echelon_transform_sub(ring, a, trans) \
			mat_fld_echelon(ring, a, 0, 0, 0, 0, FALSE, trans, FALSE, 1) 

#define mat_fld_reduced_echelon_transform_sub(ring, a, trans) \
			mat_fld_echelon(ring, a, 0, 0, 0, 0, TRUE, trans, FALSE, 1) 

#define mat_fld_rank_sub(ring, a, rank) \
			mat_fld_echelon(ring, a, 0, rank, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_fld_standard_echelon_sub(ring, a, echelon) \
			mat_fld_echelon(ring, a, 0, 0, echelon, 0, FALSE, 0, FALSE, 1) 

#define mat_fld_reduced_echelon_sub(ring, a, echelon) \
			mat_fld_echelon(ring, a, 0, 0, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_fld_reduced_echelon_rank_sub(ring, a, echelon, rank) \
			mat_fld_echelon(ring, a, 0, rank, echelon, 0, TRUE, 0, FALSE, 1) 

#define mat_fld_det_sub(ring, a, det) \
			mat_fld_echelon(ring, a, det, 0, 0, 0, FALSE, 0, FALSE, 1) 

#define mat_fld_unit_sub(ring, a, unit) \
			mat_fld_echelon(ring, a, 0, 0, 0, unit, FALSE, 0, FALSE, 1) 


#if 0

t_handle
matrng_create HAS_3_ARGS(
	t_int, d,
	t_handle, coeff_ring,
	t_handle, vec_space
);
/*
Create a matrix ring.

The matrix ring can be specified either as dimension d over the ring
coeff_ring (in which case the argument vec_space is ignored), or as
over the vector space vec_space (if d and coeff_ring are not
specified).
*/


t_void
matrng_delete HAS_1_ARG(
	t_handle *, r
);
/*
** Delete the matrix ring with t_handle *r
*/


matrix 
matrng_ed_inverse HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the inverse of Euclidean Domain
 */


matrix
matrng_gf_add HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a + b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_gf_mult HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a * b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_gf_subtract HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a - b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_gf_power HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	integer_big,	b
);
/*
** a ^ b in the matrix ring mrg, a in mrg, b in Z
*/


matrix
matrng_gf_negate HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** - a in the matrix ring mrg, a in mrg
*/


matrix
matrng_gf_inverse HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** a ^ -1 in the matrix ring mrg, a in mrg
*/


t_logical
matrng_gf_equal HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** returns a == b where a, b are in the matrix ring mrg
*/


matrix
matrng_ring_add HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a + b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_ring_mult HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a * b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_ring_subtract HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a - b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_ring_power HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	integer_big,	b
);
/*
** a ^ b in the matrix ring mrg, a in mrg, b in Z
*/


matrix
matrng_ring_negate HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** - a in the matrix ring mrg, a in mrg
*/


matrix
matrng_ring_inverse HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** a ^ -1 in the matrix ring mrg, a in mrg
*/


t_logical
matrng_ring_equal HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** returns a == b where a, b are in the matrix ring mrg
*/


matrix
matrng_z_add HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a + b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_z_mult HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a * b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_z_subtract HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a - b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_z_power HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	integer_big,	b
);
/*
** a ^ b in the matrix ring mrg, a in mrg, b in Z
*/


matrix
matrng_z_negate HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** - a in the matrix ring mrg, a in mrg
*/


matrix
matrng_z_inverse HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** a ^ -1 in the matrix ring mrg, a in mrg
*/


t_logical
matrng_z_equal HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** returns a == b where a, b are in the matrix ring mrg
*/


matrix
matrng_zm_add HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a + b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_zm_mult HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a * b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_zm_subtract HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** a - b in the matrix ring mrg, a in mrg, b in mrg
*/


matrix
matrng_zm_power HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	integer_big,	b
);
/*
** a ^ b in the matrix ring mrg, a in mrg, b in Z
*/


matrix
matrng_zm_negate HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** - a in the matrix ring mrg, a in mrg
*/


matrix
matrng_zm_inverse HAS_2_ARGS(
	t_handle,		mrg,
	matrix,		a
);
/*
** a ^ -1 in the matrix ring mrg, a in mrg
*/


t_logical
matrng_zm_equal HAS_3_ARGS(
	t_handle,		mrg,
	matrix,		a,
	matrix,		b
);
/*
** returns a == b where a, b are in the matrix ring mrg
*/



t_void
mat_delete_entries HAS_2_ARGS(
	t_handle,		ring,
	matrix,		mat
);
/*
 * Given a t_handle to a matrix, delete one reference count from
 * each element of the matrix.
 *
 * "ring" is the coefficient ring
 */



matrix 
mat_ed_add HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/*
 * summation of a & b
 */


t_ring_elt 
mat_ed_det HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the determinant of a where the coefficient ring is 
 * euclidean domain. This function will call mat_ed_det_sub
 */


void
mat_ed_echelon HAS_10_ARGS(
	t_handle,			cring,
	matrix,			a,
	t_ring_elt*,	det1,
	t_int*,			rank,
	matrix 	*,		echelon,
	t_logical *,		unit,
	t_logical, 		istoreduce,
	matrix	*,		transform,
	t_logical,		istoinverse,
	t_int,			start_row
);
/*
 * This procedure will find out determinant, rank, standard echelon form of a,
 * reduced echelon form, standard echelon transform, reduced echelon transform,
 * inverse and test whether a is unit.
 * The functions ed_quot_rem and ed_norm are supposed to be defined by user.
 */


matrix 
mat_ed_inverse HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the inverse of Euclidean Domain
 */


matrix 
mat_ed_negate HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * negate all elements of a
 * it calls the mat_ed_negate_sub function
 */


t_int 
mat_ed_rank HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the rank of a by row reduction
 * It calls mat_ed_rank_sub
 */


matrix 
mat_ed_reduced_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the reduced echelon form of a
 * It calls mat_ed_reduced_echelon_sub.
 */


matrix 
mat_ed_reduced_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the reduced echelon transform matrix of a
 * It calls mat_ed_reduced_echelon_transform
 */


matrix 
mat_ed_standard_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the standard echelon form of a
 */


matrix 
mat_ed_standard_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the standard transform matrix of a
 */


matrix 
mat_ed_subtract HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
);
/*
 * calculating the different of two matrix a & b where the coefficient ring is 
 * result = a - b
 * euclidean domain
 */


t_logical 
mat_ed_unit HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * check whether a is unit
 */


t_logical
mat_equality HAS_3_ARGS(
t_handle,		ring,
matrix, 	a,
matrix, 	b
);
/*
 * Test two matrices to see if they are equal.
 * Calls the appropriate function.
 *
 * Returns TRUE if the matrices are equal.
 */


t_void
mat_flatten HAS_3_ARGS(
	t_handle, matrix,
	t_handle, desthdl,
	t_int, destit
);
/*
Given an m x n matrix stored as m items by n fields per item, store it in
desthdl(destit) with the rows laid out one after the other.
*/


t_void
mat_flatten HAS_3_ARGS(
	t_handle, matrix,
	t_handle, desthdl,
	t_int, destit
);
/*
Given an m x n matrix stored as m items by n fields per item, store it in
desthdl(destit) with the rows laid out one after the other.
*/


t_int 
mat_fld_det HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * calculate the determinant of "a" where coefficient field of a is "field".
 * this function calls mat_fld_det_sub
 */


t_void
mat_fld_echelon HAS_10_ARGS(
t_handle,	field,
matrix,	a,
integer_big*, det1,
t_int*, 	dim1,
matrix*,	pb,
t_logical*,	unit,
t_logical,	istoreduce,
matrix*,	red,
t_logical,	istoinverse,
t_int,	start_row
);
/*
 * "field" is the coefficient field.
 * Given an m x n matrix "a", construct the reduced echelon
 * form "pb" of a. "start_row" is the row at which to start the echelonisation.
 *
 * The dimension of the row space of a is returned as "dim1".
 * The resulting vectors are returned in the matrix "red".
 *
 * For a square matrix, the determinant is returned as "*det1".
 * Note: For a non-square matrix, "*det1" will contain a value (ie occupied) but
 * the value will be garbage.
 *
 * In all cases, if an argument is a pointer, and it is 0 (the null pointer),
 * no assignment will be done.
 */


matrix 
mat_fld_inverse HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * calculate the inverse of a matrix.
 * It calls mat_fld_inverse_sub
 */


integer_small 
mat_fld_rank HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * calculate the rank of a by row reduction.
 * It calls mat_fld_rank_sub
 */


matrix 
mat_fld_rcf HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * returns the frobenius form of "a"
 * Calls "mat_fld_rcf_sub"
 */


t_void
mat_fld_rcf_sub HAS_4_ARGS(
t_handle,	field,
matrix,	a,
matrix*,	m,
matrix*,	t
);
/*
 * compute a frobenius form "m" for the matrix in buffer "a"
 * and return the transformation matrix in buffer "t".
 *
 * In both cases, if an argument is a pointer, and it is 0 (the null pointer),
 * no assignment will be done.
 */


matrix 
mat_fld_rcf_trans HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * returns the transformation matrix for the frobenius form of "a"
 * Calls "mat_fld_rcf_sub"
 */


matrix 
mat_fld_reduced_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculate the reduced echelon form of a.
 */


matrix 
mat_fld_reduced_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * returns the transformation matrix of the reduced echelon form of a.
 */


matrix 
mat_fld_standard_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculate the standard echelon form of a.
 */


matrix 
mat_fld_standard_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * returns the transformation matrix of the standard echelon form of a.
 */


t_logical 
mat_fld_unit HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * check whether a is unit
 *
 * "field" is the coefficient field.
 */


matrix 
mat_gf_add HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/*
 * summation of a & b
 */


void
mat_gf_add_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 */



t_int 
mat_gf_det HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculate the determinant of a where coefficient ring of a is gf
 * this function calls mat_gf_det_sub
 */


t_void
mat_gf_echelon HAS_10_ARGS(
t_handle,	field,
matrix,	a,
t_int*, 	det1,
t_int*, 	dim1,
matrix*,	pb,
t_logical*,	unit,
t_logical,	istoreduce,
matrix*,	red,
t_logical,	istoinverse,
t_int,	start_row
);
/*
 * "field" is the coefficient field.
 * Given an m x n matrix "a", construct the reduced echelon
 * form "pb" of a. "start_row" is the row at which to start the echelonisation.
 *
 * The dimension of the row space of a is returned as "dim1".  The resulting
 * vectors are returned in the matrix "red".
 *
 * For a square matrix, the determinant is returned as "*det1".
 * Note: For a non-square matrix, "*det1" will contain a value (ie occupied) but
 * the value will be garbage.
 *
 * In all cases, if an argument is a pointer, and it is 0 (the null pointer),
 * no assignment will be done.
 */


t_logical
mat_gf_equal HAS_3_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b
);
/*
 * Test two matrices to see if they are equal.
 * Returns TRUE if they are.
 */


matrix 
mat_gf_inverse HAS_2_ARGS(
	t_handle,	cring,
	matrix,	a
);
/*
 * calculate the inverse of a matrix.
 * "cring" is the coeff ring.
 *
 * It calls mat_gf_inverse_sub
 */


matrix 
mat_gf_mult HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/* 
 *	Multiplies matrix a by matrix b,
 *	Handle to result is returned.
 *	It calls mat_gf_mult_sub
 *
 *	"ring"  is the coefficient ring.
 */


t_void
mat_gf_mult_sub HAS_4_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b,
matrix*,	pc
);
/*
 *	Multiplies matrix a by matrix b,
 *	a is (am X an), matb is (bm X bn).
 *	an must be equal to bm.
 *	Result to be stored in pc (am X bn).
 */


matrix 
mat_gf_negate HAS_2_ARGS(
	t_handle,	cring,
	matrix,	a
);
/*
 * negate all elements of a
 * it calls the mat_gf_negate_sub function
 *
 * "cring" is the coefficient ring.
 */


void
mat_gf_negate_sub HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 *
 * "cring" is the coefficient ring.
 */



t_int 
mat_gf_rank HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculate the rank of a by row reduction.
 * It calls mat_gf_rank_sub
 */


matrix 
mat_gf_rcf HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * returns the frobenius form of "a"
 * Calls "mat_gf_rcf_sub"
 */


t_void
mat_gf_rcf_sub HAS_4_ARGS(
t_handle,	field,
matrix,	a,
matrix*,	m,
matrix*,	t
);
/*
 * compute a frobenius form "m" for the matrix in buffer "a"
 * and return the transformation matrix in buffer "t".
 *
 * In both cases, if an argument is a pointer, and it is 0 (the null pointer),
 * no assignment will be done.
 */


matrix 
mat_gf_rcf_trans HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * returns the transformation matrix for the frobenius form of "a"
 * Calls "mat_gf_rcf_sub"
 */


matrix 
mat_gf_reduced_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculate the reduced echelon form of a.
 */


matrix 
mat_gf_reduced_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * returns the transformation matrix of the reduced echelon form of a.
 */


void
mat_gf_col_add HAS_5_ARGS(
	t_handle,            ring,
	matrix,            a,
	integer_small,     acol,
	integer_small,     bcol,
	integer_big,       mult
);
/*
** adds (mult * column acol) of a to column bcol of a.
*/


void
mat_gf_col_mult HAS_4_ARGS(
	t_handle,            ring,
	matrix,            a,
	integer_small,     acol,
	integer_big,       umult
);
/*
** replaces column acol of a with (umult * column acol) of a.
*/


void
mat_gf_row_add HAS_6_ARGS(
	t_handle,            ring,
	matrix,            a,
	integer_small,     arow,
	integer_small,     brow,
	integer_big,       mult,
	integer_small,     from
);
/*
** Adds (mult * row arow) of a to row brow of a.
** Only does the addition left to right from column "from".
*/


void
mat_gf_row_mult HAS_5_ARGS(
	t_handle,            ring,
	matrix,            a,
	integer_small,     arow,
	integer_big,       umult,
	integer_small,     from
);
/*
** replaces row arow of a with (umult * row arow) of a.
** Only does the replacing left to right from column "from".
*/



t_logical
mat_gf_scalar HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is scalar.
 * Returns TRUE if so.
 * "a" must be a square matrix
 *
 * "cring" is the coefficient ring.
 * Calls mat_gf_scalar_common
 */


t_logical
mat_gf_identity HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is the identity
 * Returns TRUE if so.
 *
 * "cring" is the coefficient ring.
 * Calls mat_gf_scalar_common
 */


t_logical
mat_gf_zero HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 * Test a matrix to see if it is the zero matrix.
 * Returns TRUE if so.
 *
 * "a" can be m x n.
 */


Private t_logical
mat_gf_scalar_common HAS_3_ARGS(
t_handle,	ring,
matrix,	mata,
t_int,	scval
);
/*
 * Test a matrix to see if it is scalar, where the scalar value is "scval".
 * Called by scalar and identity.
 * "mata" is assumed to be UNPACKED.
 *
 * "ring" is the coefficient ring.
 */


matrix
mat_gf_scalar_mult HAS_3_ARGS(
	t_handle,		field,
	matrix,		a,
	integer_big,	b
);

/*
 * Scalar multiplication of matrix a by scalar b.
 *
 * "field" is the coefficient field.
 */



void
mat_gf_scalar_mult_sub HAS_4_ARGS(
	t_handle,		field,
	matrix,		a,
	integer_big,	b,
	matrix*,	pc
);

/*
 * Scalar multiplication of matrix a by scalar b.
 *
 * "field" is the coefficient field.
 */



matrix 
mat_gf_standard_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculate the standard echelon form of a.
 */


matrix 
mat_gf_standard_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * returns the transformation matrix of the standard echelon form of a.
 */


matrix 
mat_gf_subtract HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
);
/*
 * calculating the difference between matrix a & b
 * result = a - b
 * where the coefficient ring is galois field
 */


void
mat_gf_subtract_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	result(i, j) = a(i, j) - b(i, j)
 */



t_int
mat_gf_trace HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 *	Evaluate the trace of a.
 *	a must be a square matrix.
 */


t_logical 
mat_gf_unit HAS_2_ARGS(
	t_handle,	field,
	matrix,	a
);
/*
 * check whether a is unit
 *
 * "field" is the coefficient field.
 */


t_void
mat_incref_entries HAS_2_ARGS(
	t_handle,		ring,
	matrix,		mat
);
/*
 * Given a t_handle to a matrix, increment reference count to
 * each element of the matrix.
 */



matrix
mat_new HAS_2_ARGS(
	integer_small,    m,
	integer_small,    n
);
/*
** returns a new matrix of size m * n, setting rows, cols, packed, to correct
** values.
*/


t_void
mat_pack HAS_3_ARGS(
	t_handle,      ring,
	matrix,      a,
	matrix *,    b
);
/*
** packs matrix a into *b, allocating space for *b if *b == 0. Coefficient
** ring is ring.
*/


t_void
mat_rect_mult HAS_4_ARGS(
	t_handle, ring,
	t_handle, a,
	t_handle, b,
	t_handle, result
);
/*
Given matrices a and b over ring, with a being d x n and b being n x m,
and a stack result being at least d x m, put the product a * b in result.
*/


t_void
mat_rect_mult HAS_4_ARGS(
	t_handle, ring,
	t_handle, a,
	t_handle, b,
	t_handle, result
);
/*
Given matrices a and b over ring, with a being d x n and b being n x m,
and a stack result being at least d x m, put the product a * b in result.
*/


t_void
mat_rect_mult_unpkd HAS_7_ARGS(
	t_handle, ring,
	t_handle, a,
	t_handle, b,
	t_int, d,
	t_int, n,
	t_int, m,
	t_handle, result
);
/*
Given unpacked matrices a (d x n) and b (n x m) over ring, put the
product a * b in result.
*/


t_void
mat_rect_mult_unpkd HAS_7_ARGS(
	t_handle, ring,
	t_handle, a,
	t_handle, b,
	t_int, d,
	t_int, n,
	t_int, m,
	t_handle, result
);
/*
Given unpacked matrices a (d x n) and b (n x m) over ring, put the
product a * b in result.
*/


matrix 
mat_ring_add HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/*
 * summation of a & b
 */


void
mat_ring_add_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 */



void
mat_ring_col_swap HAS_4_ARGS(
	t_handle,		cring,
    matrix,		a,
    t_int,		acol,
    t_int,		bcol
);
/*
** swaps the two column vectors in the matrix,
** (column acol from a) <--> (column bcol from a)
*/


matrix 
mat_ring_create_id HAS_2_ARGS(
	t_handle,		ring,
	integer_small,	dim
);
/* 
 *	Returns t_handle to identity matrix.
 *	"ring" is the coefficient ring.
 *	"dim" is the dimension of the matrix.
 *
 *	It calls mat_ring_create_id_sub
 */


t_void
mat_ring_create_id_sub HAS_2_ARGS(
t_handle,	ring,
matrix,	mat
);
/*
 *	Puts the identity matrix in mat.
 *	Assumes "mat" has been allocated and is UNPACKED.
 *	"ring" is the coefficient ring.
 */


matrix 
mat_ring_create_minus1 HAS_2_ARGS(
	t_handle,		ring,
	integer_small,	dim
);
/* 
 *	Returns t_handle to (-1 * identity) matrix.
 *	"ring" is the coefficient ring.
 *	"dim" is the dimension of the matrix.
 *
 *	It calls mat_ring_create_minus1_sub
 */


t_void 
mat_ring_create_minus1_sub HAS_2_ARGS(
t_handle,	ring,
matrix,	mat
);
/* 
 *	Puts the minus 1 scalar (-1 * identity) matrix in mat.
 *	Assumes "mat" has been allocated and is UNPACKED.
 */


matrix 
mat_ring_create_zero HAS_2_ARGS(
	t_handle,		ring,
	integer_small,	dim
);
/* 
 *	Returns t_handle to zero matrix.
 *	"ring" is the coefficient ring.
 *	"dim" is the dimension of the matrix.
 *
 *	It calls mat_ring_create_zero_sub
 */


t_void 
mat_ring_create_zero_sub HAS_2_ARGS(
t_handle,	ring,
matrix *,	mat
);
/* 
 *	Puts the zero matrix in mat.
 *	Assumes "mat" has been allocated and is UNPACKED.
 */


t_int 
mat_ring_det HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the determinant of a where the coefficient ring is a generic ring
 * it calls mat_ring_det_sub
 */


void 
mat_ring_det_sub HAS_3_ARGS(
	t_handle, cring,
	matrix, a,
	t_int *,	result
);
/*
 * to find the determinant of a
 */


void
mat_ring_echelon HAS_10_ARGS(
	t_handle,		ring,
	matrix,		a,
	t_int		*,	det,
	t_int		*,	rank,
	matrix 	*,	echelon,
	t_logical *,	unit,
	t_logical, 	istoreduce,
	matrix	*,	transform,
	t_logical,	istoinverse,
	t_int,		start_row
);
/*
 * This procedure will find out determinant, rank, standard echelon form of a,
 * reduced echelon form, standard echelon transform, reduced echelon transform,
 * inverse and test whether a is unit.
 */



t_logical
mat_ring_equal HAS_3_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b
);
/*
 * Test two matrices to see if they are equal.
 * Returns TRUE if they are.
 *
 * -- Note. This function is not the most general matrix compare.
 * -- Use "mat_equality". (It is more general)
 *
 * The reason is that depending on what the function "ring_equality"
 * points to, this function may not do a full recursive equality of
 * every element in the matrix.
 */


t_void
mat_ring_insert_sub HAS_6_ARGS(
t_handle,	cring,
matrix,	a,
matrix,	b,
integer_small,	row,
integer_small,	col,
matrix*,	pc
);
/*
 * Insert the matrix "b" into the larger matrix
 * "a" beginning at the (row,col) position,
 * and giving resulting matrix "c".
 *
 * "cring" is the coefficient ring.
 * row and col start counting at one.
 */


matrix 
mat_ring_insert HAS_5_ARGS(
	t_handle,		cring,
	matrix, 	a,
	matrix,		b,
	integer_small,		row,
	integer_small,		col
);
/* 
 *	Insert the matrix "b" into the larger matrix
 *	"a" beginning at the (row,col) position,
 *	returning resulting matrix "c".
 *
 *	"cring" is the coefficient ring.
 *	row and col start counting at one.
 *
 *	It calls mat_ring_insert_sub
 */


matrix 
mat_ring_inverse HAS_2_ARGS(
	t_handle,	crg,
	matrix,	a
);
/*
 * calculate the inverse of a matrix.
 */


t_handle 
mat_ring_is_one HAS_2_ARGS(
	t_handle,		ring,
	t_ring_elt,	mat
);
/* 
 *	Returns TRUE if mat is the one (I) of the matrix ring ring.
 */


t_handle 
mat_ring_is_zero HAS_2_ARGS(
	t_handle,		ring,
	t_ring_elt,	mat
);
/* 
 *	Returns TRUE if mat is zero, coefficients from ring.
 */


matrix 
mat_ring_mult HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/* 
 *	Multiplies matrix a by matrix b,
 *	Handle to result is returned.
 *	It calls mat_ring_mult_sub
 *
 *	"ring"  is the coefficient ring.
 */


t_void
mat_ring_mult_sub HAS_4_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b,
matrix*,	pc
);
/*
 *	Multiplies matrix a by matrix b,
 *	a is (am X an), matb is (bm X bn).
 *	an must be equal to bm.
 *	Result to be stored in pc (am X bn).
 *
 *	"ring" is the coefficient ring.
 */


matrix 
mat_ring_negate HAS_2_ARGS(
	t_handle,	cring,
	matrix,	a
);
/*
 * negate all elements of a
 * it calls the mat_ring_negate_sub function
 *
 * "cring" is the coefficient ring.
 */


void
mat_ring_negate_sub HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 *
 *	"cring" is the coefficient ring.
 */



matrix 
mat_ring_power HAS_3_ARGS(
	t_handle,		cr,
	matrix,		a,
	integer_small,	n
);
/* 
 *	Evaluate the matrix ring element power a^n.
 *	For a generic ring.
 *	"a" must be a square matrix.
 *
 *	Handle to result is returned.
 *	It calls mat_ring_power_sub
 */


t_void
mat_ring_power_sub HAS_4_ARGS(
t_handle,	ring,
matrix,	a,
t_int,	n,
matrix*,	pc
);
/*
 *	Evaluate the matrix ring element power pc = a^n.
 *	"a" must be a square matrix.
 *	-- a must NOT be equal to *pc --
 *
 *	"ring" is the coefficient ring.
 */


integer_small 
mat_ring_rank HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculate the rank of a by row reduction.
 * It calls mat_ring_rank_sub
 */


void
mat_ring_row_swap HAS_4_ARGS(
	t_handle,		cring,
    matrix,		a,
    t_int,		arow,
    t_int,		brow
);
/*
** swaps the two row vectors in the matrix,
** (row arow from a) <--> (row brow from a)
*/



void
mat_ring_row_add HAS_6_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     arow,
    integer_small,     brow,
    integer_big,       mult,
	integer_small,     from
);
/*
** Adds (mult * row arow) of a to row brow of a.
** Does the addition left to right from column "from".
*/


void
mat_ring_row_mult HAS_5_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     arow,
    integer_big,       umult,
	integer_small,     from
);
/*
** replaces row arow of a with (umult * row arow) of a, where
** umult is a unit of the ring.
** Only does the replacing left to right from column "from".
*/


void
mat_ring_col_add HAS_5_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     acol,
    integer_small,     bcol,
    integer_big,       mult
);
/*
** adds (mult * column acol) of a to column bcol of a.
*/


void
mat_ring_col_mult HAS_4_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     acol,
    integer_big,       umult
);
/*
** replaces column acol of a with (umult * column acol) of a, where
** umult is a unit of the ring.
*/



t_logical
mat_ring_scalar HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is scalar.
 * Returns TRUE if so.
 * "a" must be a square matrix
 *
 * "cring" is the coefficient ring.
 * Calls mat_ring_scalar_common
 */


t_logical
mat_ring_identity HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is the identity
 * Returns TRUE if so.
 *
 * "cring" is the coefficient ring.
 * Calls mat_ring_scalar_common
 */


t_logical
mat_ring_zero HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 * Test a matrix to see if it is the zero matrix.
 * Returns TRUE if so.
 *
 * "a" can be m x n.
 *
 * "ring" is the coefficient ring.
 */


Private t_logical
mat_ring_scalar_common HAS_3_ARGS(
t_handle,	ring,
matrix,	mata,
t_int,	scval
);
/*
 * Test a matrix to see if it is scalar, where the scalar value is "scval".
 * Called by scalar and identity.
 * "mata" is assumed to be UNPACKED.
 *
 * "ring" is the coefficient ring.
 */


matrix
mat_ring_scalar_mult HAS_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b
);

/*
 * Scalar multiplication of matrix a by scalar b.
 *
 * "cring" is the coefficient ring.
 */



void
mat_ring_scalar_mult_sub HAS_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b,
	matrix*,	pc
);

/*
 * Scalar multiplication of matrix a by scalar b.
 *
 * "cring" is the coefficient ring.
 */



t_void
mat_ring_skew_tensor_sub HAS_3_ARGS(
	t_int,		ring,
	t_handle,		esn,
	t_handle *,	rsn
);
/*
** returns rsn as the skew-symmetric tensor product of the matrix esn,
** ring is the coefficient ring of the matrix ring to which rsn will belong.
** uses the space in rsn if *rsn != 0
*/


t_handle
mat_ring_skew_tensor HAS_2_ARGS(
	t_int,		ring,
	t_handle,		esn
);
/*
** calls mat_ring_skew_tensor_sub
*/



t_void
mat_ring_submat_sub HAS_7_ARGS(
t_handle,	cring,
matrix,	a,
integer_small,	rowposn,
integer_small,	colposn,
matrix*,	pc,
integer_small,	rows,
integer_small,	cols
);
/*
 * Puts in "pc" the submatrix of dimension rows x cols starting
 * at the (rowposn, colposn) entry of a.
 *
 * "cring" is the coefficient ring.
 * "rowposn" and "colposn" start counting at one.
 */


matrix 
mat_ring_submat HAS_6_ARGS(
	t_handle,		cring,
	matrix, 	mat,
	integer_small,	rowposn,
	integer_small,	colposn,
	integer_small,	rows,
	integer_small,	cols
);
/* 
 *	Returns t_handle to submatrix of "mat" with dimension rows x cols
 *	starting at the (rowposn, colposn) entry of mat.
 *
 *	"cring" is the coefficient ring.
 *	"rowposn" and "colposn" start counting at one.
 *
 *	It calls mat_ring_submat_sub
 */


matrix 
mat_ring_subtract HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
);
/*
 * calculating the difference between a & b where the coefficient ring is
 * generic ring
 * result = a - b
 * It calls mat_ring_subtract_sub
 */


void
mat_ring_subtract_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	result(i, j) = a(i, j) - b(i, j)
 */



t_void
mat_ring_tensor_sub HAS_4_ARGS(
	t_handle,      ring,
	matrix,      esn1,
	matrix,      esn2,
	matrix *,    rsn
);


t_handle
mat_ring_tensor HAS_3_ARGS(
	t_handle,      ring,
	matrix,      esn1,
	matrix,      esn2
);
/*
** calls mat_ring_tensor_sub
*/


integer_big
mat_ring_trace HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 *	Evaluate the trace of a.
 *	a must be a square matrix.
 */



t_void
mat_ring_trans_sub HAS_3_ARGS(
t_handle,	ring,
matrix,	a,
matrix*,	pc
);
/*
 * Construct the transpose pc of a.
 * a can be an m x n matrix (pc will then be n x m).
 * If a is equal to *pc, the transpose overwrites the original matrix.
 * "ring" is the coefficient ring.
 */


matrix 
mat_ring_trans HAS_2_ARGS(
	t_handle,	cring,
	matrix,	a
);
/* 
 *	Construct the transpose of a.
 *	Handle to result is returned.
 *	a can be an m x n matrix (result will then be n x m).
 *
 *	"cring" is the coefficient ring.
 *
 *	It calls mat_ring_trans_sub
 */


t_logical 
mat_ring_unit HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * check whether a is unit
 */


t_logical 
mat_ring_unit_sub HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	t_logical*,	unit
);
/*
 * check whether a is unit
 */


t_void
mat_unpack HAS_3_ARGS(
	t_handle,      ring,
	matrix,      a,
	matrix *,    b
);
/*
** unpacks matrix a into *b, allocating space for *b if *b == 0. Coefficient
** ring is ring.
*/


t_void
mat_vec_mat_rect HAS_6_ARGS(
	t_handle,	ring,
	t_handle,	srchdl,
	t_int,	srcit,
	t_handle,	matrix,
	t_handle,	desthdl,
	t_int,	destit
);
/*
Given a vector srchdl(srcit) and a matrix over ring, return their product
in desthdl(destit), which is assumed to be of the correct size.
*/


t_void
mat_vec_mat_rect HAS_6_ARGS(
	t_handle, ring,
	t_handle, srchdl,
	t_int, srcit,
	t_handle, matrix,
	t_handle, desthdl,
	t_int, destit
);
/*
Given a vector srchdl(srcit) and a matrix over ring, return their product
in desthdl(destit), which is assumed to be of the correct size.
*/


matrix 
mat_z_add HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
);
/*
 * summation of a & b
 *
 * "cring" is the coefficient ring.
 */


void
mat_z_add_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 *
 * "cring" is the coefficient ring.
 */



t_int 
mat_z_det HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/* 
 * calculating the determinant of a where the coefficient ring is integer
 * it calls mat_z_det_sub
 */


void
mat_z_echelon HAS_10_ARGS(
	t_handle,		cring,
	matrix,		a,
	t_int		*,	det1,
	t_int		*,	rank,
	matrix 	*,	echelon,
	t_logical *,	unit,
	t_logical, 	istoreduce,
	matrix	*,	transform,
	t_logical,	istoinverse,
	t_int,		start_row
);
/*
 * This procedure will find out determinant, rank, standard echelon form of a,
 * reduced echelon form, standard echelon transform, reduced echelon transform,
 * inverse and test whether a is unit.
 */



t_logical
mat_z_equal HAS_3_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b
);
/*
 * Test two matrices to see if they are equal.
 * Returns TRUE if they are.
 */


matrix 
mat_z_inverse HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the inverse of Z
 */


matrix 
mat_z_mult HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/* 
 *	Multiplies matrix a by matrix b,
 *	Handle to result is returned.
 *	It calls mat_z_mult_sub
 *
 *	"ring"  is the coefficient ring.
 */


t_void
mat_z_mult_sub HAS_4_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b,
matrix*,	pc
);
/*
 *	Multiplies matrix a by matrix b,
 *	a is (am X an), matb is (bm X bn).
 *	an must be equal to bm.
 *	Result to be stored in pc (am X bn).
 */


matrix 
mat_z_negate HAS_2_ARGS(
	t_handle,	cring,
	matrix,	a
);
/*
 * negate all elements of a
 * it calls the mat_z_negate_sub function
 *
 * "cring" is the coefficient ring.
 */


void
mat_z_negate_sub HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 *
 * "cring" is the coefficient ring.
 */



t_int 
mat_z_rank HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the rank of a by row reduction
 * It calls mat_z_rank_sub
 */


matrix 
mat_z_reduced_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the reduced echelon form of a
 * It calls mat_z_reduced_echelon_sub.
 */


matrix 
mat_z_reduced_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the reduced echelon transform matrix of a
 * It calls mat_z_reduced_echelon_transform
 */




void
mat_z_row_add HAS_6_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     arow,
    integer_small,     brow,
    integer_big,       mult,
	integer_small,     from
);
/*
** Adds (mult * row arow) of a to row brow of a.
** Does the addition left to right from column "from".
*/


void
mat_z_row_mult HAS_5_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     arow,
    integer_big,       umult,
	integer_small,     from
);
/*
** replaces row arow of a with (umult * row arow) of a, where
** umult is a unit of the ring.
** Only does the replacing left to right from column "from".
*/


void
mat_z_col_add HAS_5_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     acol,
    integer_small,     bcol,
    integer_big,       mult
);
/*
** adds (mult * column acol) of a to column bcol of a.
*/


void
mat_z_col_mult HAS_4_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     acol,
    integer_big,       umult
);
/*
** replaces column acol of a with (umult * column acol) of a, where
** umult is a unit of the ring.
*/


t_logical
mat_z_scalar HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is scalar.
 * Returns TRUE if so.
 * "a" must be a square matrix
 *
 * "cring" is the coefficient ring.
 * Calls mat_z_scalar_common
 */


t_logical
mat_z_identity HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is the identity
 * Returns TRUE if so.
 *
 * "cring" is the coefficient ring.
 * Calls mat_z_scalar_common
 */


t_logical
mat_z_zero HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 * Test a matrix to see if it is the zero matrix.
 * Returns TRUE if so.
 *
 * "a" can be m x n.
 */


Private t_logical
mat_z_scalar_common HAS_3_ARGS(
t_handle,	ring,
matrix,	mata,
t_int,	scval
);
/*
 * Test a matrix to see if it is scalar, where the scalar value is "scval".
 * Called by scalar and identity.
 * "mata" is assumed to be UNPACKED.
 *
 * "ring" is the coefficient ring.
 */


matrix
mat_z_scalar_mult HAS_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b
);

/*
 * Scalar multiplication of matrix a by scalar b.
 *
 * "cring" is the coefficient ring.
 */



void
mat_z_scalar_mult_sub HAS_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b,
	matrix*, 	pc
);

/*
 * Scalar multiplication of matrix a by scalar b.
 * Assumes matrices in Z are never packed.
 *
 * "cring" is the coefficient ring.
 */



matrix 
mat_z_standard_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the standard echelon form of a
 */


matrix 
mat_z_standard_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the standard transform matrix of a
 */


matrix 
mat_z_subtract HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
);
/*
 * calculating the difference between a & b where the coefficient ring is Z
 * result = a - b
 * It calls mat_z_subtract_sub
 *
 * "cring" is the coefficient ring.
 */


void
mat_z_subtract_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	result(i, j) = a(i, j) - b(i, j)
 *
 * "cring" is the coefficient ring.
 */



integer_big
mat_z_trace HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 *	Evaluate the trace of a.
 *	a must be a square matrix.
 */


t_logical 
mat_z_unit HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * check whether a is unit
 */


matrix 
mat_zm_add HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/*
 * summation of a & b
 */


void
mat_zm_add_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 */



t_int 
mat_zm_det HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the determinant of a where the coeffient ring is ZM
 * it calls mat_zm_det_sub
 */


t_void
mat_zm_echelon HAS_10_ARGS(
	t_handle,	cring,
	matrix,	a,
	t_int	*,	det1,
	t_int	*,	rank,
	matrix *,	echelon,
	t_logical *,	unit,
	t_logical,	istoreduce,
	matrix	*,	transform,
	t_logical,	istoinverse,
	t_int,		start_row
);
/*
 * this procedure will find out determinant, rank, standard echelon form, 
 * reduced echelon form, standard echelon transform, reduced echelon transform,
 * inverse and check whether a is unit.
 */


t_logical
mat_zm_equal HAS_3_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b
);
/*
 * Test two matrices to see if they are equal.
 * Returns TRUE if they are.
 */


matrix 
mat_zm_inverse HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the inverse of ZM
 */


matrix 
mat_zm_mult HAS_3_ARGS(
	t_handle,	ring,
	matrix,	a,
	matrix,	b
);
/* 
 *	Multiplies matrix a by matrix b,
 *	Handle to result is returned.
 *	It calls mat_zm_mult_sub
 *
 *	"ring"  is the coefficient ring.
 */


t_void
mat_zm_mult_sub HAS_4_ARGS(
t_handle,	ring,
matrix,	a,
matrix,	b,
matrix*,	pc
);
/*
 *	Multiplies matrix a by matrix b,
 *	a is (am X an), matb is (bm X bn).
 *	an must be equal to bm.
 *	Result to be stored in pc (am X bn).
 */


matrix 
mat_zm_negate HAS_2_ARGS(
	t_handle,	cring,
	matrix,	a
);
/*
 * negate all elements of a
 * it calls the mat_zm_negate_sub function
 *
 * "cring" is the coefficient ring.
 */


void
mat_zm_negate_sub HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix	*,	result
);

/*
 *	The addition of a(i, j) to b(i, j), the result is put
 *	in matrix pointer "result", *result(i,j), for every i, j.
 *
 * "cring" is the coefficient ring.
 */



t_int 
mat_zm_rank HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the rank of a by row reduction
 * It calls mat_zm_rank_sub
 */


matrix 
mat_zm_reduced_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the reduced echelon form of a
 * It calls mat_zm_reduced_echelon_sub.
 */


matrix 
mat_zm_reduced_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the reduced echelon transform matrix of a
 * It calls mat_zm_reduced_echelon_transform
 */


void
mat_zm_row_add HAS_6_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     arow,
    integer_small,     brow,
    integer_big,       mult,
	integer_small,     from
);
/*
** Adds (mult * row arow) of a to row brow of a.
** Does the addition left to right from column "from".
*/


void
mat_zm_row_mult HAS_5_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     arow,
    integer_big,       umult,
	integer_small,     from
);
/*
** replaces row arow of a with (umult * row arow) of a, where
** umult is a unit of the ring.
** Only does the replacing left to right from column "from".
*/


void
mat_zm_col_add HAS_5_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     acol,
    integer_small,     bcol,
    integer_big,       mult
);
/*
** adds (mult * column acol) of a to column bcol of a.
*/


void
mat_zm_col_mult HAS_4_ARGS(
    t_handle,            ring,
    matrix,            a,
    integer_small,     acol,
    integer_big,       umult
);
/*
** replaces column acol of a with (umult * column acol) of a, where
** umult is a unit of the ring.
*/


t_logical
mat_zm_scalar HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is scalar.
 * Returns TRUE if so.
 * "a" must be a square matrix
 *
 * "cring" is the coefficient ring.
 * Calls mat_zm_scalar_common
 */


t_logical
mat_zm_identity HAS_2_ARGS(
t_handle,	cring,
matrix,	a
);
/*
 * Test a matrix to see if it is the identity
 * Returns TRUE if so.
 *
 * "cring" is the coefficient ring.
 * Calls mat_zm_scalar_common
 */


t_logical
mat_zm_zero HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 * Test a matrix to see if it is the zero matrix.
 * Returns TRUE if so.
 *
 * "a" can be m x n.
 */


Private t_logical
mat_zm_scalar_common HAS_3_ARGS(
t_handle,	ring,
matrix,	mata,
t_int,	scval
);
/*
 * Test a matrix to see if it is scalar, where the scalar value is "scval".
 * Called by scalar and identity.
 * "mata" is assumed to be UNPACKED.
 *
 * "ring" is the coefficient ring.
 */


matrix
mat_zm_scalar_mult HAS_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b
);

/*
 * Scalar multiplication of matrix a by scalar b.
 *
 * "cring" is the coefficient ring.
 */



void
mat_zm_scalar_mult_sub HAS_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b,
	matrix*, 	pc
);

/*
 * Scalar multiplication of matrix a by scalar b.
 *
 * "cring" is the coefficient ring.
 */



matrix 
mat_zm_standard_echelon HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the standard echelon form of a
 */


matrix 
mat_zm_standard_echelon_transform HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * calculating the standard transform matrix of a
 */


matrix 
mat_zm_subtract HAS_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
);
/*
 * calculating the difference between a & b where the coefficient ring is ZM
 * result = a - b
 * It calls mat_zm_subtract_sub
 */


void
mat_zm_subtract_sub HAS_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
);

/*
 *	result(i, j) = a(i, j) - b(i, j)
 */



t_int
mat_zm_trace HAS_2_ARGS(
t_handle,	ring,
matrix,	a
);
/*
 *	Evaluate the trace of a.
 *	a must be a square matrix.
 *
 *	"ring" is the coefficient ring.
 */


t_logical 
mat_zm_unit HAS_2_ARGS(
	t_handle,	ring,
	matrix,	a
);
/*
 * check whether a is unit
 */


matrix 
mat_zmgf_power HAS_3_ARGS(
	t_handle,		mring,
	matrix,		a,
	integer_small,	n
);
/* 
 *	Evaluate the matrix ring element power a^n.
 *	For matrices of Z, Zm and GF rings.
 *	"a" must be a square matrix.
 *
 *	Handle to result is returned.
 *	It calls mat_zmgf_power_sub
 */


t_void
mat_zmgf_power_sub HAS_4_ARGS(
t_handle,	ring,
matrix,	a,
t_int,	n,
matrix*,	pc
);
/*
 *	Evaluate the matrix ring element power pc = a^n.
 *	"a" must be a square matrix.
 *	-- a must NOT be equal to *pc --
 *
 *	"ring" is the coefficient ring.
 */


#endif /* 0 */
