      SUBROUTINE STRGET(STR,SLEN,*,*)
C
C     ***************************************************************
C     *                                                             *
C     *                    S U B R O U T I N E                      *
C     *                                                             *
C     *                        S T R G E T                          *
C     *                                                             *
C     ***************************************************************
C
*DOC             internal routine, used only by COMINP
**DOC
*INDEX  STRGET(IN/0): internal routine
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       Reads a line out of DNRINP. Anything after the first asterisk (*)
**DOC       or % is ignored (comment).
**DOC       If the line is a command line (i.e., there's a "=)" in it),
**DOC       the subroutine executes RETURN 1. In this case the whole command
**DOC       line is set to capital letters.
**DOC       If EOF: RETURN 2.
**DOC       The input string is in the variable STR but additionally is
**DOC       written into the scratch file 16. Afterwards file 16 is rewinded.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       STR     (STR)    String read (with comment)
**DOC       SLEN    (INT)    Length of STR until the beginning of the comment
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       -
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       STRLEN
**DOC       STR003
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS/US    1987
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       MS/US    1988      File 16
**DOC       JS       11.01.89  % as comment
**DOC       JS       16.01.89  Changing command lines to capital letters
**DOC       JS       09.04.90  leaving *-comment if (FLD=)
**DOC       JS       16.08.90  Handling of * before (FLD=)
**DOC
%include 'field.inc'
C
      CHARACTER*(*)     STR
      INTEGER           SLEN, SPROC, SFLD
C
      DO 100 I=1,LEN(STR)
         STR(I:I) = ' '
  100 CONTINUE
C
   10 READ(DNRINP,1000,ERR=20,END=9999) STR
 1000 FORMAT(A)
C
   20 SLEN  = INDEX(STR,'*')
      SPROC = INDEX(STR,'%')
      SFLD  = INDEX(STR,'(FLD=)')
      IF(SPROC.GT.0.AND.SPROC.LT.SLEN) SLEN = SPROC
      IF(SFLD.GT.SLEN) SFLD = 0
C
      IF ( SLEN.NE.0.AND.SFLD.EQ.0 ) THEN
         DO 200 I=SLEN,LEN(STR)
            STR(I:I) = ' '
  200    CONTINUE
      ENDIF
C
      CALL STRLEN(STR,SLEN)
C
      IF ( SLEN.EQ.0 ) GO TO 10
C
      IF ( INDEX(STR,'=)' ).NE.0 ) THEN
         CALL STR003(STR,STR,SLEN)
         GO TO 9998
      ENDIF
C
      REWIND 16
      WRITE(16,*) STR(1:SLEN)
      REWIND 16
C
      RETURN
 9998 RETURN 1
 9999 RETURN 2
      END
