      SUBROUTINE FLNGET(FNR,*)
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                        F L N G E T                             *
C     *                                                                *
C     ******************************************************************
C
*DOC             gets a file number for scratch files
**DOC
*INDEX  FLNGET(IN/2): gets a Scratch File Number
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This routine looks for a file number for scratch files which
**DOC       can be used. The file is not opened but it is guaranteed
**DOC       that this file number is not occupied by another file.
**DOC       For giving the file number back you have to call FLKILL. The
**DOC       routine FLKILL also closes the file.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       FNR     (INT)   Number of scratch file to be openend
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       IER      = 601    if all numbers are occupied
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       IERDEL
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       DEBUG
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       25.07.89
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       JS       10.08.89  IER 601 instead of 1
**DOC       JS       28.06.90  ERRMSG, IERDEL
**DOC
*
%include 'debug.inc'
*
      INTEGER I, FNR
*                      
      CALL IERDEL()
      DO 100 I=1,FLEDIM     
         IF(FLENRS(2,I).EQ.0) THEN
            FLENRS(2,I) = 1
            FNR = FLENRS(1,I)
            GOTO 9999
         ENDIF
100   CONTINUE
      IER = 601
      ERRMSG = 'FLNGET: All file numbers are occupied.'
*
9999  IF(IER.EQ.0) RETURN
      RETURN 1
      END
