      SUBROUTINE COMINP(*)
*
*   Version for Anf-Package without PRMINI!  ==>  (ITB RKUB=) does not work!
C
C     ***************************************************************
C     *                                                             *
C     *                    S U B R O U T I N E                      *
C     *                                                             *
C     *                        C O M I N P                          *
C     *                                                             *
C     ***************************************************************
C
*DOC             Input of number field data
**DOC
*INDEX  COMINP(FI/2): Input of Number Field Data
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This is a primitive input routine for number field data which can
**DOC       be used in dialog. You have to call it once for reading a number
**DOC       field (that means for example  N, F or ITB). RETURN 1 means
**DOC       "End of file".
**DOC       At the beginning of COMINP the first 10 EXFLAGs are set to zero.
**DOC       For reading data you first have to give a command ending
**DOC       with "=)" and in the next line the data belonging to the
**DOC       statement. Examples are given below.
**DOC       The EXFLAGs which indicate what kind of data are present are
**DOC       initialized automatically.
**DOC
**DOC       An asterisk or % in a command line indicates the beginning of
**DOC       a comment and is ignored.
**DOC       Command syntax examples (commands needn't to be in capitals):
**DOC       (TITEL=)   *   (Title input)
**DOC                  *********************************
**DOC                  *         FORD     1 - 10       *
**DOC                  *********************************
**DOC       (N=)        *   (Input of field dimension N)
**DOC       3
**DOC       (F=)        *   (Coefficients of minimal polynomial)
**DOC       9,23,14,1   *   (decreasing, leading coeff=1; N is computed autom.)
**DOC       (USF=)      *   (Field data according to US-conventions)
**DOC       (ITB=)      *   (Input of integral basis)
**DOC       1,R,R2,(1+R3)/4     * (The string is analyzed automatically)
**DOC       pow                 * = power basis
**DOC       (USBASIS=)  *   (Integral basis according to US-conventions)
**DOC       (missing)
**DOC       (TSTFLG=)   *
**DOC       2
**DOC       (DNRINP=)   *
**DOC       5
**DOC       (DNROUT=)   *
**DOC       6           *    you can also type DNRIER
**DOC       (DLEVEL=)   *
**DOC       3
**DOC       (DNRIER=)   *
**DOC       2           *    you can also type DNROUT
**DOC       (INIFLG=)   *
**DOC       1
**DOC       (INFILE=)   *    opens an input file with number DNRINP
**DOC       FLD.DAT
**DOC       (INFILE=)   *    opens an output file with number DNROUT
**DOC       UNIT.OUT
**DOC       (RIEHYP=)   *    from now on we assume the GRH
**DOC       1
**DOC       (OUTFLG=)   *    Output in COMOUT ?
**DOC       1                yes 
**DOC       (PRECIS=)   *    do you want to compute with not so much precision ?
**DOC       0                yes
**DOC       (REGLBD=)   *    Input of a lower bound for the regulator
**DOC       5.123D0          (should be greater than zero)
**DOC       (FLD=)      *   (Field data; compatible to COMOUT)
**DOC                       (should not be used in dialog)
**DOC       (EXFLAG=)   *   (Input of an EXFLAG)
**DOC       3,4         *   (this means:  EXFLAG(3) <-- 4)
**DOC       (FILE=)     *   (Input of a file name (e.g. for FORD1 format)
**DOC       //kant1/bsd4.2/user/kant/dat/f4s0lf.dat  * (this file name is default)
**DOC       (FORD1=)    *   (Field data in FORD-convention; obsolete format)
**DOC       1,10        *    Example 1 through 10 from file FILE
**DOC       (FORD2=)    *   (Field data in FORD-convention)
**DOC       1,10        *    Example 1 through 10 from file FILE
**DOC                        For using this FORD format, the data file must
**DOC                        be "packed", i.e. it must be in direct access
**DOC                        where the record numbers are the example numbers
**DOC                        A sequential file can be packed by using the
**DOC                        user program FILE1.
**DOC       (JOB=)      *    gives your field a name
**DOC       Klaus-Dieter
**DOC       (JS=)       *    (Number field data in JS-convention)
**DOC        4,2,2,7,   *     N, TSTFLG, EXFLAG(10), DLEVEL
**DOC        0,0,0,34   *     coefficients of polynomial
**DOC        0          *     CDEN (=0 means: power basis)
**DOC        0          *     Field discriminant, =0 means: will be computed
**DOC        -1         *     The next numbers are logarithms of units
**DOC       9.477       *
**DOC      -9.477       *
**DOC                   *     (A positive number would have indicated that
**DOC                   *      the next numbers are coefficients of units;
**DOC                   *      each unit in a row)
**DOC       (ITB RKUB.=)*   (Initialization of a pure cubic field)
**DOC       3,5         *   from F(X)=X**3+3 to F(X)=X**3+5
**DOC       (FUNIT=)    *   (Initialization of FUNIT)
**DOC        1,0,1      *   (EXFLAG(2) is initialized automatically)
**DOC        0,1,-1     *
**DOC       (BUCHMANN=) *   (Number field data in JB-convention)
**DOC       (EOF=)      *   (Simulation of file end)
**DOC       (END=)      *   (End of Record)
**DOC                   *   (you have to type it after each field)
**DOC                   *   (excluding: FORD2, JSREAD, BUCHMANN,
**DOC                   *               ITB RKUB.)
**DOC
**DOC        N.B.: (INFILE=) and (OUTFILE=) don't seem to work on Siemens.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       dependent on input, possible is:
**DOC       INIFLG
**DOC       DLEVEL
**DOC       TSTFLG
**DOC       DNRIER
**DOC       DNRINP
**DOC       DNROUT
**DOC       all number field related parameters
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       STRGET      STR001
**DOC       STRLEN      INITI4
**DOC       PRMINI      STROO3
**DOC       COMIN0
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC       LARITH
**DOC       LFIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS/US    1987
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       JS       28.03.88  Einfuehrung von EXFLAGs
**DOC       JS       06.05.88  Fehlerausgabe bei falschem Kommando
**DOC                          und (INFILE=), (OUTFILE=) bzw. (ERRFILE=)
**DOC                          Voreinstellung FILENA=//kant1/bsd4.2/user/kant/da
**DOC                          TSTFLG-Ausgabe bei Label 9999
**DOC       JS       09.05.88  EXFLAG bei BUCHMANN
**DOC                          EXFLAG(1,..,10) <--  0
**DOC       JS       01.06.88  (END=), (EOR=) und (EOF=)
**DOC       JS       03.06.88  (F=)
**DOC       JS       07.06.88  (PRIMES=) und (JS=) statt (JSREAD=)
**DOC                          Voreinstellung der Ford-Daten ab sofort
**DOC                          in BLDATA!
**DOC       JS       08.06.88  Belegung von EXFLAG(1) bei (ITB RKUB.=)
**DOC       JS       15.06.88  Quadratische Zahlkoerper bei (F=)
**DOC       JS       16.06.88  (ITB=)  (wie (RHOBASIS=))
**DOC       JS       11.07.88  Berichtigung quadratische Zahlkoerper
**DOC       JS       12.07.88  Quadratische Zahlkoerper auch bei (JS=)
**DOC                          DNROUT als Wert fuer (DNRIER=) und umgekehrt
**DOC       JS       13.07.88  bei (ITB=) auch POT als Wert
**DOC                          EXFLAG bei (ITB=)
**DOC       JS/SD    26.07.88  STR*256 und nicht *80
**DOC       JS/SD    09.08.88  STR*128 und nicht *256 wg. MX2
**DOC       JS/SD    12.09.88  Declaration of ZIFF, ICOUNT and NPRIME
**DOC       JS       21.09.88  new format FORD2 (Label 38000 for FORDx)
**DOC                          Label 23000 is not used anymore
**DOC       JS       17.10.88  (JOB=) at label 23000
**DOC       JS       21.12.88  Torsion units
**DOC       JS       13.02.89  pot = POT
**DOC       JS/FS    14.02.89  Reading long units
**DOC       JS       24.02.89  pow = POT
**DOC       JS       08.03.89  CLOSE(16)
**DOC       JS       28.06.89  different input of FUNLOG at (FLD=)
**DOC       JS       01.07.89  (RIEHYP=) (Riemann hypothesis)   
**DOC       JS       24.07.89  Error detected in FORMAT 38001 (3X instead of 2X)
**DOC       US       31.07.89  EXFLAG(1) gesetzt bei (POT RKUB.=) und (ITB RKUB.=)
**DOC       JS       29.08.89  RECL=80 instead of 132
**DOC       BA/FS    27.11.89  PRECIS,REGLBD
**DOC       JS       07.12.89  (FILE02=)
**DOC       JS       02.01.90  (GALGRP=)
**DOC       JS       10.01.90  (FILE02=) works now!
**DOC       JS       02.02.90  Input string: length=256
**DOC       MJ/JS    12.02.90  (FLDFLE=) and FLDFLG
**DOC       MJ/JS    15.02.90  new version of FLDRD
**DOC       JS       22.02.90  COMIN0
**DOC       JS       05.03.90  no setting of EXFLAG if (F=) or (USF=)
**DOC       JS       09.04.90  using File 16 when reading RDISC and REG at (FLD=)
**DOC       JS       10.04.90  FLDNR, EXFLAG(6), CG*
**DOC       MH/JS    23.04.90  STR = '***' also when end of file
**DOC       JS       27.06.90  RDISC and REG <-- 0 before reading it at (FLD=)
**DOC       JS       05.07.90  Modified EXFLAG(1)-handling
**DOC       JS       17.07.90  also e, E, q or Q as EOF (if length of STR=1)
**DOC       JS       06.09.90  Filenames of length up to 256 allowed
**DOC       JS       30.10.90  Unconditional increment of FLDNR
**DOC       FS       23.11.90  LZRFLG, LZEROS
**DOC       JS       12.06.91  TSTSUB, TSTFL2
**DOC
%include 'field.inc'
%include 'larith.inc'
%include 'lfield.inc'
C
      INTEGER           KOEFFS(20),RHOFLG,VZ,KOEFF,EXPPOS,I,J,L,IBASIS
      INTEGER           ZFLAG,KPOS,DENFLG, DENOM, IANF,IEND,ZIFF
      INTEGER           ICOUNT,NPRIME,IFORD,IAEX3,IZAEHL,I1,I2,II,J1
      INTEGER           PRIMES(200), KQUAD, SQIANF, PQUAD, MODUL9
      DOUBLE PRECISION  XBUCH(4)
      CHARACTER*40      FORDS
      CHARACTER*256     STR,STRFRD,FILE1
      INTEGER           SLEN,POS,LENNAM
      SAVE              IANF,IEND,STR
      DATA              SLEN/0/
      DATA              STR/'***'/
      DATA              IANF,IEND /0,-1/
C*    wird ab 7.6.88 in BLDATA vorbelegt (Name FILE01)
C*    DATA              FILENA /'//kant1/bsd4.2/user/kant/dat/im4.dat'/
C
C---------------------------------------------------------------------
C     AUSFUEHRBARE ANWEISUNGEN
C---------------------------------------------------------------------
C
*     Erasing of the last field
*
      CALL COMIN0()
*
*     Oeffnen der Scratch-Datei fuer Dateneingabe
*
      OPEN(16,ERR=10,STATUS='SCRATCH')
C
   10 IF ( INDEX(STR,'(TITEL=)'     ).NE.0 ) GO TO 10000
      IF ( INDEX(STR,'(N=)'         ).NE.0 ) GO TO 11000
      IF ( INDEX(STR,'(FKOEFFS=)'   ).NE.0 ) GO TO 12000
      IF ( INDEX(STR,'(F=)'         ).NE.0 ) GO TO 12000
      IF ( INDEX(STR,'(USF=)'       ).NE.0 ) GO TO 13000
      IF ( INDEX(STR,'(RHOBASIS=)'  ).NE.0 ) GO TO 14000
      IF ( INDEX(STR,'(ITB=)'       ).NE.0 ) GO TO 14000
      IF ( INDEX(STR,'(USBASIS=)'   ).NE.0 ) GO TO 15000
      IF ( INDEX(STR,'(CDEN=)'      ).NE.0 ) GO TO 16000
      IF ( INDEX(STR,'(DEBUGLEVEL=)').NE.0 ) GO TO 17000
      IF ( INDEX(STR,'(DLEVEL=)'    ).NE.0 ) GO TO 17000
      IF ( INDEX(STR,'(ERROUT=)'    ).NE.0 ) GO TO 18000
      IF ( INDEX(STR,'(DNRIER=)'    ).NE.0 ) GO TO 18000
      IF ( INDEX(STR,'(INIPROT=)'   ).NE.0 ) GO TO 19000
      IF ( INDEX(STR,'(INIFLG=)'    ).NE.0 ) GO TO 19000
      IF ( INDEX(STR,'(FLD=)'       ).NE.0 ) GO TO 20000
      IF ( INDEX(STR,'(EXFLAG=)'    ).NE.0 ) GO TO 21000
      IF ( INDEX(STR,'(PRIMES=)'    ).NE.0 ) GO TO 22000
      IF ( INDEX(STR,'(JOB=)'       ).NE.0 ) GO TO 23000
      IF ( INDEX(STR,'(FILE=)'      ).NE.0 ) GO TO 24000
      IF ( INDEX(STR,'(FILE01=)'    ).NE.0 ) GO TO 24000
      IF ( INDEX(STR,'(TESTLAUF=)'  ).NE.0 ) GO TO 25000
      IF ( INDEX(STR,'(TSTFLG=)'    ).NE.0 ) GO TO 25000
      IF ( INDEX(STR,'(TSTFL1=)'    ).NE.0 ) GO TO 25000
      IF ( INDEX(STR,'(DNRINP=)'    ).NE.0 ) GO TO 26000
      IF ( INDEX(STR,'(DNROUT=)'    ).NE.0 ) GO TO 27000
      IF ( INDEX(STR,'(REDID=)'     ).NE.0 ) GO TO 28000
      IF ( INDEX(STR,'(NRFLAG=)'    ).NE.0 ) GO TO 29000
      IF ( INDEX(STR,'(JSREAD=)'    ).NE.0 ) GO TO 30000
      IF ( INDEX(STR,'(JS=)'        ).NE.0 ) GO TO 30000
      IF ( INDEX(STR,'(POT RKUB.=)' ).NE.0 ) GO TO 31000
C*      IF ( INDEX(STR,'(ITB RKUB.=)' ).NE.0 ) GO TO 32000
      IF ( INDEX(STR,'(FUNIT=)'     ).NE.0 ) GO TO 33000
      IF ( INDEX(STR,'(BUCHMANN=)'  ).NE.0 ) GO TO 34000
      IF ( INDEX(STR,'(INFILE=)'    ).NE.0 ) GO TO 35000
      IF ( INDEX(STR,'(OUTFILE=)'   ).NE.0 ) GO TO 36000
      IF ( INDEX(STR,'(ERRFILE=)'   ).NE.0 ) GO TO 37000
      IF ( INDEX(STR,'(FORD1=)'     ).NE.0 ) GO TO 38000
      IF ( INDEX(STR,'(FORD2=)'     ).NE.0 ) GO TO 38000
      IF ( INDEX(STR,'(RIEHYP=)'    ).NE.0 ) GO TO 39000
      IF ( INDEX(STR,'(OUTFLG=)'    ).NE.0 ) GO TO 40000
      IF ( INDEX(STR,'(PRECIS=)'    ).NE.0 ) GO TO 41000
      IF ( INDEX(STR,'(REGLBD=)'    ).NE.0 ) GO TO 42000
      IF ( INDEX(STR,'(REGLBD=)'    ).NE.0 ) GO TO 42000
      IF ( INDEX(STR,'(FILE02=)'    ).NE.0 ) GO TO 43000
      IF ( INDEX(STR,'(GALGRP=)'    ).NE.0 ) GO TO 44000
      IF ( INDEX(STR,'(FLDFLE=)'    ).NE.0 ) GO TO 45000
      IF ( INDEX(STR,'(LZRFLG=)'    ).NE.0 ) GO TO 46000
      IF ( INDEX(STR,'(LZEROS=)'    ).NE.0 ) GO TO 47000
      IF ( INDEX(STR,'(TSTSUB=)'    ).NE.0 ) GO TO 48000
      IF ( INDEX(STR,'(TSTFL2=)'    ).NE.0 ) GO TO 49000
C
      IF ( INDEX(STR,'(DATEIENDE=)' ).NE.0 ) GO TO 9999
      IF ( INDEX(STR,'(EOF=)'       ).NE.0 ) GO TO 9999
      IF ( INDEX(STR,'(DATENENDE=)' ).NE.0 .OR.
     *     INDEX(STR,'(END=)'       ).NE.0 .OR.
     *     INDEX(STR,'(EOR=)'       ).NE.0 ) THEN
         STR = '***'
         GO TO 9998
      ENDIF
C
C---------------------------------------------------------------------
C     KEIN STEUERBEFEHL ERKANNT - NEUE ZEILE HOLEN
C---------------------------------------------------------------------
C
*  Fehlermeldung, falls falscher Kommandostring gelesen wurde
*
      IF (INDEX(STR,'=)').NE.0)
     *         WRITE(DNRIER,*) 'What the hell is ',STR(1:SLEN),'   ?'
20    CALL STRGET(STR,SLEN,*10,*9999)
      IF(SLEN.EQ.1.AND.
     *   STR(1:1).EQ.'E'.OR.STR(1:1).EQ.'e'.OR.
     *   STR(1:1).EQ.'Q'.OR.STR(1:1).EQ.'q')   THEN
         STR = '(EOF=)'
         SLEN= 6
         GOTO 10
      ELSE
         GO TO 20
      ENDIF
C
C---------------------------------------------------------------------
C     EINLESEN EINES TITELS
C---------------------------------------------------------------------
C
10000 READ(DNRINP,'(A)',ERR=10010,END=9999) STR
C
10010 CALL STRLEN(STR,SLEN)
C
      IF ( INDEX(STR,'=)' ).NE.0 ) GO TO 10
C
      IF ( SLEN.NE.0 ) THEN
         WRITE(DNRIER,*) STR
      ELSE
         WRITE(DNRIER,*) ' '
      ENDIF
C
      GO TO 10000
C
C---------------------------------------------------------------------
C     EINLESEN VON N
C---------------------------------------------------------------------
C
11000 CALL STRGET(STR,SLEN,*10,*9999)
C
C
      READ(16,*,ERR=9999,END=9999) N
C
      GO TO 11000
C
C---------------------------------------------------------------------
C     EINLESEN VON F (KOEFFIZIENTEN ALS ZEILE)
C---------------------------------------------------------------------
C
12000 CALL STRGET(STR,SLEN,*10,*9999)
C
      N      = 1
      KPOS   = 0
C
12010 POS = INDEX(STR(KPOS+1:SLEN),',')
C
      IF ( POS.NE.0 ) THEN
         N    = N    + 1
         KPOS = KPOS + POS
         IF ( KPOS.LT.SLEN ) GO TO 12010
      ENDIF
C
      READ(16,*,ERR=9999,END=9999) (F(I),I=1,N)
*
*  Quadratische Zahlkoerper
*
      IF(N.EQ.2.AND.F(1).EQ.0) THEN
         J = -F(2)
         IF(J.LT.0) J = J+4*IABS(J)
         IF((J-1)/4*4.NE.J-1) THEN
            EXFLAG(1) = 1
         ELSE
            EXFLAG(1) = 2
            CDEN = 2
            ITB(1,1) = 1
            ITB(2,1) = 0
            ITB(3,1) = 1
            ITB(1,2) = 1
            ITB(2,2) = 1
            ITB(3,2) = 2
         ENDIF
      ENDIF
C
      GO TO 12000
C
C---------------------------------------------------------------------
C     EINLESEN VON F (JE EIN KOEFFIZIENT PRO ZEILE)
C---------------------------------------------------------------------
C
13000 N = 0
C
13010 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,ERR=9999,END=9999) F(N+1)
C
      N = N + 1
C
      GO TO 13010
C
C---------------------------------------------------------------------
C     EINLESEN EINER GANZHEITSBASIS IN RHOPOTENZSCHREIBWEISE
C---------------------------------------------------------------------
C
14000 CALL STRGET(STR,SLEN,*10,*9999)
*
*  changing the string to capitals
*
      CALL STR003(STR,STR,SLEN)
*
*  Power basis?
*
      IF(INDEX(STR,'POT').NE.0.OR.INDEX(STR,'POW').NE.0) THEN
         EXFLAG(1) = 1
         GOTO 14000
      ENDIF
C
      EXFLAG(1) = 2
      IBASIS = 1
      RHOFLG = 0
C*      POS    = 1
      EXPPOS = 1
      VZ     = 1
      KOEFF  = 0
      DENOM  = 1
      DENFLG = 0
C
      DO 14020 I=1,MAXDIM+1
         DO 14010 J=1,MAXDIM
            ITB(I,J) = 0
14010    CONTINUE
14020 CONTINUE
C
      DO 700 I=1,SLEN
C
         IF ( STR(I:I).EQ.',' ) THEN
            IF ( DENFLG.EQ.1 ) THEN
               DENOM = VZ * KOEFF
            ELSE
               ITB(EXPPOS,IBASIS) = VZ * KOEFF
            ENDIF
            ITB(N+1,IBASIS) = DENOM
            IBASIS = IBASIS + 1
            RHOFLG = 0
C*            POS    = 1
            EXPPOS = 1
            VZ     = 1
            KOEFF  = 0
            DENOM  = 1
            DENFLG = 0
         ENDIF
C
         IF ( STR(I:I).EQ.'+' ) THEN
            IF ( EXPPOS.GT.0 ) ITB(EXPPOS,IBASIS) = VZ * KOEFF
            KOEFF  = 0
            VZ     = 1
            RHOFLG = 0
         ENDIF
C
         IF ( STR(I:I).EQ.'-' ) THEN
            IF ( EXPPOS.GT.0 ) ITB(EXPPOS,IBASIS) = VZ * KOEFF
            KOEFF  = 0
            VZ     = -1
            RHOFLG = 0
         ENDIF
C
         IF ( STR(I:I).EQ.'/' ) THEN
            IF ( EXPPOS.GT.0 ) ITB(EXPPOS,IBASIS) = VZ * KOEFF
            KOEFF  = 0
            VZ     = 1
            DENFLG = 1
            RHOFLG = 0
         ENDIF
C
         ZFLAG = 0
C
         IF ( STR(I:I).EQ.'0' ) THEN
            ZFLAG = 1
            ZIFF  = 0
         ENDIF
C
         IF ( STR(I:I).EQ.'1' ) THEN
            ZFLAG = 1
            ZIFF  = 1
         ENDIF
C
         IF ( STR(I:I).EQ.'2' ) THEN
            ZFLAG = 1
            ZIFF  = 2
         ENDIF
C
         IF ( STR(I:I).EQ.'3' ) THEN
            ZFLAG = 1
            ZIFF  = 3
         ENDIF
C
         IF ( STR(I:I).EQ.'4' ) THEN
            ZFLAG = 1
            ZIFF  = 4
         ENDIF
C
         IF ( STR(I:I).EQ.'5' ) THEN
            ZFLAG = 1
            ZIFF  = 5
         ENDIF
C
         IF ( STR(I:I).EQ.'6' ) THEN
            ZFLAG = 1
            ZIFF  = 6
         ENDIF
C
         IF ( STR(I:I).EQ.'7' ) THEN
            ZFLAG = 1
            ZIFF  = 7
         ENDIF
C
         IF ( STR(I:I).EQ.'8' ) THEN
            ZFLAG = 1
            ZIFF  = 8
         ENDIF
C
         IF ( STR(I:I).EQ.'9' ) THEN
            ZFLAG = 1
            ZIFF  = 9
         ENDIF
C
         IF ( ZFLAG.EQ.1 ) THEN
            IF ( RHOFLG.EQ.0 ) THEN
               KOEFF = 10*KOEFF + ZIFF
            ELSE
               EXPPOS = ZIFF + 1
            ENDIF
         ENDIF
C
         IF ( STR(I:I).EQ.'R' ) THEN
            EXPPOS = 2
            RHOFLG = 1
            IF ( KOEFF.EQ.0 ) KOEFF = 1
         ENDIF
C
  700 CONTINUE
C
      IF ( DENFLG.EQ.1 ) THEN
         DENOM = VZ * KOEFF
      ELSE
         ITB(EXPPOS,IBASIS) = VZ * KOEFF
      ENDIF
C
      ITB(N+1,IBASIS) = DENOM
C
      GO TO 14000
C
C---------------------------------------------------------------------
C     EINLESEN EINER GANZHEITSBASIS ALS SPALTENVEKTOREN (BZGL. RHO)
C---------------------------------------------------------------------
C
15000 DO 15200 J=1,N
         DO 15100 I=1,N+1
            CALL STRGET(STR,SLEN,*10,*9999)
            READ(16,*,ERR=9999,END=9999) ITB(I,J)
15100    CONTINUE
15200 CONTINUE
C
C---------------------------------------------------------------------
C     EINLESEN DES GEMEINSAMEN NENNERS DER GANZHEITSBASIS
C---------------------------------------------------------------------
C
16000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,ERR=9999,END=9999) CDEN
C
      GO TO 16000
C
C---------------------------------------------------------------------
C     EINLESEN DES DEBUGLEVELS
C---------------------------------------------------------------------
C
17000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,ERR=9999,END=9999) DLEVEL
C
      GO TO 17000
C
C---------------------------------------------------------------------
C     EINLESEN DER ERRORDATEINUMMER
C---------------------------------------------------------------------
C
18000 CALL STRGET(STR,SLEN,*10,*9999)
C
      IF(INDEX(STR(1:SLEN),'DNROUT').NE.0) THEN
         DNRIER = DNROUT
      ELSE
         READ(16,*,END=9999,ERR=9999) DNRIER
      ENDIF
C
      GO TO 18000
C
C---------------------------------------------------------------------
C     EINLESEN DES INITIALISIERUNGSPROTOKOLLFLAGS
C---------------------------------------------------------------------
C
19000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,ERR=9999,END=9999) INIFLG
C
      GO TO 19000
C
C---------------------------------------------------------------------
C     EINLESEN EINES KOERPERS
C---------------------------------------------------------------------
C
20000 J = INDEX(STR,'(FLD') 
      READ(STR(J:),20001,ERR=9999,END=9999) N,(EXFLAG(I),I=1,10)
20001 FORMAT(7X,11(I3,1X))                                      
      NS = EXFLAG(10)
      NST= NS + (N-NS)/2
      REWIND(16)
      WRITE(16,*) STR(J+53:)
      REWIND(16)                     
      RDISC = 0.0D0
      REG   = 0.0D0
      READ(16,*,ERR=20101,END=20101) RDISC, REG
20101 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,ERR=9999,END=9999) (F(I),I=1,N)
      IF(EXFLAG(1).NE.0) THEN
         IF (EXFLAG(1).EQ.1) THEN
            CDEN = 1
            CALL INITI4(ITB,MAXDIM+1,N,1,1)
            DO 20002 I=1,N
20002          ITB(N+1,I) = 1
         ELSE IF(IABS(EXFLAG(1)).EQ.2) THEN
            DO 20003 J=1,N
               CALL STRGET(STR,SLEN,*10,*9999)
20003          READ(16,*,END=9999,ERR=9999) (ITB(I,J),I=1,N+1)
         ENDIF
      ENDIF
      IAEX3 = IABS(EXFLAG(3))
      IF (IAEX3.EQ.0) THEN
         IF (EXFLAG(2).GT.0) THEN
            NR = EXFLAG(2)
            DO 20004 J=1,NR
               CALL STRGET(STR,SLEN,*10,*9999)
20004          READ(16,*,END=9999,ERR=9999) (FUNIT(I,J),I=1,N)
         ELSE
            IF(EXFLAG(2).LT.0) THEN
               NR = -EXFLAG(2)
                  DO 20005 I=1,NR+1
                     CALL STRGET(STR,SLEN,*10,*9999)
                     READ(16,*,END=9999,ERR=9999)
     *                    (FUNLOG(I,J),J=1,NR)
20005          CONTINUE
            ENDIF
         ENDIF
      ELSE
         DO 20006 J=1,IAEX3
            DO 20006 I=1,N
C*             CALL STRGET(STR,SLEN,*10,*9999)
20006          CALL LREAD(DNRINP,LFUNIT(1,I,J))
         DO 20007 I=1,IAEX3+1
20007       READ(DNRINP,*,END=9999,ERR=9999)
     *                    (FUNLOG(I,J),J=1,IAEX3)
      ENDIF
      IF(EXFLAG(4).GT.2) THEN
         CALL STRGET(STR,SLEN,*10,*9999)
         READ(16,*,END=9999,ERR=9999) (FUNIT(I,N),I=1,N)
      ENDIF
*   
*  Galois group
*
      IF(EXFLAG(6).NE.0) THEN
         CALL STRGET(STR,SLEN,*10,*9999)
         GALGRP = STR(1:6)
      ENDIF
*
*  class group
*        
      IF(EXFLAG(7).EQ.0) THEN
         CGH = 0
      ELSE IF(EXFLAG(7).EQ.1) THEN
         CGH = 1
         CGIDN = 0
         CGCYC = 0
      ELSE
         READ(DNRINP,*) CGH, CGCYC,(CGORD(I),I=1,CGCYC)
         READ(DNRINP,*) CGIDN
         IF(CGIDN.GT.0) THEN
            DO 20008 I=1,CGIDN
20008          READ(DNRINP,*) (CGID(J,I),J=-1,N)
            DO 20009 I=1,CGCYC
20009          READ(DNRINP,*) (CGIDXP(J,I),J=1,CGIDN)
         ENDIF
      ENDIF

C
      IF ( LZRFLG.EQ.1 ) GOTO 10
      STR='(DATENENDE=)'
      GO TO 10
C
C---------------------------------------------------------------------
C     EINLESEN EINES EXFLAGS
C---------------------------------------------------------------------
C
21000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,ERR=9999,END=9999) I1,I2
      IF(I1.LT.1.OR.I1.GT.50) GOTO 21000
      EXFLAG(I1) = I2
C
      GO TO 21000
C
C---------------------------------------------------------------------
C     Einlesen des Primzahldateinamens
C---------------------------------------------------------------------
C
22000 CALL STRGET(STR,SLEN,*10,*9999)
C
      PRMFLE = STR
C
      GO TO 22000
C
C---------------------------------------------------------------------
C     Input of a job name
C---------------------------------------------------------------------
C
23000 CALL STRGET(STR,SLEN,*10,*9999)
      JOBNAM = STR
      GO TO 23000
C
C---------------------------------------------------------------------
C     EINLESEN EINES DATEINAMENS
C---------------------------------------------------------------------
C
24000 CALL STRGET(STR,SLEN,*10,*9999)
C
      FILE01 = STR
C
      GO TO 24000
C
C---------------------------------------------------------------------
C     EINLESEN VON TSTFLG ZUR STEUERUNG VON TESTAUSGABEN
C---------------------------------------------------------------------
C
25000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,END=9999,ERR=9999) TSTFLG  
      TSTFL1=TSTFLG
C
      GO TO 25000
C
C---------------------------------------------------------------------
C     EINLESEN DER INPUT-DATEINUMMER
C---------------------------------------------------------------------
C
26000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,END=9999,ERR=9999) DNRINP
C
      GO TO 26000
C
C---------------------------------------------------------------------
C     EINLESEN DES PARAMETERS REDID FUER HAUPTIDEALTESTS
C---------------------------------------------------------------------
C
28000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,END=9999,ERR=9999) EXFLAG(10)
C
      GO TO 28000
C
C---------------------------------------------------------------------
C     EINLESEN DES FLAGS NRFLAG FUER EXISTENZANZEIGE DER EINHEITEN
C---------------------------------------------------------------------
C
29000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,END=9999,ERR=9999) EXFLAG(2)
C
      GO TO 29000
C
C---------------------------------------------------------------------
C     EINLESEN DER OUTPUT-DATEINUMMER
C---------------------------------------------------------------------
C
27000 CALL STRGET(STR,SLEN,*10,*9999)
C
      IF(INDEX(STR(1:SLEN),'DNRIER').NE.0) THEN
         DNROUT = DNRIER
      ELSE
         READ(16,*,END=9999,ERR=9999) DNROUT
      ENDIF
C
      GO TO 27000
C
C---------------------------------------------------------------------
C     EINLESEN DER KOERPERDATEN NACH J.S.-KONVENTION
C---------------------------------------------------------------------
C
30000 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999)N,TSTFLG,EXFLAG(10),DLEVEL
      CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) (F(I),I=1,N)
      CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) CDEN
      CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) RDISC
      IF (DABS(RDISC).LE.MAXINT) DISC = IDNINT(RDISC)
      IF (CDEN.EQ.0) THEN
         EXFLAG(1) = 1
         CDEN = 1
         CALL INITI4(ITB,MAXDIM+1,N,1,1)
         DO 30001 I=1,N
30001       ITB(N+1,I) = 1
      ELSE
         EXFLAG(1) = 2
         DO 30002 J=1,N
            CALL STRGET(STR,SLEN,*10,*9999)
30002       READ(16,*,END=9999,ERR=9999) (ITB(I,J),I=1,N+1)
      ENDIF
      CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) EXFLAG(2)
      IF (EXFLAG(2).GT.0) THEN
         DO 30003 J=1,EXFLAG(2)
            CALL STRGET(STR,SLEN,*10,*9999)
30003       READ(16,*,END=9999,ERR=9999) (FUNIT(I,J),I=1,N)
      ELSE IF(EXFLAG(2).LT.0) THEN
         DO 30004 J=1,-EXFLAG(2)
            DO 30004 I=1,-EXFLAG(2)+1
               CALL STRGET(STR,SLEN,*10,*9999)
               READ(16,*,END=9999,ERR=9999) FUNLOG(I,J)
30004    CONTINUE
      ELSE
         EXFLAG(2) = 0
      ENDIF
*
*  Quadratische Zahlkoerper
*
      IF(N.EQ.2.AND.F(1).EQ.0.AND.EXFLAG(1).EQ.1) THEN
         J = -F(2)
         IF(J.LT.0) J = J+4*IABS(J)
         IF((J-1)/4*4.NE.J-1) THEN
            EXFLAG(1) = 1
         ELSE
            EXFLAG(1) = 2
            CDEN = 2
            ITB(1,1) = 1
            ITB(2,1) = 0
            ITB(3,1) = 1
            ITB(1,2) = 1
            ITB(2,2) = 1
            ITB(3,2) = 2
         ENDIF
      ENDIF
C
      STR = '(DATENENDE=)'
      GOTO 10
C
C---------------------------------------------------------------------
C     VORBELEGUNG FUER EIN REIN KUBISCHES BEISPIEL IN POTENZBASIS
C---------------------------------------------------------------------
C
31000 IF (IANF.GT.IEND) THEN
         CALL STRGET(STR,SLEN,*31001,*9999)
         GOTO 31002
31001    IANF = 0
         IEND = -1
         GOTO 10
31002    READ(16,*,END=9999,ERR=9999) IANF,IEND
         STR = '(POT RKUB.=)'
      ENDIF
C
      F(1) = 0
      F(2) = 0
      F(3) = -IANF
C
      N = 3
C
      ITB(1,1) = 1
      ITB(2,1) = 0
      ITB(3,1) = 0
      ITB(4,1) = 1
C
      ITB(1,2) = 0
      ITB(2,2) = 1
      ITB(3,2) = 0
      ITB(4,2) = 1
C
      ITB(1,3) = 0
      ITB(2,3) = 0
      ITB(3,3) = 1
      ITB(4,3) = 1
C
      EXFLAG(1) = 1
C
      CDEN = 1
C
      IANF = IANF + 1
C
      IF (IANF.GT.IEND) THEN
         CALL STRGET(STR,SLEN,*31003,*9999)
         GOTO 31004
31003    IANF = 0
         IEND = -1
         GOTO 10
31004    READ(16,*,END=9999,ERR=9999) IANF,IEND
         STR = '(POT RKUB.=)'
      ENDIF
      GOTO 9998
C
C---------------------------------------------------------------------
C     VORBELEGUNG FUER EIN REIN KUBISCHES BEISPIEL IN GANZHEITSBASIS
C---------------------------------------------------------------------
C
32000 IF (IANF.GT.IEND) THEN
         CALL STRGET(STR,SLEN,*32002,*9999)
         GOTO 32003
32002    IANF = 0
         IEND = -1
         GOTO 10
32003    READ(16,*,END=9999,ERR=9999) IANF,IEND
         STR = '(ITB RKUB.=)'
      ENDIF
C
      SQIANF = SQRT(FLOAT(IANF)) + 2
C
C*      CALL PRMINI(PRIMES,200,SQIANF,NPRIME,1,*9999)
C
      KQUAD = 1
C
      DO 32001 I=1,NPRIME
         PQUAD = PRIMES(I)*PRIMES(I)
         IF ( (IANF/PQUAD)*PQUAD.EQ.IANF ) KQUAD = KQUAD * PRIMES(I)
32001 CONTINUE
C
      MODUL9 = MOD(IANF,9)
C
      F(1) = 0
      F(2) = 0
      F(3) = -IANF
C
      N = 3
C
      ITB(1,1) = 1
      ITB(2,1) = 0
      ITB(3,1) = 0
      ITB(4,1) = 1
C
      ITB(1,2) = 0
      ITB(2,2) = 1
      ITB(3,2) = 0
      ITB(4,2) = 1
C
      ITB(1,3) = 0
      ITB(2,3) = 0
      ITB(3,3) = 1
      ITB(4,3) = KQUAD
C
      CDEN = KQUAD
C
      EXFLAG(1) = 2
C
      IF ( IABS(MODUL9).EQ.1 ) THEN
         ITB(1,3) =          KQUAD * KQUAD
         ITB(2,3) = MODUL9 * KQUAD * KQUAD
         ITB(4,3) = 1
         ITB(4,3) = 3 * KQUAD
         CDEN     = 3 * KQUAD
      ENDIF
C
      IF(CDEN.EQ.1) THEN
         EXFLAG(1) = 1
      ELSE
         EXFLAG(1) = 2
      ENDIF
      IANF = IANF + 1
C
      IF (IANF.GT.IEND) THEN
         CALL STRGET(STR,SLEN,*32005,*9999)
         GOTO 32006
32005    IANF = 0
         IEND = -1
         GOTO 10
32006    READ(16,*,END=9999,ERR=9999) IANF,IEND
         STR = '(ITB RKUB.=)'
      ENDIF
      GOTO 9998
C
C---------------------------------------------------------------------
C     EINLESEN VON UNABHAENGIGEN BZW. GRUNDEINHEITEN
C---------------------------------------------------------------------
C
33000 DO 33001 IZAEHL=1,MAXDIM
        CALL STRGET(STR,SLEN,*10,*9999)
        READ(16,*,END=9999,ERR=9999) (FUNIT(II,IZAEHL),II=1,N)
        EXFLAG(2) = IZAEHL
33001 CONTINUE
C
C---------------------------------------------------------------------
C     EINLESEN DER KOERPERDATEN IN "FORD-SCHREIBWEISE"; N = 4, NR = 3
C     MIT UNABHAENGIGEN EINHEITEN
C---------------------------------------------------------------------
C
*
34000 N = 4
      NP1 = 5
      NR = 3
      EXFLAG(2) = 3
      FORDS = '                                        '
      CALL STRGET(STR,SLEN,*10,*9999)
      READ(STR,34001,END=9999,ERR=34010) DISC,(F(I),I=1,4),FORDS
34001 FORMAT(I7,I7,3(I5),10X,A40)
34010 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) (XBUCH(I),I=1,4)
      DO 34002 II=1,4
34002 FUNIT(II,1)=IDNINT(XBUCH(II))
      CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) (XBUCH(I),I=1,4)
      DO 34008 II=1,4
34008 FUNIT(II,2)=IDNINT(XBUCH(II))
      CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) (XBUCH(I),I=1,4)
      DO 34009 II=1,4
34009 FUNIT(II,3)=IDNINT(XBUCH(II))
      RDISC = DISC
      F(1) = -F(1)
      F(3) = -F(3)
      CALL INITI4(ITB,MAXDIM+1,N,1,1)
      DO 34003 I=1,N
34003    ITB(NP1,I) = 1
      DO 34004 L=40,1,-1
34004    IF (FORDS(L:L).NE.' ') GOTO 34005
      CDEN = 1
      EXFLAG(1) = 1
      GOTO 34011
34005 I = INDEX(FORDS,',')
      EXFLAG(1) = 2
      IF (I.EQ.0) THEN
         J = INDEX(FORDS,'xxx')
         IF (J.NE.0) THEN
            CALL STR001(FORDS,L,ITB(1,4),N)
         ELSE
            J = INDEX(FORDS,'xx')
            IF (J.NE.0) THEN
               CALL STR001(FORDS,L,ITB(1,3),N)
*              Rho wird zum dritten Basiselement hinzuadjungiert
               DO 34006 J1=1,3
34006             ITB(J1+1,4) = ITB(J1,3)
               ITB(NP1,4) = ITB(NP1,3)
            ELSE
               CALL STR001(FORDS,L,ITB(1,2),N)
            ENDIF
         ENDIF
      ELSE
         J = INDEX(FORDS(1:I-1),'xxx')
         IF (J.NE.0) THEN
            CALL STR001(FORDS,I-1,ITB(1,4),N)
         ELSE
            J = INDEX(FORDS(1:I-1),'xx')
            IF (J.NE.0) THEN
               CALL STR001(FORDS,I-1,ITB(1,3),N)
            ELSE
               CALL STR001(FORDS(1:I-1),I-1,ITB(1,2),N)
            ENDIF
         ENDIF
         J = INDEX(FORDS(I+1:L),'xxx')
         IF (J.NE.0) THEN
            CALL STR001(FORDS(I+1:L),L-I,ITB(1,4),N)
         ELSE
            J = INDEX(FORDS(I+1:L),'xx')
            IF (J.NE.0) THEN
               CALL STR001(FORDS(I+1:L),L-I,ITB(1,3),N)
            ELSE
               CALL STR001(FORDS(I+1:L),L-I,ITB(1,2),N)
            ENDIF
         ENDIF
      ENDIF
*
      CDEN = 1
      DO 34007 I=2,4
34007      CDEN = CDEN * ITB(NP1,I)
34011 STR = '(BUCHMANN=)'
      GOTO 9998
C
C---------------------------------------------------------------------
C     Einlesen eines Eingabedatei-Namens
C---------------------------------------------------------------------
C
35000 CALL STRGET(STR,SLEN,*10,*9999)
      FILE1 = STR
      CALL STRLEN(FILE1,LENNAM)
      OPEN (DNRINP,FILE=FILE1(1:LENNAM),ERR=35001)
      GO TO 35000
35001 WRITE(DNRIER,*) 'COMINP: invalid filename: ',FILE1
      GO TO 35000
C
C---------------------------------------------------------------------
C     Einlesen eines Ausgabedatei-Namens
C---------------------------------------------------------------------
C
36000 CALL STRGET(STR,SLEN,*10,*9999)
      FILE1 = STR
      CALL STRLEN(FILE1,LENNAM)
      OPEN (DNROUT,FILE=FILE1(1:LENNAM),ERR=36001)
      GO TO 36000
36001 WRITE(DNRIER,*) 'COMINP: invalid filename: ',FILE1
      GO TO 36000
C
C---------------------------------------------------------------------
C     Einlesen eines Fehlerdatei-Namens
C---------------------------------------------------------------------
C
37000 CALL STRGET(STR,SLEN,*10,*9999)
      FILE1 = STR
      CALL STRLEN(FILE1,LENNAM)
      OPEN (DNRIER,FILE=FILE1(1:LENNAM),ERR=37001)
      GO TO 37000
37001 WRITE(DNRIER,*) 'COMINP: invalid filename: ',FILE1
      GO TO 37000
C
C---------------------------------------------------------------------
C     EINLESEN DER KOERPERDATEN IN "FORD-SCHREIBWEISE"; N = 4
C
C     FORD1: altes Format fuer beliebige Dateien (siehe Label 23000)
C     FORD2: neues Format fuer Dateien im direkten Zugriff.
C---------------------------------------------------------------------
C
38000 STRFRD = STR
      IF (IANF.LE.IEND) GOTO 38014
38002    IF(IANF.LE.IEND) CLOSE(17)
38013    CALL STRGET(STR,SLEN,*38010,*9999)
         STR = STRFRD
         GOTO 38011
38010    IANF = 0
         IEND = -1
         GOTO 10
38011    READ(16,*,END=9999,ERR=9999) IANF,IEND
         IF(IANF.GT.IEND.OR.IANF.LE.0) GOTO 38013
*
38014 FORDS = '                                        '
      ICOUNT = 0
      IF (INDEX(STRFRD,'(FORD2=)').NE.0) THEN
38008    ICOUNT = ICOUNT + 1
         IF (ICOUNT.GT.100000) GOTO 9999
         OPEN(17,FILE=FILE01,ERR=38008,
     *        STATUS='OLD',FORM='FORMATTED',ACCESS='DIRECT',RECL=80)
         READ(17,38001,REC=IANF,ERR=38002)
     *                           (F(I),I=1,4),DISC,GALGRP(5:6),FORDS
C*         FLDNR = IANF                              
         EXFLAG(6) = 1
      ELSE
38508    ICOUNT = ICOUNT + 1
         IF (ICOUNT.GT.1000000) GOTO 9999
         OPEN(17,FILE=FILE01,ERR=38508)
         DO 38509 I=1,IANF-1
            READ(17,'(1X)',END=38002,ERR=38509)
38509    CONTINUE
         READ(17,38001,END=38002,ERR=38015)
     *                          (F(I),I=1,4),DISC,GALGRP(5:6),FORDS
C*         FLDNR = IANF
         EXFLAG(6) = 1
      ENDIF
38001 FORMAT(I4,3(I5),I8,4X,A2,3X,A40)
38015 IANF = IANF + 1
      CLOSE (17)
      N = 4
      NP1 = 5
      RDISC = DISC
      F(1) = -F(1)
      F(3) = -F(3)
      CALL INITI4(ITB,MAXDIM+1,N,1,1)
      DO 38003 I=1,N
38003    ITB(NP1,I) = 1
      DO 38004 L=40,1,-1
38004    IF (FORDS(L:L).NE.' ') GOTO 38005
      CDEN = 1
      EXFLAG(1) = 1
      GOTO 9998
38005 I = INDEX(FORDS,',')
      EXFLAG(1) = 2
      IF (I.EQ.0) THEN
         J = INDEX(FORDS,'xxx')
         IF (J.NE.0) THEN
            CALL STR001(FORDS,L,ITB(1,4),N)
         ELSE
            J = INDEX(FORDS,'xx')
            IF (J.NE.0) THEN
               CALL STR001(FORDS,L,ITB(1,3),N)
*              Rho wird zum dritten Basiselement hinzuadjungiert
               DO 38006 J1=1,3
38006             ITB(J1+1,4) = ITB(J1,3)
               ITB(NP1,4) = ITB(NP1,3)
            ELSE
               CALL STR001(FORDS,L,ITB(1,2),N)
            ENDIF
         ENDIF
      ELSE
         J = INDEX(FORDS(1:I-1),'xxx')
         IF (J.NE.0) THEN
            CALL STR001(FORDS,I-1,ITB(1,4),N)
         ELSE
            J = INDEX(FORDS(1:I-1),'xx')
            IF (J.NE.0) THEN
               CALL STR001(FORDS,I-1,ITB(1,3),N)
            ELSE
               CALL STR001(FORDS(1:I-1),I-1,ITB(1,2),N)
            ENDIF
         ENDIF
         J = INDEX(FORDS(I+1:L),'xxx')
         IF (J.NE.0) THEN
            CALL STR001(FORDS(I+1:L),L-I,ITB(1,4),N)
         ELSE
            J = INDEX(FORDS(I+1:L),'xx')
            IF (J.NE.0) THEN
               CALL STR001(FORDS(I+1:L),L-I,ITB(1,3),N)
            ELSE
               CALL STR001(FORDS(I+1:L),L-I,ITB(1,2),N)
            ENDIF
         ENDIF
      ENDIF
*
      CDEN = 1
      DO 38007 I=2,4
38007      CDEN = CDEN * ITB(NP1,I)
      GOTO 9998
C
C---------------------------------------------------------------------
C     Input of GRH-Parameter
C---------------------------------------------------------------------
C
39000 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) RIEHYP
      GO TO 39000
C
C---------------------------------------------------------------------
C     Input of OUTFLG-Parameter
C---------------------------------------------------------------------
C
40000 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) OUTFLG
      GO TO 40000
C
C---------------------------------------------------------------------
C     Input of PRECIS-Parameter
C---------------------------------------------------------------------
C
41000 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) PRECIS
      GO TO 41000
C
C---------------------------------------------------------------------
C     Input of REGLBD-Parameter
C---------------------------------------------------------------------
C
42000 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) REGLBD
      GO TO 42000
C
C---------------------------------------------------------------------
C     Input of filename FILE02 (for free use)
C---------------------------------------------------------------------
C
43000 CALL STRGET(STR,SLEN,*10,*9999)
C
      FILE02 = STR(1:SLEN)
C
      GO TO 43000
C
C---------------------------------------------------------------------
C     Input of GALGRP (structure od Galois group; 6 characters)
C---------------------------------------------------------------------
C
44000 CALL STRGET(STR,SLEN,*10,*9999)
C
      GALGRP = STR(1:6)
      EXFLAG(6) = 1
C
      GO TO 44000
C
C---------------------------------------------------------------------
C     Input of filename for field file
C---------------------------------------------------------------------
C
45000 CALL STRGET(STR,SLEN,*10,*9999)
C
      CALL FLDRD(I,STR(1:SLEN),*9999)
      FLDFLG = 1
C
      GO TO 45000
C
C---------------------------------------------------------------------
C     Input of LZRFLG
C---------------------------------------------------------------------
C
46000 CALL STRGET(STR,SLEN,*10,*9999)
      READ(16,*,END=9999,ERR=9999) LZRFLG
      GOTO 46000
C
C---------------------------------------------------------------------
C     Input of the long zeroes
C---------------------------------------------------------------------
C
47000 DO 47010 J=1,N
         CALL RREAD1(LROOTF(1,J),DNRINP)
47010 CONTINUE
C
      STR='(DATENENDE=)'
      GO TO 10
C
C---------------------------------------------------------------------
C     Input of subroutine list for testing
C---------------------------------------------------------------------
C
48000 CALL STRGET(STR,SLEN,*10,*9999)
      TSTSUB(1:1) = ','
      TSTSUB(2:) = STR
      CALL STRLEN(TSTSUB,LENNAM)
      TSTSUB(LENNAM+1:LENNAM+1) = ','
      DO 48001 I=2,LENNAM
48001    IF(TSTSUB(I:I).EQ.' ') TSTSUB(I:I) = ','
      CALL STR003 (TSTSUB,TSTSUB,LENNAM)
      GO TO 48000
C
C---------------------------------------------------------------------
C     Input of alternative TSTFLG
C---------------------------------------------------------------------
C
49000 CALL STRGET(STR,SLEN,*10,*9999)
C
      READ(16,*,END=9999,ERR=9999) TSTFL2
C
      GO TO 49000
C
C---------------------------------------------------------------------
C     AUSGANG
C---------------------------------------------------------------------
C
 9998 CLOSE(16)
      FLDNR = FLDNR + 1
      RETURN
 9999 CLOSE(16)
      IF(TSTFLG.GT.5) WRITE(DNRIER,*) 'COMINP: last string = ',STR
      STR = '***'
      RETURN 1
      END  
