      SUBROUTINE CH5TOB(VQUELL,VZIEL)
C
C     ************************************************************
C     *                                                          *
C     *      S U B R O U T I N E   C H 5 T O B                   *
C     *                                                          *
C     ************************************************************
C
*DOC             Umwandlung der mit LREAD eingelesenen Zahlen
*DOC             ***** INTERNES UNTERPROGRAMM *****
C
C                Aenderung BA   22.12.88  C* wieder weg vor Label 220
C                Aenderung JS/SD 18.5.88  BASIS 10**5 und 10**7
C                Aenderung JS 05.05.88    C*  vor unreachable statement
C                Aenderung SD 01.12.87    BASIS 10**7
C                Aenderung SD 11.08.87    *-Deklaration
C                Aenderung JS 02.10.86    BASIS 10**5
C
**DOC Wandelt eine in LREAD zur Basis 10**5 eingelesene lange Zahl
**DOC in die aktuelle Basisdarstellung der Arithmetikmoduln.
**DOC
**DOC Version: Modulbasis 10**7
C
******************************************************************
C
*DOC             XXXXXXXXXXXx XXx XXXXXXX
**DOC
*INDEX  xxxxxx(AM/2): xXXXX xXXXXXXXX; xXXXX ( xX xXXX)
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       Reference(s):
**DOC
**DOC   (2) PARAMETER (IN):
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       -
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       START       END
**DOC       OVFLOW      AINORM
**DOC       HERMIT      DETI4
**DOC       COPYI4
**DOC       -
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       DEBUG
**DOC       FIELD
**DOC       LARITH
**DOC       -
**DOC
**DOC   (8) AUTHOR(S):
**DOC       XX       XX.XX.88
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       -
**DOC
%include 'debug.inc'
%include 'larith.inc'
C
C     ARRAY ARGUMENTS
      INTEGER           VQUELL(*),VZIEL(*)
C
C     LOCAL ARRAYS
      INTEGER           ZEHN(8)
C
      DATA ZEHN /1,10,100,1000,10000,100000,1000000,10000000/
C
******************************************************************
*
*  Basisabfrage
*
      IF(LBASIS.EQ.100000) GOTO 5000
      IF(LBASIS.NE.10000000) THEN
         WRITE(DNRIER,*)
     *        'CH5TOB: Programmierfehler, LBASIS nicht unterstuetzt'
         STOP
      ENDIF
*
*  Basis 10**7
*
      IVLEN = VQUELL(1)
      IVORZ = ISIGN(1,IVLEN)
      IVLEN = IABS(IVLEN)
C
      IF ( IVLEN*5/7+2 .GT. LDIM ) THEN
         STOP '***** FEHLER 101 IN LARITH *****'
      ENDIF
C
      ISWAP = IVLEN+1
      INULL = 0
      DO 100 I=2,ISWAP
         IF ( INULL.EQ.0 ) THEN
            IF ( VQUELL(I).NE.0 ) THEN
               INULL = I
            ELSE
               IVLEN=IVLEN-1
            ENDIF
         ENDIF
  100 CONTINUE
C
      IF ( INULL.NE.0 ) THEN
         DO 200 I=1,IVLEN
           ISWAP = ISWAP-1
           VZIEL(I+1) = VQUELL(ISWAP+1)
  200    CONTINUE
C
         IEXP1 = 0
         INDST = 2
         INDZI = 2
         IVLEN = IVLEN + 1
  210    VZIEL(INDZI) = VZIEL(INDST) / ZEHN(IEXP1+1)
         IF (INDST .EQ. IVLEN) GOTO 220
         INDST = INDST + 1
         IEXP1 = IEXP1 + 2
         IF (IEXP1 .GE. 5) THEN
            VZIEL(INDZI) = VZIEL(INDZI) +
     *           VZIEL(INDST) * ZEHN(8-IEXP1)
            IF (INDST .EQ. IVLEN) GOTO 220
            INDST = INDST + 1
            IEXP1 = IEXP1 - 5
         ENDIF
         IF (IEXP1.GT.0) THEN
            VZIEL(INDZI) = VZIEL(INDZI) +
     *           MOD(VZIEL(INDST),ZEHN(IEXP1+1)) * ZEHN(8-IEXP1)
         ENDIF
         INDZI = INDZI + 1
         GOTO 210
C
  220    IF (VZIEL(INDZI) .EQ. 0) INDZI = INDZI - 1
         VZIEL(1) = (INDZI-1) * IVORZ
      ELSE
         VZIEL(1) = 0
      ENDIF
      GOTO 9999
*
*  Basis 10**5
*
5000  IVLEN = VQUELL(1)
      IVORZ = ISIGN(1,IVLEN)
      IVLEN = IABS(IVLEN)
C
      IF ( IVLEN+1.GT.LDIM ) THEN
         STOP '***** FEHLER 101 IN LARITH *****'
      ENDIF
C
      ISWAP = IVLEN+1
      INULL = 0
      DO 5100 I=2,ISWAP
         IF ( INULL.EQ.0 ) THEN
            IF ( VQUELL(I).NE.0 ) THEN
               INULL = I
            ELSE
               IVLEN=IVLEN-1
            ENDIF
         ENDIF
 5100 CONTINUE
C
      IF ( INULL.NE.0 ) THEN
         INULL = 1
         DO 5200 I=1,IVLEN
           ISWAP = ISWAP-1
           VZIEL(I+1) = VQUELL(ISWAP+1)
 5200    CONTINUE
      ENDIF
C
      VZIEL(1) = INULL*IVORZ*IVLEN
C
9999  RETURN
      END
