#include "kant.h"
#include "thue.h" 

extern t_real thue_func_H();

t_real
thue_solution_root_of_H WITH_3_ARGS(
                thue,           th,
                t_real,         k,
		vector,		Z
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_int		deg, r, j, l;
	t_handle	R;
	t_real		h1, h2, h3, h4, h5;
        t_real          start, step, lambda, m, f0, x;
        order           ord;
        vector          koeff, koeff2, T;
        t_logical       found;
        anf             field;

        ord = thue_order(th);
        deg = order_abs_degree(ord);
        R = thue_reals(th);
        r = order_r(ord);
        field = order_anf(ord);

        koeff = vec_new(deg);
        koeff2= vec_new(deg);
        T     = vec_new(deg);

        for (j=2;j<=deg;j++)
                {
                h1 = real_subtract(R, vec_entry(Z, j), vec_entry(Z, 1) );
                vec_entry(T, j) =  real_abs(R, h1);
                real_delete(&h1);
                }
        vec_entry(T, 1) = conv_int_to_real(R, 0);
        for (j=1;j<=deg;j++)
                {
                vec_entry(koeff, j) = conv_int_to_real(R, 0);
                vec_entry(koeff2, j) = conv_int_to_real(R, 0);
                }
        vec_entry(koeff, 1) = real_incref(vec_entry(T, 2) );
        vec_entry(koeff, 2) = conv_int_to_real(R, -1);
        for (j=3;j<=deg;j++)
                {
                for (l=2;l<=deg;l++)
                        {
                        real_delete(&vec_entry(koeff2, l));
                        vec_entry(koeff2, l) = real_negate(R, vec_entry(koeff, l-1) );
                        }
                real_delete(&vec_entry(koeff2, 1) );
                vec_entry(koeff2, 1) = conv_int_to_real(R, 0);
                for (l=1;l<=deg;l++)
                        {
                        h1 = real_mult(R, vec_entry(T, j), vec_entry(koeff, l) );
                        h2 = real_add(R, vec_entry(koeff2, l), h1);
                        real_delete(&vec_entry(koeff2, l) );
                        vec_entry(koeff2, l) = h2;
                        real_delete(&h1);
                        }                
                for (l=1;l<=deg;l++)
                        {
                        real_delete(&vec_entry(koeff, l) );
                        vec_entry(koeff, l) = real_incref(vec_entry(koeff2, l));
                        }
                }
        vec_delete(R, &koeff2);

        m = conv_int_to_real(R, thue_M(th));
        f0 = conv_int_to_real(R, thue_coeff(th,1)); 
        h1 = real_divide(R, m, f0);
        real_delete(&m);
        real_delete(&f0);
        h2 = real_abs(R, h1);
        real_delete(&h1);
        h3 = conv_int_to_real(R, deg);
        h4 = conv_int_to_real(R, 2);
        h5 = real_divide(R, h4, h3);
        real_delete(&h3);
        real_delete(&h4);
        h1 = real_real_power(R, h2, h5);
        real_delete(&h2);
        real_delete(&h5);
        h2 = real_divide(R, h1, k);
        real_delete(&h1); 
        h1 = vec_entry(koeff, deg-1);
        vec_entry(koeff, deg-1) = real_subtract(R, h1, h2);
        real_delete(&h1);

        start = conv_int_to_real(R, 0);
        h1 = conv_int_to_real(R, 10);
        step = real_divide(R, vec_entry(T, 2), h1);
        real_delete(&h1);

        found = regula_falsi_zero(R, start, step, &thue_func_H, koeff, deg-1, &lambda);
        if (found = FALSE)
                {
                printf("Fehler in thue_solution_root_of_H:  NSt von thue_func_H nicht gef.\n\n");
                }
        real_delete(&start);
        real_delete(&step);
        vec_delete(R, &koeff);
        vec_delete(R, &T);

        return lambda;
}

