#include "kant.h"
#include "thue.h" 

t_logical
thue_eqn_solutions WITH_1_ARG(
                thue,           th
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg, r, i, j, f, r1, r2, precision;
	t_handle	R, R_high, Z, R_ord;
	t_real		ymax, alpha, A, Ti, T, k, y0;
        t_real          thigh_ymax, t_ymax, h1, a_r, a_i;
        order           ord;
        anf             field;
        vector          alphas, Zeroes;

        ord = thue_order(th);
        deg = thue_abs_degree(th);
        R = thue_reals(th);
        R_ord = order_reals(ord);
	Z = m_z_str_incref(structure_z);
        r = order_r(ord);
        field = order_anf(ord);

        thue_solution_pos(th) = dyn_arr_alloc(1);
        thue_solution_neg(th) = dyn_arr_alloc(1);
            
        t_ymax = thue_solutions_ymax(th);
     
        if (thue_print_level(th) >= 2)
                {
		printf("Upper bound for |y| = ");real_write(R, t_ymax, 20);puts("");
                }

        T = conv_int_to_real(R, 1);
	Zeroes = vec_new(deg);
        k = conv_double_to_real(R, .5);
	for (i=1;i<=deg;i++)
		{
		Zeroes = vec_new(deg);
		for (j=1;j<=deg;j++)
			{
			if (j==1 || j==i)
				{
				if (j==1)
					{
					vec_entry(Zeroes, 1) = thue_conv_real_to_real(R_ord, anf_poly_z_zero(field, 1, i), R);
					}
				else
					{
					vec_entry(Zeroes, j) = thue_conv_real_to_real(R_ord, anf_poly_z_zero(field, 1, 1), R);
					}
				}
			else
				{
				vec_entry(Zeroes, j) = thue_conv_real_to_real(R_ord, anf_poly_z_zero(field, 1, j), R);
				}
			}
        	Ti = thue_solution_root_of_H(th, k, Zeroes);
		h1 = T;
		T = real_min(R, h1, Ti);
		real_delete(&h1);
                vec_delete(R, &Zeroes);
	        if (thue_print_level(th) >= 4)
                        {
			printf("Ti = ");real_write(R, Ti, 20);puts("");
			} 
                }
        if (thue_print_level(th) >= 3)
                {
		printf("T = ");real_write(R, T, 20);puts("");
                } 
        real_delete(&k);
        precision = thue_cf_precision(th, t_ymax);
        if (thue_print_level(th) >= 2)
                {
		printf("Continued fraction: Precision = %d\n",precision);
                }
	R_high = real_str_create(precision); 
        integer_delete(&precision);
        alphas = thue_poly_zeroes(R_high, anf_poly_z_poly(field, 1), deg, &r1);
        thigh_ymax = thue_conv_real_to_real(R, t_ymax, R_high);

        for (i=1; i<=r1; i++)
                { 
        	h1 = thue_cont_fraction_A(th, R_high, vec_entry(alphas, i), thigh_ymax);
                A = thue_conv_real_to_real(R_high, h1, R);
                real_delete(&h1);
                ymax = thue_solution_upper_bound2(th, T, A, t_ymax);
                alpha = thue_conv_real_to_real(R_high, vec_entry(alphas, i), R);
                thue_big_solutions(th, alpha, ymax);
                real_delete(&ymax);
                real_delete(&A);
                real_delete(&alpha);
                }
	r2 = (deg-r1)/2;
	for (i=r1+1; i<=r1+r2; i++)
		{
		a_r = thue_conv_real_to_real(R_high, vec_entry(alphas, i), R);
		a_i = thue_conv_real_to_real(R_high, vec_entry(alphas, i+r2), R);
		thue_complex_solutions(th, a_r, a_i);
		real_delete(&a_r);
		real_delete(&a_i);
		}

        y0 = thue_solution_upper_bound1(th, T, t_ymax);
        thue_small_solutions(th, y0);   
        real_delete(&y0);
        vec_delete(R_high, &alphas);
        real_delete(&T);
        real_delete(&t_ymax);
        real_delete(&thigh_ymax);

        if (thue_print_level(th) >= 99)
                {
		printf("Folgende Loesungen wurden nicht gefunden :\n");
		y0 = conv_double_to_real(R, 100.0);
		thue_small_solutions(th, y0);
		real_delete(&y0);
                }

        return TRUE;

}
