#include "kant.h"
#include "thue.h" 

t_real
thue_cont_fraction_A WITH_4_ARGS(
                thue,           th,
                t_handle,       R,
                t_real,         alpha,
                t_real,         ymax
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_int		qn2, qn1, qn, a0, an, n;
	t_real		theta, theta1, test, test_old;
        t_real          A, h1, h2, zero, one;

	zero = conv_int_to_real(R, 0);
	one = conv_int_to_real(R, 1);
	h1 = real_frac(R, alpha);
	if (real_compare(R, h1, zero) == -1)
		{
		h2 = real_add(R, h1, one);
		}
	else
		{
		h2 = real_incref(h1);
		}
	real_delete(&h1);
	real_delete(&zero);
	real_delete(&one);

        theta = real_inverse(R, h2);
	real_delete(&h2);
        qn2 = 0;
        qn1 = 1;
        A = conv_int_to_real(R, 0);
        test_old = conv_int_to_real(R, 0);
        test = conv_int_to_real(R, 0);
        for(n=2;;n++)
                { 
       		theta1 = thue_frac_step_A(R, qn2, qn1, theta, &qn);
                real_delete(&test_old);
                test_old = real_abs(R, test);
                real_delete(&test);
                test = conv_int_to_real(R, qn);
                if (real_compare(R, test_old, ymax) == 1)
                        break;
                h1 = real_int(R, theta1);
                h2 = A;
                A = real_max(R, h2, h1);
                real_delete(&h1);
                real_delete(&h2);
                integer_delete(&qn2);
                qn2 = qn1;
                qn1 = qn;
                real_delete(&theta);
                theta = theta1;
                } 
        integer_delete(&qn2);
        integer_delete(&qn1);
        integer_delete(&qn);
        real_delete(&theta);
        real_delete(&theta1);
        real_delete(&test);
        real_delete(&test_old);

        return A;

}


