#include "kant.h"
#include "thue.h" 

t_logical
thue_bd_step WITH_7_ARGS(
                thue,           th,
                t_handle,       R,
                dyn_arr_handle, delta,
                dyn_arr_handle, log_delta_r,
                t_real,         c4,
                t_real,         c5,
                t_real,         Q1
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg, r, i, i_max, j, j_max,l, m;
	t_real		Q2, Q3, test, test1, eps, E, q_max, dist_min;
        t_real          h1, h2, q, B1, B11, c44, c55, dum, htest, hganz;
        order           ord;
        vector          alpha;
        Logical         appr, appr1;
        t_handle        R_ord, R_thue;
        dyn_arr_handle  alpha2;


        ord = thue_order(th);
        deg = thue_abs_degree(th);
        r = order_r(ord);
        R_ord = order_reals(ord);
        R_thue = thue_reals(th);

        thue_bd_Q23(th, R, &Q2, &Q3); 
        if (thue_print_level(th) >= 3)
                {
	        printf("Q1 = "); real_write(R, Q1, 20); puts("");
	        printf("Q2 = "); real_write(R, Q2, 20); puts("");
	        printf("Q3 = "); real_write(R, Q3, 20); puts("");
                }

        test = thue_bd_test(th, R, Q1, Q2);
        if (thue_print_level(th) >= 3)
                {
	        printf("test = "); real_write(R, test, 20); puts(""); 
                }

        eps = thue_bd_eps(th, R, Q1, Q3);
        if (thue_print_level(th) >= 3)
                {
	        printf("eps = "); real_write(R, eps, 20); puts("");
                }
        E = thue_bd_E(th, R, Q1, Q3);
        if (thue_print_level(th) >= 3)
                {
	        printf("E = "); real_write(R, E, 20); puts("");
                }
           
        appr = TRUE;
        q_max = conv_int_to_real(R, 0);
        dist_min = conv_int_to_real(R, 1);
        B1 = conv_int_to_real(R, 1);
        i_max = dyn_arr_curr_length(delta);
        for (i=0; i<i_max; i++)
                {
                alpha = dyn_arr_element(delta, i);
	        if (thue_print_level(th) >= 4)
                        {
			printf("alpha = \n");
			for(l=1;l<r;l++)
				{
				real_write(R_ord, vec_entry(alpha, l), 20); puts("");
				}
			printf("log_delta_r = ");real_write(R_ord, dyn_arr_element(log_delta_r, i), 20);
			puts("");
                        }
                q = thue_bd_approximation(th, R, alpha, E);
                h1 = q_max;
                q_max = real_max(R, q_max, q);
                real_delete(&h1);
	        if (thue_print_level(th) >= 4)
                        {
	                printf("q = ");real_write(R,q,20); puts("");
                        }
		htest=real_mult(R, Q1, Q3);
		if (real_compare(R, q, htest) == 1)
			{
			printf("Thue_Baker: q is nich kleiner als Q1*Q3");
			printf("Q1 * Q3 = ");real_write(R, htest, 20);puts("");
			}
		real_delete(&htest);
		for (m=1;m<=r;m++)
			{
                        h1 = thue_conv_real_to_real(R_ord, vec_entry(alpha, m), R);
			htest = real_mult(R, q, h1);      
                        real_delete(&h1);
			hganz = real_to_next_int(R, htest);
			if (real_compare(R, hganz, eps) == 1)
				{
				printf("Thue_Baker: q zu schlecht!");
				printf("q* alpha%d = ",m);real_write(R, htest, 20);puts("");
				}
			real_delete(&htest);
			real_delete(&hganz);
 			}
                appr1 = TRUE;
                j_max = dyn_arr_curr_length(vec_entry(alpha, r+1) );
                for(j=0;j<j_max;j++)
                        {
                        alpha2 = vec_entry(alpha, r+1);
			h2 = thue_conv_real_to_real(R_ord, dyn_arr_element(alpha2, j), R);
	       		h1 = real_mult(R, q, h2);
		        if (thue_print_level(th) >= 4)
                                {
				printf("q * delta2 = ");real_write(R, h1, 20);puts("");
                                }
	                real_delete(&h2);
	                test1 = real_to_next_int(R, h1);
	                real_delete(&h1);
                        h1 = dist_min;
                        dist_min = real_min(R, dist_min, test1);
                        real_delete(&h1);
	                if (real_compare(R, test1, test) == -1)         /* test1 < test */
				{
				appr1 = FALSE;
				break;
				}
                        }
                real_delete(&test1);
                real_delete(&q);
                if (!appr1)
                        {
                        appr = FALSE;
                        break;
                        }
	        else
                        { 
			h1 = thue_conv_real_to_real(R_ord, dyn_arr_element(log_delta_r, i), R);
			c44 = thue_conv_real_to_real(R_thue, c4, R);
			c55 = thue_conv_real_to_real(R_thue, c5, R);          
			h2 = thue_bd_B1(th, R, Q1, Q2, Q3, c44, c55, h1, q_max, dist_min);
			real_delete(&c44);
			real_delete(&c55);       
			real_delete(&h1);
                        h1 = B1;
                        B1 = real_max(R, h2, B1);
                        real_delete(&h1);
                        real_delete(&h2);
                        }
		}
	if (appr)
		{
		h2 = conv_int_to_real(R, 1);
		h1 = thue_conv_real_to_real(R_thue, thue_B1(th), R);
		B11 = real_subtract(R, h1, h2);
		real_delete(&h1);
		real_delete(&h2);
		if (real_compare(R, B1, B11) == -1)
			{
		        if (thue_print_level(th) >= 3)
                                {
				printf("neues B1 gefunden : \n");
				real_write(R, B1, 20); puts("");
                                }
			real_delete(&thue_B1(th));
                        h1 = thue_conv_real_to_real(R, B1, R_thue);
			thue_B1(th) = conv_int_to_real(R_thue, conv_real_to_int_ceil(R_thue, h1));
			real_delete(&h1);
			}
		else
			{
			if (thue_print_level(th) >= 3)
				printf("Keine weitere Verbesserung von B1...\n");
			appr = FALSE;
			}
		real_delete(&B1);
		real_delete(&B11);
		} 
	real_delete(&test);
	real_delete(&eps);
	real_delete(&Q2);
	real_delete(&Q3);

	return appr;
}


