#include "kant.h" 
#include "rel_lattice.h"
#include "anf_rel_sort.h"

            
extern t_real fincke_func ();


t_logical 
rel_order_lat_norm_equation_abs WITH_11_ARGS (
	order,         		ord,
        order, 	       		sub_ord,
        order, 	       		rel_ord,
	vector,			rel_con,
        vector,        		K,
        vector*,       		G,
        anf_rel_sort,  		sort,
        dyn_arr_handle *,       sol_list, 
	t_logical,		find_all,
	anf_elt,		norm_elt,
	t_logical,		abs_value
)
/*******************************************************************************
 
Description:
 
	This function search a solution of a relative norm equation.
        The normal enumeration "lat_enum.c" is used.

 
Calling sequence:
 
 	ok= rel_order_lat_norm_equation(ord, sub_ord, rel_ord, rel_con, K, G, sort, 
	                               &sol_list, find_all, norm_elt, abs_value);


        order  	          ord      = t_handle of an order 
        order  	          sub_ord  = t_handle of an sub order of ord
        order  	          rel_ord  = t_handle of an the order from the relative basis over Z
        vector		  rel_con  = t_handle of the conjugated relative basis
        vector	 	  K        = the values of the relative norm equations
				     (t_reals)
        vector	 	  G        = the values of the relative gammas (t_reals)
        anf_rel_sort	  sort     = the sorting of the conjugetes over sub_ord
        dyn_arr_handle 	  sol_list = one solution if one found
			             (vector of alg. numbers in the sub order)
	integer_small     find_all = 0, find one solution
				     1, find all solutions
	t_logical	  log	   = 1, if there is a solution
                                     0, if there is no solution
	anf_elt           norm_elt = the norm in the subfield
	t_logical	  abs_value= 1, if solution with exact the rel. norm of norm_elt
                                     0, if solution with the absolute value of the
                                           rel. norm of norm_elt

 
History:
 
	92-06-23 AJ    written
 
*******************************************************************************/
{ 

       	block_declarations;         

        t_handle        R, Z, C;

        vector	      all_ceils;    /* vector of the relative anf_ceilings */
	vector	      lambdas;      /* vector of the t_real lambdas */ 
	vector	      ubounds;      /* vector of the upper bounds of r_i^(j) (integer_samll) */ 
				    /* each entry of ubounds is a vector with the bounds     */
				    /* ober the conjugated field                             */
	vector	      lbounds;      /* vector of the lower bounds of r_i^(j) (integer_samll) */ 
				    /* each entry of ubounds is a vector with the bounds     */
				    /* ober the conjugated field                             */

                     
        rel_lattice  		rel_lat;
        rel_lat_enum_env	rel_env;
        rel_lat_elt  		rel_lat_vec;
        vector	      		norms;         /* vector of the t_real relative norms */ 
        vector	      		t2_bounds;     /* vector of the t_real t2 bounds      */ 

        dyn_arr_handle          sol_list_abs; 
    
        t_real        start, step, temp1, temp2, temp3, temp4, param1, param2, t2_bnd;
	t_real	      real_m, loceps, zero, two, sq2, minh;
	t_comp	      ctemp1, ctemp2, ctemp3, ctemp4, ctemp5, norm_elt_c;
	anf_elt	      rel_elt, elt_h1, elt_h2, elt_h3, alpha;
        integer_small n, m, nm, i, j, l, k, sub_r1, sub_r2, sub_r1r2, modi, sj, tj, ind, r1,r2, ih1;
	integer_big   abs_norm, abs_den, index;
        t_logical     ok, test, sol_found, erg, unit_tst;                  

        matrix        rel_abs_basis, rel_abs_basis_weight; 
                      /* all (and weighted) conjugates of the relative basis  */

        matrix        lll_trans, lll_trans_comp, lll_trans_int, lll_result, mat_h1 ; 
                      /* the LLL-Transf. of the weighted conjugates of the relative basis  */
                                   
                 
        integer_small ceil_cnt, lat_vec_cnt, right_norm_cnt;

	lattice		lat;
	lat_enum_env	env;
        lat_elt         lat_vec;


                                                     

/*** Initialisation  **********************************************************/
                                            
	ceil_cnt= 0;
	lat_vec_cnt= 0;
        right_norm_cnt= 0;

        Z= m_z_str_incref(structure_z);
	R= order_reals (ord);
	C = comp_create(real_dec_prec(R));
  	nm= order_abs_degree (ord);
  	r1= order_r1(ord);
  	r2= order_r2(ord);
  	n= order_abs_degree (sub_ord);
  	sub_r1= order_r1(sub_ord);
  	sub_r2= order_r2(sub_ord);
	sub_r1r2= sub_r1 + sub_r2;
  	m= nm/n;  
	real_m= conv_int_to_real(R, m);
	zero= conv_int_to_real(R, 0);
	two=  conv_int_to_real(R, 2);
        sq2= real_sqrt(R, two);
        loceps= real_make(R, 10, -real_dec_prec(R)+5 );  
   

	norm_elt_c= anf_elt_ith_con(sub_ord, norm_elt,1);

	t2_bounds= vec_new(sub_r1r2);
	all_ceils= vec_new(sub_r1r2);

	*sol_list= dyn_arr_alloc(0);
        dyn_arr_curr_length(*sol_list)= 0;    

	if (anf_print_level >=5 )
	 {
          printf("\n\n\nOutput of alsolute basis:\n\n");
	  mat_real_write_aj(R, order_basis_real(rel_ord), 15);
	  printf("\n\n");     
	 }
 



/*** Determination of the zeroes lambda  **************************************/
           
        if (*G== MEM_NH)
         {
          rel_order_fincke_find_gamma_opt(sub_ord, K, G, &lambdas, sort);           
         }
        else
          {
	   /* Start values for the regula falsi */

   	   lambdas= vec_new(sub_r1r2);

	   start  = conv_double_to_real (R, 1.1);  

	   /* Length of the steps to find the zero for the regula falsi */

   	   step   = conv_double_to_real (R,2.0);

	   /* The regula falsi */   


  	   for (j=1; j<=sub_r1r2; j++)
	    {                       
	     param1= real_divide(R, vec_entry(*G,j), vec_entry(K,j));
	     param2= conv_double_to_real (R, (double) (2.0/(1.0*m)) );

	     if (anf_print_level>=6)
	      {
	       printf("\nVALUES: \n");
               printf ("start : "); real_write (R,start,10); puts ("");
               printf ("step  : "); real_write (R,step,10);  puts ("");
               printf ("p1    : "); real_write (R,param1,10);    puts ("");
               printf ("p2    : "); real_write (R,param2,10);    puts ("");
	      } 
	
             ok = regula_falsi_zero_aj (R,start,step,&fincke_func,
	   	                     param1,param2,&vec_entry(lambdas,j) ); 

	     real_delete(&param1);
	     real_delete(&param2);

	    }

           real_delete(&start);
           real_delete(&step);
          }


/*** Determination of the bound for r  *****************************************/

               
        rel_order_fincke_rbounds_calc(rel_ord, sub_ord, K, sort, lambdas,
                                      &ubounds, &lbounds);
    
               
/*****  t2_bounds  **************************************/
                               
        t2_bnd= real_incref(zero);
	for (j=1; j<=sub_r1r2; j++)   
	 {
	  temp2= real_add(R, vec_entry(K,j), vec_entry(*G,j));
	  temp3= real_root(R, temp2, m);
	  temp4= real_mult(R, temp3, temp3);
	  vec_entry(t2_bounds,j)= real_mult(R, temp4, real_m);
	  real_delete(&temp2);
	  real_delete(&temp3);
	  real_delete(&temp4);
  
          temp1= t2_bnd;
          t2_bnd= real_add(R, temp1, vec_entry(t2_bounds,j));
	  real_delete(&temp1);
          if (j>sub_r1)
           {
            temp1= t2_bnd;
            t2_bnd= real_add(R, temp1, vec_entry(t2_bounds,j));
  	    real_delete(&temp1);
           }
	 }                                                    


/*****  output     **************************************/

        if (anf_print_level >=1)
         {      
	  printf("\nChoice of the Lambda's: ");
	  for (j=1; j<= sub_r1r2; j++)
           real_write_aj(R, vec_entry(lambdas,j), 15);
 
	  printf("\nChoice of the Gamma's:  ");
	  for (j=1; j<= sub_r1r2; j++)
           real_write_aj(R, vec_entry(*G,j), 15);

	  printf("\n\nBounds for the different ceilings: \n\n");
	  for (j=1; j<= sub_r1r2; j++)
	   { 
	     for (i=1; i<= m; i++)
              {
               printf("  (%d,", vec_entry(vec_entry(lbounds,j),i) );
               printf("%d)   ", vec_entry(vec_entry(ubounds,j),i) );  
              }

	     if (j<= sub_r1)
	      {
               sj= anf_rel_sort_real_zeroes_elt(sort,j);
               tj= anf_rel_sort_comp_zeroes_elt(sort,j);
	       printf("    with the relative signature: (%d, %d)\n", sj, tj);
	      }
	     else
	       printf("    with no relative signature\n");
            }
          printf("\n\n");
         }
               


/*** Loop with all possible r's ************************************************/
                                              
	/* Initialisation of the r vectors */       

	for (i=1; i<=sub_r1; i++)
	 {                 
	  vec_entry(all_ceils,i)= vec_new(m);
	  modi= 1;                                    
          sj= anf_rel_sort_real_zeroes_elt(sort,i);
          tj= anf_rel_sort_comp_zeroes_elt(sort,i);
          test= rel_anf_ceiling_fincke_next_sub(vec_entry(ubounds,i), 
                                              vec_entry(lbounds,i), 
					      &vec_entry(all_ceils,i), 
			                      sj, tj, &modi); 
	  if (!test)  break;
	 }

        if (test)
         {
	  for (i=sub_r1+1; i<=sub_r1r2; i++)
	   {                 
	    vec_entry(all_ceils,i)= vec_new(m);
	    modi= 1;                                    
            sj= -1;
            tj= -1;
            test= rel_anf_ceiling_fincke_next_sub(vec_entry(ubounds,i), 
                                              vec_entry(lbounds,i), 
					      &vec_entry(all_ceils,i), 
			                      sj, tj, &modi); 
	    if (!test)  break;
	   }
         }
                                            


	/* Loop with all  r vectors */       

	modi= 0;
	sol_found= FALSE;
        while( test ) 
         {  
	  ceil_cnt++;

/****

      printf("\nceil_cnt: %d \n", ceil_cnt);
      if (ceil_cnt==2)
        {
         puts ("Statistics :");
         printf (" No of ellip. considered             : %d\n", ceil_cnt);
         printf (" No of numbers found in these ellip. : %d\n", lat_vec_cnt);
         printf (" No of numbers found with right norm : %d\n", right_norm_cnt);
         if ((find_all) && (*sol_list != MEM_NH))
         printf (" No of non associated numbers        : %d\n",dyn_arr_curr_length (*sol_list));
         printf("\n \n");
         exit(1);
        }

****/
  	  /* Output of r */       

	  if (anf_print_level>=1)
	   {
            printf("\n\nActual ceilings:  ");
	    for (j=1; j<=sub_r1r2; j++)
	     {    
              printf("(");
	      for (i=1; i<=m; i++)       
               {
	        printf(" %d  ", vec_entry(vec_entry(all_ceils,j),i));
               }
  	      printf(")");
  	      if (j<sub_r1r2)  printf(",   ");
	     }
	    printf("\n \n");     
	   }


  	  /* Determination of the quadratic forms */       
        
	  rel_abs_basis_weight= mat_new(nm,nm);

	  for (j=1; j<=sub_r1r2; j++)
          {     
           sj= anf_rel_sort_real_zeroes_elt(sort,j);
           tj= anf_rel_sort_comp_zeroes_elt(sort,j);
           if (j<= sub_r1) 
             ih1= sj+tj;
            else
             ih1= m;  
	   for (i=1; i<=ih1; i++)
	    {
             ind= anf_rel_sort_ordering_elt(sort,j,i);
             if (ind>r1+r2)
               ind= ind-r2;

             if ( ind <= r1)
               {
  	        temp1= real_power(R, vec_entry(lambdas,j), 
	                          vec_entry(vec_entry(all_ceils,j),i) );
                temp4 = real_sqrt (R, temp1);
     	        for (l=1; l<=nm; l++) 
                  mat_elt(rel_abs_basis_weight,ind,l)= 
                             real_mult(R,temp4, mat_elt(order_basis_real(rel_ord),ind,l) );

	        real_delete(&temp1);
	        real_delete(&temp4);
               }
              else
               {
                temp1= real_power(R, vec_entry(lambdas,j), 
	                        vec_entry(vec_entry(all_ceils,j),i) );
                if (j<= sub_r1)
                  temp2= real_power(R, vec_entry(lambdas,j), 
	                        vec_entry(vec_entry(all_ceils,j),i+tj) );
                 else
                  temp2= real_power(R, vec_entry(lambdas,j), 
	                        vec_entry(vec_entry(all_ceils,j),i) );


                temp3 = real_add (R, temp1, temp2);
                real_delete (&temp1);
                real_delete (&temp2);

                temp1= real_divide(R, temp3, two);
                temp4 = real_sqrt (R,temp1);
               
     	        for (l=1; l<=nm; l++) 
	         {                  
                  mat_elt(rel_abs_basis_weight,ind,l)= 
                          real_mult(R,temp4, mat_elt(order_basis_real(rel_ord),ind,l) );
                  mat_elt(rel_abs_basis_weight,ind+r2,l)= 
                          real_mult(R,temp4, mat_elt(order_basis_real(rel_ord),ind+r2,l) );
       	         }

                real_delete (&temp1);
                real_delete (&temp3);
                real_delete (&temp4);

               } /*  if (ind<= r1)  */

	    } /* for (i=1; i<=ih1; i++) */

	  }  /* for (j=1; j<=sub_r1r2; j++) */

          
	  if (anf_print_level >=3 )
	   {
            printf("\n\n\nOutput of alsolute weighted basis:\n\n");
	    mat_real_write_aj(R, rel_abs_basis_weight, 15);
	    printf("\n\n");     
	   }
 
           
 	  /* LLL reduction of the quadratic forms */       

          lll_trans= 0;
          lll_result= 0;
          lll_real_d_reduce(R, rel_abs_basis_weight,0.75, &lll_result, &lll_trans);

          lll_trans_int= mat_real_to_mat_z(R, lll_trans);
             
	  if (anf_print_level >=3 )
	   {
            printf("\n\n\nLLL-transformation:\n\n");
	    mat_real_write_aj(R, lll_trans, 15);
	    printf("\n\n");     

            printf("\n\n\nOutput of alsolute lll-red. weighted basis:\n\n");
	    mat_real_write_aj(R, lll_result, 15);
	    printf("\n\n");     
	   }
                   
          
          lat= lat_create();      
          lat_rank(lat)= nm;
          lat_basis_ring(lat)= ring_incref(R);
          lat_basis(lat)= lll_result;
          lat_chol_calc(lat);
          env= lat_enum_create(lat);
          lat_enum_ubound(env)= real_incref(t2_bnd);
          lat_enum_status_set_new   (env);
          lat_enum_request_set_next (env);
          lat_enum_strategy_set_up  (env);          


	  if (anf_print_level >=3 )
	   {
            printf("\nCholesky-matrix:\n");
	    mat_real_write_aj(R, lat_chol(lat), 15); 
	    printf("\n\n\n");
	   }


	  if (anf_print_level > 2)
	   {
	    printf("\n\nEnumeration loop:\n\n");
	    printf("\n\nUpper bound for the conjugated T2-norm:  \n\n");
	    real_write_aj(R, lat_enum_ubound(env) , 15);
	    printf("\n \n");
	   }


  	  /* Enumeration loop */  

	  while(lat_enum(lat, env))
	   {                             
	    lat_vec_cnt++;

            lat_vec  = lat_elt_move (lat,lat_enum_act_coefs(env),lll_trans_int);
            rel_elt  = lat_elt_to_anf_elt (lat, lat_vec, rel_ord);
            lat_elt_delete(lat,&lat_vec);

	    if (anf_print_level >=3)
	     {  
	      printf("\nlat_enum_counter= \t %d\n", lat_enum_counter(env));
     	      printf(      "rel_elt with LLL-re-transformation:   \t ");
     	      anf_elt_write(rel_ord, rel_elt);

     	      printf("\nlength: ");  
              real_write_aj(R,lat_enum_act_length(env), 15);
              printf("\n \n");  
             }

	    norms= anf_elt_rel_norms(rel_ord, sub_ord, rel_elt, sort, abs_value); 
                 
            
            if (anf_print_level>=99)
             {
	      /*  constructing the norm element in conjugated form */
 
              anf_con_alloc(alpha, n);
 
	      for (j=1; j<= sub_r1; j++)
	        anf_con(alpha, j) = comp_re(C, vec_entry(norms,j));

	      for (j=sub_r1+1; j<= sub_r1+sub_r2; j++)
               {                                  
                temp1= comp_re(C, vec_entry(norms,j));
                temp2= comp_im(C, vec_entry(norms,j));
	        anf_con(alpha, j) = real_mult(R, temp1, sq2);
	        anf_con(alpha, j+sub_r2) = real_mult(R, temp2, sq2);
                real_delete(&temp1);
                real_delete(&temp2);
               }

              anf_elt_embed_aj(sub_ord, alpha, 0, sub_ord, &elt_h3);
                          
              if (elt_h3!= MEM_NH)
               {
                printf("\nRelative norm element:  ");
                anf_elt_write(sub_ord, elt_h3);
                printf("\n \n");
     
	        anf_elt_delete(sub_ord, &elt_h3);
               }

	      anf_elt_delete(sub_ord, &alpha);
             }
            


	    if (abs_value==FALSE)
              {
 	       if (anf_print_level >=3)
	        {
	         printf("norm:   ");
	         temp1= conv_int_to_real(R, 1);
     	         for (l=1;l<=sub_r1;l++) 
     	          {                                                            
	           temp2= temp1;
		   temp1= real_mult(R,temp2,vec_entry(norms,l));
	           real_delete(&temp2);
     	 	   real_write_aj(R, vec_entry(norms,l), 15);
		   if (l!=sub_r1r2)  printf(" * ");
     	          }                         
	         for (l=sub_r1+1;l<=sub_r1r2;l++) 
     	          {                                                            
	           temp2= temp1;  
	           temp3= real_power(R, vec_entry(norms,l), 2);
		   temp1= real_mult(R,temp2,temp3);
	           real_delete(&temp2);
	           real_delete(&temp3);
     		   real_write_aj(R, vec_entry(norms,l), 15);
		   printf("^2");
		   if (l!=sub_r1r2)  printf("  * ");
     	          }                          

     	         printf(" =  "); 
      	         real_write_aj(R, temp1, 15);
	         elt_h1= anf_elt_con(rel_ord, rel_elt);
	         anf_norm(rel_ord, elt_h1, &abs_norm, &abs_den);
	         anf_elt_delete(rel_ord, &elt_h1);
	         printf("   (absolute= ");
	         integer_write(abs_norm);
	         printf(")\n\n");
                 integer_delref(abs_norm);
                 integer_delref(abs_den);
	         real_delete(&temp1);   
	        }
                
	         erg= TRUE;
     	         for (j=1;j<=sub_r1r2;j++) 
                 {
     	          if (real_equality_eps(R,vec_entry(norms,j),vec_entry(K,j),loceps)==0)
	           {
	            erg= FALSE;
	            break;
	           }
                 }
             
	         vec_delete(R, &norms);
              }
	     else
              {
 	       if (anf_print_level >=3)
	        {
	         printf("norm:   ");
	         ctemp1= conv_int_to_comp(C, 1);
     	         for (l=1;l<=sub_r1;l++) 
     	          {                                                            
	           ctemp2= ctemp1;
		   ctemp1= comp_mult(C,ctemp2,vec_entry(norms,l));
	           comp_elt_delete(C, &ctemp2);
     	 	   comp_write_aj(C, vec_entry(norms,l), 15);
		   if (l!=sub_r1r2)  printf("\n * ");
     	          }                         
	         for (l=sub_r1+1;l<=sub_r1r2;l++) 
     	          {                                                            
	           ctemp2= ctemp1;  
	           ctemp3= comp_incref(vec_entry(norms,l));
		   ctemp4= comp_conjugate(C, ctemp3);
		   printf("(");
     		   comp_write_aj(C, ctemp3, 15);
	           printf(" * ");
     		   comp_write_aj(C, ctemp4, 15);
		   printf(")");
		   ctemp5= comp_mult(C, ctemp3, ctemp4);
		   ctemp1= comp_mult(C,ctemp2,ctemp5);
	           comp_elt_delete(C, &ctemp2);
	           comp_elt_delete(C, &ctemp3);
	           comp_elt_delete(C, &ctemp4);
	           comp_elt_delete(C, &ctemp5);
		   if (l!=sub_r1r2)  printf("\n       * ");
     	          }                          

     	         printf(" =  "); 
      	         comp_write_aj(C, ctemp1, 15);
	         elt_h1= anf_elt_con(rel_ord, rel_elt);
	         anf_norm(rel_ord, elt_h1, &abs_norm, &abs_den);
	         printf("   (absolute= ");
	         integer_write(abs_norm);
	         printf(")\n\n");
                 integer_delref(abs_norm);
                 integer_delref(abs_den);
	         comp_elt_delete(C, &ctemp1);   
	         anf_elt_delete(rel_ord, &elt_h1);
	        }
                
	         erg= TRUE;
     	         if (comp_equality_eps(C, R, vec_entry(norms,1), norm_elt_c,loceps)==0)
	           erg= FALSE;
	         vec_delete(C, &norms);
	      }
    
	    if (erg)
	     {                    
              right_norm_cnt++;
	      unit_tst= FALSE;
              for (i=1; i<=dyn_arr_curr_length(*sol_list); i++)
	       {              
                elt_h1= anf_div(rel_ord, dyn_arr_element(*sol_list,i-1), rel_elt);
	        unit_tst= anf_elt_is_unit(rel_ord, elt_h1);
	        anf_elt_delete(rel_ord, &elt_h1);
	        if (unit_tst) break;
	       }
             
	      if (!unit_tst)
	       {
                dyn_arr_assure_space(*sol_list, dyn_arr_curr_length(*sol_list)+1,1);
                dyn_arr_curr_length(*sol_list)++; 
	        dyn_arr_element(*sol_list,dyn_arr_curr_length(*sol_list)-1)= 
	                                                          anf_elt_incref(rel_elt);


	        sol_found= TRUE;
	        if (find_all==0 )
	         {
	          anf_elt_delete(rel_ord, &rel_elt);
   	          mat_delref(Z, &lll_trans_int);
   	          mat_delref(R, &lll_trans);
   	          mat_delref(R, &rel_abs_basis_weight);

	          lat_enum_delete(lat, &env);
	          lat_delete(&lat);
	          goto end;
	         }
               }
	     } 

	    anf_elt_delete(rel_ord, &rel_elt);

	   }                     

   	  mat_delref(Z, &lll_trans_int);
   	  mat_delref(R, &lll_trans);
   	  mat_delref(R, &rel_abs_basis_weight);

	  lat_enum_delete(lat, &env);
	  lat_delete(&lat);


  	  /* New  r */       

	  for (i=1; i<=sub_r1r2; i++)
	   {                   
 	    if (i<=sub_r1)
	     {
              sj= anf_rel_sort_real_zeroes_elt(sort,i);
              tj= anf_rel_sort_comp_zeroes_elt(sort,i);
	     }
	    else
	     {
	      sj= -1;
	      tj= -1;
	     }
            test= rel_anf_ceiling_fincke_next_sub(vec_entry(ubounds,i), 
                                                  vec_entry(lbounds,i), 
	  			 	          &vec_entry(all_ceils,i), 
			                          sj, tj, &modi); 
	    if (test)  break;
	   }            
	   
	  if (!test) break;  /* no new r found, END */

	 } /* end while: test */




/*** End   *********************************************************************/


end:   for (j=1; j<=sub_r1r2; j++)
	 if (vec_entry(all_ceils,j)!=MEM_NH)
	   vec_delete(Z, &vec_entry(all_ceils,j) );
       vec_delete(Z, &all_ceils );

       for (j=1; j<=sub_r1r2; j++)
	 vec_delete(Z, &vec_entry(lbounds,j) );
       vec_delete(Z, &lbounds );

       for (j=1; j<=sub_r1r2; j++)
	 vec_delete(Z, &vec_entry(ubounds,j) );
       vec_delete(Z, &ubounds );                 
                      
       vec_delete(R, &lambdas );
       vec_delete(R, &t2_bounds);

       real_delete(&real_m);
       real_delete(&loceps);
       real_delete(&zero);
       real_delete(&two);
       real_delete(&sq2);
       real_delete(&t2_bnd);

       comp_elt_delete(C, &norm_elt_c);

       ring_delete(&Z);
       ring_delete(&C);  

       if (anf_print_level >=1)
        {
         puts ("Statistics :");
         printf (" No of ellip. considered             : %d\n", ceil_cnt);
         printf (" No of numbers found in these ellip. : %d\n", lat_vec_cnt);
         printf (" No of numbers found with right norm : %d\n", right_norm_cnt);
         if ((find_all) && (*sol_list != MEM_NH))
         printf (" No of non associated numbers        : %d\n",dyn_arr_curr_length (*sol_list));
         printf("\n \n");
        }


       if (sol_found)  return 1;
	
       return 0;
}


