/******************************************************************************
  rel_rel_lat_enum.c                                                           
******************************************************************************/
#include "kant.h"
#include "rel_lattice.h"



t_logical
rel_lat_enum WITH_2_ARGS (
	rel_lattice,		rel_lat,
	rel_lat_enum_env,	rel_env   
)
/*******************************************************************************
 
Description:
 

 
Calling sequence:
 

 
History:

	92-03-13 AJ    	written
 
*******************************************************************************/
{                           
	block_declarations;

	integer_small	i,j, l, level, number_con, rank, r1, r2, r1r2;

	lattice		level_lat;
	lat_enum_env	level_env;

	order		sub_order;
	t_handle          R, C, Z, h_ring;

	t_real		zero, ttemp1, ttemp2, ttemp3, ttemp4, ttemp5, sq2, loceps;
	t_comp		czero,  ctemp1, ctemp2, ctemp3, ctemp4;    

	anf_elt		anftemp1, elt_sh1, elt_sh2;

	matrix		mtemp1, mtemp2, sub_basis, sub_gram;
	vector		vec_h1, vec_h2;
               
/***    Initialisation  ******************************************************/
                      

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum: start \n");

        sub_order= rel_lat_coef_ord(rel_lat);
        r1= order_r1(rel_lat_coef_ord(rel_lat));
        r2= order_r2(rel_lat_coef_ord(rel_lat));
	r1r2= r1+r2;

	sq2=  order_sqrt_2(rel_lat_coef_ord(rel_lat));

	R= comp_real_field(rel_lat_chol_ring(rel_lat));
	C= rel_lat_chol_ring(rel_lat);
        Z= m_z_str_incref(structure_z);

        zero= conv_int_to_real(R,0);
	czero= comp_make(C, zero, zero);
        loceps= real_make(R, 10, -real_dec_prec(R)+2 );  

	number_con= rel_lat_number_con(rel_lat);
	rank= rel_lat_rank(rel_lat);

/***    Is lattice status not new?   *****************************************/

	if (anf_print_level >= 5)
	  printf("\nrel_lat_enum: status not new \n\n\n");

	if (!rel_lat_enum_status_is_new(rel_env))
	 {
	  level = 1;		
	  goto s3;
	 }

/***    Is lattice status new: Step 1: Initialisation   **********************/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: start initialisation\n");

	if (rel_lat_enum_ubounds(rel_env)==MEM_NH ) 
          error_internal("rel_lat_enum: There are no upper bounds.");

	rel_lat_enum_counter(rel_env) = 0;

	level = rank;  



    /***  Flags: 1. Deletion, 2. Initialisation      ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: flags init.\n");

	if (rel_lat_enum_level_flag(rel_env)!= MEM_NH)
	  vec_delete(Z, &rel_lat_enum_level_flag(rel_env));

	if (rel_lat_enum_termination_flag(rel_env)!= MEM_NH)
	  vec_delete(Z, &rel_lat_enum_termination_flag(rel_env));

	rel_lat_enum_level_flag(rel_env)= vec_new(rank);
	rel_lat_enum_termination_flag(rel_env)= vec_new(rank+1);
                                                        
	rel_lat_enum_termination_flag_level(rel_env, rank+1)= 0;


    /***  act_coefs(_con): 1. Deletion, 2. Initialisation  ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: act_coefs init.\n");

	if (rel_lat_enum_act_coefs(rel_env)!= MEM_NH)
	      rel_lat_elt_delete(rel_lat,&rel_lat_enum_act_coefs(rel_env));

        rel_lat_elt_alloc(rel_lat_enum_act_coefs(rel_env), rank);


        if (rel_lat_enum_act_coefs_con(rel_env)!= MEM_NH)
	  rel_lat_elt_delete(rel_lat,&rel_lat_enum_act_coefs_con(rel_env));

        rel_lat_elt_alloc(rel_lat_enum_act_coefs_con(rel_env), rank);



    /***  act_lengths(_con): 1. Deletion, 2. Initialisation  ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: act_lengths init.\n");

	if (rel_lat_enum_act_lengths(rel_env)!= MEM_NH)
	 {
	  for(i=1;i<= r1r2;i++)     
	   {                                                       
	    if (rel_lat_enum_act_lengths_con(rel_env,i)!= MEM_NH)
	      real_delete(&rel_lat_enum_act_lengths_con(rel_env,i));
            rel_lat_enum_act_lengths_con(rel_env,i)= 0;
	   }
	  vec_delete(Z,&rel_lat_enum_act_lengths(rel_env));
	 }

	rel_lat_enum_act_lengths(rel_env)= vec_new(r1r2);


    /***  tmp_bounds: 1. Deletion, 2. Initialisation  ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: tmp_bounds init.\n");

	if (rel_lat_enum_tmp_bounds(rel_env)!= MEM_NH)
	 {
	  for(j=1;j<= r1r2;j++)     
	   {                                                       
	    if (rel_lat_enum_tmp_bounds_con(rel_env,j)!= MEM_NH)
	       vec_delete(R, &rel_lat_enum_tmp_bounds_con(rel_env,j));
            rel_lat_enum_tmp_bounds_con(rel_env,j)= 0;
	   }
	  vec_delete(Z,&rel_lat_enum_tmp_bounds(rel_env));
	 }         

        rel_lat_enum_tmp_bounds(rel_env)= vec_new(r1r2);

	for(j=1;j<= r1r2;j++)  
	 {   
          rel_lat_enum_tmp_bounds_con(rel_env,j)= vec_new(rank);
          rel_lat_enum_tmp_bounds_con_level(rel_env,j,rank) = 
                            real_incref(rel_lat_enum_ubounds_con(rel_env,j));
  	  for(i=1;i<= rank-1;i++)  
            rel_lat_enum_tmp_bounds_con_level(rel_env,j,i) = real_incref(zero);
	 }



    /***  part_sums: 1. Deletion, 2. Initialisation  ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: part_sums init.\n");

	if (rel_lat_enum_part_sums(rel_env)!= MEM_NH)
	 {
	  for(j=1;j<= r1r2;j++)     
	   {
	    if (rel_lat_enum_part_sums_con(rel_env,j)!= MEM_NH)
	       vec_delete(C, &rel_lat_enum_part_sums_con(rel_env,j));
	    rel_lat_enum_part_sums_con(rel_env,j)= 0;
	   }
	  vec_delete(Z,&rel_lat_enum_part_sums(rel_env));
	 }                  
       
	rel_lat_enum_part_sums(rel_env)= vec_new(r1r2);

	for(j=1;j<= r1r2;j++)  
	 {   
          rel_lat_enum_part_sums_con(rel_env,j)= vec_new(rank);
  	  for(i=1;i<= rank;i++)  
            rel_lat_enum_part_sums_con_level(rel_env,j,i) = comp_incref(czero);
	 }



    /***  coefs_lat, coefs_env: 1. Deletion, 2. Initialisation  ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: coefs_lat, coefs_env init.\n");
                                                         
	if (rel_lat_enum_coefs_lat(rel_env)== MEM_NH)
	    rel_lat_enum_coefs_lat(rel_env)= vec_new(rank);

	if (rel_lat_enum_coefs_env(rel_env)== MEM_NH)
	    rel_lat_enum_coefs_env(rel_env)= vec_new(rank);


    /***  Initialisation of the different quadratic forms     ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: rel_lat_chol init.\n");

        rel_lat_chol_calc(rel_lat);

	if ( order_basis_real(rel_lat_coef_ord(rel_lat))==MEM_NH ) 
          error_internal("rel_lat_enum: There are no basis of coeff. order.");


    /***  The Gram-matrix of the suborder                 ***/
    
        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: sub_gram init.\n");

	sub_basis= order_basis_real(rel_lat_coef_ord(rel_lat));	

        rel_lat_coef_ord_gram(rel_lat)= mat_ring_gram(R,sub_basis);

	sub_gram= rel_lat_coef_ord_gram(rel_lat);


    /***  counter initialisation                         ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s1: counter init.\n");

	rel_lat_enum_counter(rel_env)= 0;

	rel_lat_enum_status_set_busy(rel_env);



/***    Calculation of all bounds for the enumeration on level i   ***********/

	
s2:	/***  The upper bounds for the quadr. forms in the suborder   ***/



  	/***  The new lattice in the suborder                       ***/

	sub_basis= order_basis_real(rel_lat_coef_ord(rel_lat));	
	sub_gram= rel_lat_coef_ord_gram(rel_lat);

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s2: level_lat, level_env init. (level= %d)\n", level);

	if (rel_lat_enum_coefs_env_level(rel_env,level)!= MEM_NH)
	 {
	  lat_enum_delete(rel_lat_enum_coefs_lat_level(rel_env,level),
	                  &rel_lat_enum_coefs_env_level(rel_env,level));
	 }


	if (rel_lat_enum_coefs_lat_level(rel_env,level)!= MEM_NH)
	  lat_delete(&rel_lat_enum_coefs_lat_level(rel_env,level));

	rel_lat_enum_coefs_lat_level(rel_env,level)= lat_create();                                 

	level_lat= rel_lat_enum_coefs_lat_level(rel_env,level);
               
     	if (rel_lat_enum_termination_flag_level(rel_env,level+1)==0)
	  lat_rank(level_lat)= number_con;
	 else
	  lat_rank(level_lat)= number_con+1;

  	rel_lat_enum_coefs_env_level(rel_env,level)= 
	         lat_enum_create(level_lat);                                 
                  
	level_env= rel_lat_enum_coefs_env_level(rel_env,level);

	


        /***  The new upper bounds for the enumeration       ***/

        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s2: ubound for level_env init. (level= %d)\n", level);

        lat_enum_ubound(level_env)= real_incref(zero);    

	
	for(j=1;j<= r1;j++)     
	 {                
    	  ttemp1= lat_enum_ubound(level_env);
	  ttemp3= comp_re(C, mat_elt(rel_lat_chol_con(rel_lat,j), level,level) );
	  ttemp2= real_divide(R,rel_lat_enum_tmp_bounds_con_level(rel_env,j,level),ttemp3);

	  lat_enum_ubound(level_env)= real_add(R, lat_enum_ubound(level_env), ttemp2);
	                              

          if (anf_print_level >= 5)
	   {
	    printf("\n\nlat_enum_ubound (con= %d, level= %d):  \n", j, level); 
	    real_write(R,ttemp2,20); 
	    printf(" =  ");
	    real_write(R,rel_lat_enum_tmp_bounds_con_level(rel_env,j,level),20); 
	    printf(" /  ");
	    real_write(R,ttemp3,20); 
	    printf("\n \n");
	   }

	  real_delete(&ttemp1);
	  real_delete(&ttemp3);
	  real_delete(&ttemp2);
	 }            

	for(j=r1+1;j<= r1r2;j++)     
	 {                
    	  ttemp1= lat_enum_ubound(level_env);
	  ttemp3= comp_re(C, mat_elt(rel_lat_chol_con(rel_lat,j), level,level) );
	  ttemp2= real_divide(R,rel_lat_enum_tmp_bounds_con_level(rel_env,j,level),ttemp3);

	  lat_enum_ubound(level_env)= real_add(R, lat_enum_ubound(level_env), ttemp2);
	  real_delete(&ttemp1);
    	  ttemp1= lat_enum_ubound(level_env);
	  lat_enum_ubound(level_env)= real_add(R, lat_enum_ubound(level_env), ttemp2);
	                              

          if (anf_print_level >= 5)
	   {
	    printf("\n\nlat_enum_ubound (con= %d, level= %d):  \n", j, level); 
	    real_write(R,ttemp2,20); 
	    printf(" =  ");
	    real_write(R,rel_lat_enum_tmp_bounds_con_level(rel_env,j,level),20); 
	    printf(" /  ");
	    real_write(R,ttemp3,20); 
	    printf("\n \n");
	   }

	  real_delete(&ttemp1);
	  real_delete(&ttemp3);
	  real_delete(&ttemp2);
	 }  



	/***  Computation of the extended quadr. form in the suborder   ***/

                                             
        if (anf_print_level >= 5)
	  printf("\nrel_lat_enum, s2: lat_chol for level_env init. (level= %d)\n", level);

	lat_gram(level_lat)= mat_new(lat_rank(level_lat),lat_rank(level_lat));     

	for(i=1;i<= number_con;i++)     
	  for(j=1;j<= number_con;j++)                                  
           {
	    mat_elt(lat_gram(level_lat),i,j)=  real_incref(mat_elt(sub_gram,i,j));
           }
                             
	lat_gram_ring(level_lat)= ring_incref(R);



        if (anf_print_level >= 99)
         {
	   if (lat_rank(level_lat)==number_con)
	    {
	     printf("\nlevel= %d, lat_enum_ubound:   1*", level); 
	     real_write(R,lat_enum_ubound(level_env),20); 
	     printf("\n\n");  

	     lat_chol_calc(level_lat);
             printf("level= %d, Cholesky-matrix:\n\n", level);
             mat_real_write_aj(R, lat_chol(level_lat), 15); 
             printf("\n\n");
	    }              
	   else
	    {
	     printf("\nlevel= %d, lat_enum_ubound:   2*", level); 
	     real_write(R,lat_enum_ubound(level_env),20); 
	     printf("\n\n");
	    }
	 }


	if (lat_rank(level_lat)==number_con+1)
	 {
	  mtemp1= lat_gram(level_lat);

	  vec_h1= vec_new(number_con);

	  for (i=1; i<= r1; i++)
	   {
	    vec_entry(vec_h1,i)=
	           comp_re(C,rel_lat_enum_part_sums_con_level(rel_env,i,level));  
	   }

	  for (i=r1+1; i<= r1r2; i++)
	   {
	    ttemp1= comp_re(C,rel_lat_enum_part_sums_con_level(rel_env,i,level));  
	    vec_entry(vec_h1,i)= real_mult(R, ttemp1, sq2);
	    real_delete(&ttemp1);

	    ttemp1= comp_im(C,rel_lat_enum_part_sums_con_level(rel_env,i,level));  
	    vec_entry(vec_h1,i+r2)= real_mult(R, ttemp1, sq2);
	    real_delete(&ttemp1);
   	   }
                                         
                                        
	  vec_h2= mat_ring_mult(R, vec_h1, sub_basis);	  


	  for (i=1; i<= number_con; i++)
	   {
	    mat_elt(mtemp1,i,number_con+1)= real_incref(vec_entry(vec_h2,i)); 
	    mat_elt(mtemp1,number_con+1, i)= real_incref(vec_entry(vec_h2,i)); 
	   }

	  vec_delete(R, &vec_h1);
	  vec_delete(R, &vec_h2);

	  mat_elt(mtemp1,number_con+1, number_con+1)= real_incref(zero);

	  lat_chol_calc(level_lat);

	  real_delete(&mat_elt(lat_chol(level_lat), number_con+1,number_con+1));
	  mat_elt(lat_chol(level_lat), number_con+1,number_con+1)= 
	                                real_incref(lat_enum_ubound(level_env)); 


	  /*** If enumeration with double precision is used  ********************/
                                                                   

	  dmat_elt(lat_double_chol(level_lat), number_con+1, number_con+1)= 
	                     conv_real_to_double(R, lat_enum_ubound(level_env) );


	  /**********************************************************************/


                            
	  lat_enum_coef_ubound_user(level_env, number_con+1)= 1;
	  lat_enum_coef_lbound_user(level_env, number_con+1)= 1;
	  lat_enum_coef_ubound_user_flag_set(level_env,number_con+1);
	  lat_enum_coef_lbound_user_flag_set(level_env,number_con+1);


	  /* ref_vector= 0: lat_enum enumerates unsymetrical and returns */
	  /* the zero vector as one solution                             */
     
 	  lat_enum_ref_vector(level_env) = dyn_arr_alloc(lat_rank(level_lat));
 	  for(i=1;i<=lat_rank(level_lat);i++)
	    lat_enum_ref_vector_coef(level_env,i) = conv_int_to_real(R,0);
                

    	  ttemp1= lat_enum_ubound(level_env);
	  ttemp2= conv_int_to_real(R, 2);
	  lat_enum_ubound(level_env)= real_mult(R, ttemp1, ttemp2);
          real_delete(&ttemp1);
          real_delete(&ttemp2);


          if (anf_print_level >= 99)
           {
            printf("level= %d, Cholesky-matrix:\n\n", level);
            mat_real_write_aj(R, lat_chol(level_lat), 15); 
            printf("\n\n");
  	   }
                                
	 } /* endif  */ 


	lat_enum_request_set_next(level_env);
	lat_enum_status_is_new(level_env);
  
	rel_lat_enum_level_flag_level(rel_env, level)= 1;


/***    Enumeration of the coefficients on level i  *************************/
                                  

s3:	 if (anf_print_level >= 5)
	   printf("\nrel_lat_enum, s3: enumeration on level i (level= %d)\n", level);

                                                 
	level_lat= rel_lat_enum_coefs_lat_level(rel_env,level);
	level_env= rel_lat_enum_coefs_env_level(rel_env,level);


	if (rel_lat_enum_level_flag_level(rel_env, level)==0) 
	 {
	  level= level+1;
	  level_lat= rel_lat_enum_coefs_lat_level(rel_env,level);
	  level_env= rel_lat_enum_coefs_env_level(rel_env,level);

	  goto s3;
	 }        
           
        if (anf_print_level >= 5)
	 {	
	  printf("\nBefore enumeration:");
  	  printf("\n\nstatus: %d \n", lat_enum_status(level_env) ); 
	  printf("request: %d \n", lat_enum_request(level_env) ); 
	 }


 	rel_lat_enum_level_flag_level(rel_env, level)= 
	                                         lat_enum(level_lat, level_env);

        if (anf_print_level >= 5)
	 {
	  printf("\n\nUpper bound:  \n"); 
	  real_write(R,lat_enum_ubound(level_env),20); 
	  printf("\n \n");
          printf("\n\nCholesky-matrix (level= %d):\n\n", level);
          mat_real_write_aj(R, lat_chol(level_lat), 22); 
          printf("\n\n\n");
	 }

        if (anf_print_level >= 5)
	 {
	  printf("\nrel_lat_enum_level_flag_level= %d\n",
	            rel_lat_enum_level_flag_level(rel_env, level) );
	 }
	

	if ( (rel_lat_enum_level_flag_level(rel_env, level)==0)&&  
	     (lat_rank(level_lat)==number_con+1)                  ) 
	 {
	  level= level+1;
	  level_lat= rel_lat_enum_coefs_lat_level(rel_env,level);
	  level_env= rel_lat_enum_coefs_env_level(rel_env,level);
                
          if (anf_print_level >= 99)
	   {
            printf("\n");
	   }

	  goto s3;
	 }        


	if (anf_print_level >= 5)
	 {
	  printf("\n\n\nrel_lat_enum, s3: lat_enum:   ");
  	  for(i=1;i<=lat_rank(level_lat);i++)
	     cay_print(" %d  ", lat_elt_coef(lat_enum_act_coefs(level_env),i));		
	  real_write(lat_chol_ring(level_lat),lat_enum_act_length(level_env),20);
	  printf("\n");			
	 }    


	if (anf_print_level > 3)
	 {
	  printf("\n\n\nlat_enum, l= %d:   ", level);
  	  for(i=1;i<=lat_rank(level_lat);i++)
	     cay_print(" %d  ", lat_elt_coef(lat_enum_act_coefs(level_env),i));		
	  real_write(lat_chol_ring(level_lat),lat_enum_act_length(level_env),20);
	  printf("\n");			
	 }    

        if (rel_lat_enum_counter(rel_env) <= -1)
	 {
	  printf("\n\n\nnew vector:  \n ");
  	  for(i=1;i<=lat_rank(level_lat);i++)
	     scanf("%d", &lat_elt_coef(lat_enum_act_coefs(level_env),i));		
	 
	  printf("\n\n\nrel_lat_enum, s3: new vector:   ");
  	  for(i=1;i<=lat_rank(level_lat);i++)
	     cay_print(" %d  ", lat_elt_coef(lat_enum_act_coefs(level_env),i));		
	  printf("\n");			

	 }

   	if (anf_print_level >= 5)
	 {
	   printf("\nrel_lat_enum, s3: level_flag= %d  (level= %d)\n",
	                   rel_lat_enum_level_flag_level(rel_env, level), level);
	 }


	rel_lat_enum_termination_flag_level(rel_env, level)=                
	      rel_lat_enum_termination_flag_level(rel_env, level+1) |
	      rel_lat_enum_level_flag_level(rel_env, level);

   	if (anf_print_level >= 5)
	 {
	   printf("\nrel_lat_enum, s3: termination_flag= %d  (level= %d)\n",
	                   rel_lat_enum_termination_flag_level(rel_env, level), level);
	 }


	if ( (level==1) && 
	     (rel_lat_enum_termination_flag_level(rel_env, level)==0) )
	 {
	  ring_delete(&Z);
	  real_delete(&zero);
	  real_delete(&loceps);
	  comp_elt_delete(C, &czero);
                                          
          if (anf_print_level >= 5)
            printf("\nrel_lat_enum, s3: return false (level= %d)\n", level);

	  return FALSE;
	 }


	/***  lattice element to anf element             ***/

        if (rel_lat_enum_act_coefs_entry(rel_env,level)!= MEM_NH)
	  anf_elt_delref(sub_order, &rel_lat_enum_act_coefs_entry(rel_env,level));

	anf_elt_alloc(rel_lat_enum_act_coefs_entry(rel_env,level), number_con);

	anf_elt_den(rel_lat_enum_act_coefs_entry(rel_env,level)) = 1;
	
	for(i=1;i<=number_con;i++) 
	 {
	  anf_elt_coef(rel_lat_enum_act_coefs_entry(rel_env,level),i) = 
	            integer_incref(lat_elt_coef(lat_enum_act_coefs(level_env),i));
	 }

        if (rel_lat_enum_act_coefs_con_entry(rel_env,level)!= MEM_NH)
	  anf_elt_delref(sub_order, &rel_lat_enum_act_coefs_con_entry(rel_env,level));
        


/*                           
        printf("\n***rel_lat_enum: test:  amf_elt \n");
        anf_elt_write(sub_order, rel_lat_enum_act_coefs_entry(rel_env,level));
        printf("\n");
*/


        rel_lat_enum_act_coefs_con_entry(rel_env,level)= 
            anf_elt_con(sub_order, rel_lat_enum_act_coefs_entry(rel_env,level));

   	if (anf_print_level >= 5)
	 {
 	  printf("\n\nrel_lat_enum, s3: conjugates:   ");
          anf_elt_write(sub_order, rel_lat_enum_act_coefs_con_entry(rel_env,level));
	  printf("\n");
	 }



/***    Special element found?  ***********************************************/


/*
	anf_elt_alloc(elt_sh2, number_con);
	anf_elt_den(elt_sh2) = 1;
	anf_elt_coef(elt_sh2,1)= 0;
	anf_elt_coef(elt_sh2,2)= 1;
	anf_elt_coef(elt_sh2,3)= 0;
	anf_elt_coef(elt_sh2,4)= -1;

        if (anf_elt_equal(sub_order,rel_lat_enum_act_coefs_entry(rel_env,2),
	                  elt_sh2) )
	 {
	  printf("\n\n\n\n");  
	  printf("*********************************************************\n");
          anf_elt_write(sub_order, elt_sh2);
	  printf("\n*********************************************************");
	  printf("\n\n\n\n");  
	 }
                          
	anf_elt_delete(sub_order, &elt_sh2);


	anf_elt_alloc(elt_sh1, number_con);
	anf_elt_den(elt_sh1) = 1;
	anf_elt_coef(elt_sh1,1)= 0;
	anf_elt_coef(elt_sh1,2)= 0;
	anf_elt_coef(elt_sh1,3)= -1;
	anf_elt_coef(elt_sh1,4)= -1;

        if (anf_elt_equal(sub_order,rel_lat_enum_act_coefs_entry(rel_env,1),
	                  elt_sh1) )
	 {
	  printf("\n\n\n\n");  
	  printf("*********************************************************\n");
          anf_elt_write(sub_order, elt_sh1);
	  printf("\n*********************************************************");
	  printf("\n\n\n\n");  
	  exit(1);
	 }
                          
	anf_elt_delete(sub_order, &elt_sh1);
*/


/***    level=1?    *********************************************************/

        if (level==1)
	  {
	  /**  Calculate the length and return: s5  **/
           
           if (anf_print_level >= 5)
 	     printf("\nrel_lat_enum, s5: return TRUE (level= %d)\n\n", level);

	   for (i=1; i<= r1r2; i++)
	    {  
	     /* i-th conjugate of the level-th act_coefs (x_i)  */

	     anftemp1= rel_lat_enum_act_coefs_con_entry(rel_env,level);
	     ctemp1= anf_elt_ith_con(sub_order, anftemp1, i);

	     if (anf_print_level >= 5)
	      {
	       printf("x_1=                      ");
	       comp_write(C, ctemp1, 20);
	       printf("\n");

	       printf("S_1=                      ");
	       comp_write(C, rel_lat_enum_part_sums_con_level(rel_env,i,level), 20);
	       printf("\n");
	      }

	     /* ttemp2=  q_{11}*|x_1 +S_1|^2                      */

	     ctemp2= comp_add(C, ctemp1, 
	                    rel_lat_enum_part_sums_con_level(rel_env,i,level));
	     ttemp1= comp_norm(C, ctemp2);

             if (anf_print_level > 3)
	      {
	       printf("|x_1 +S_1|^2=             ");
	       real_write(R, ttemp1, 20);
	       printf("\n");
	      }

	     ttemp3= comp_re(C,
	                     mat_elt(rel_lat_chol_con(rel_lat,i),level,level));

   	     if (anf_print_level >= 5)
	      {
	       printf("q_{11}=                   ");
	       real_write(R, ttemp3, 20);
	       printf("\n");
	      }

	     ttemp2= real_mult(R, ttemp1, ttemp3);
	     comp_elt_delete(C, &ctemp1);
	     comp_elt_delete(C, &ctemp2);
	     real_delete(&ttemp1);
	     real_delete(&ttemp3);   

   	     if (anf_print_level >= 5)
	      {
	       printf("q_{11}*|x_1 +S_1|^2=      ");
	       real_write(R, ttemp2, 20);
	       printf("\n");
              }
	                              
	     /* length:  C + q_{11}*|x_1 +S_1|^2 - T_1            */

	     ttemp1= real_add(R, rel_lat_enum_ubounds_con(rel_env,i), ttemp2);
	     real_delete(&ttemp2);


   	     if (anf_print_level >= 5)
	      {
	       printf("C=                        ");
	       real_write(R,rel_lat_enum_ubounds_con(rel_env,i) , 20);
	       printf("\n");
	      }

	     if (rel_lat_enum_act_lengths_con(rel_env,i)!= MEM_NH)
	                  real_delete(&rel_lat_enum_act_lengths_con(rel_env,i));

	     ttemp3= real_subtract(R,ttemp1, 
	                         rel_lat_enum_tmp_bounds_con_level(rel_env,i,level));
	     real_delete(&ttemp1);



   	     if (anf_print_level >= 5)
	      {
	       printf("\n\nact_lenghts(%d)=   ", i);
	       real_write(R, ttemp3, 20);
	       printf(  "\nubound=            ");
	       real_write(R, rel_lat_enum_ubounds_con(rel_env,i), 20); 
	       printf("\ncompare: %d \n\n",
		 real_compare_eps(R, ttemp3, rel_lat_enum_ubounds_con(rel_env,i), loceps));
	      }


	     if (real_compare_eps(R, ttemp3, rel_lat_enum_ubounds_con(rel_env,i), 
	                                                        loceps)==1)  
	      {
	       real_delete(&ttemp3);

	       if (anf_print_level >= 99)
  	        {
	         printf("level= %d, lat_enum:    ", level);
  	         for(i=1;i<=lat_rank(level_lat);i++)
	           cay_print(" %d  ", lat_elt_coef(lat_enum_act_coefs(level_env),i));		
		 if (lat_rank(level_lat) == number_con)
		    ttemp5= real_incref(lat_enum_act_length(level_env));
		  else
		   {
                    ttemp1= conv_int_to_real(R, 2);                      
		    ttemp4= real_divide(R, lat_enum_ubound(level_env), ttemp1); 
		    ttemp5= real_subtract(R, lat_enum_act_length(level_env), ttemp4);
		    real_delete(&ttemp1);
		    real_delete(&ttemp4);
		   }      
	         real_write(lat_chol_ring(level_lat), ttemp5,20);
		 real_delete(&ttemp5);
	         printf("  --> F\n");			
	        }    

	       goto s3;
	      }

	     rel_lat_enum_act_lengths_con(rel_env,i)= real_incref(ttemp3);

   	     if (anf_print_level >= 5)
	      {
	       printf("T_1=                      ");
	       real_write(R, rel_lat_enum_tmp_bounds_con_level(rel_env,i,level) , 20);
	       printf("\n");

	       printf("act_lenghts(%d)=           ", i);
	       real_write(R, rel_lat_enum_act_lengths_con(rel_env,i), 20);
	       printf("\n\n");
	      }

	     real_delete(&ttemp3);
	    }

	   ring_delete(&Z);
	   real_delete(&zero);
	   real_delete(&loceps);
	   comp_elt_delete(C, &czero);

	   rel_lat_enum_counter(rel_env) += 1;

	   if (anf_print_level >= 99)
  	    {
	     printf("level= %d, lat_enum:    ", level);
  	     for(i=1;i<=lat_rank(level_lat);i++)
	       cay_print(" %d  ", lat_elt_coef(lat_enum_act_coefs(level_env),i));		
             if (lat_rank(level_lat) == number_con)
	       ttemp5= real_incref(lat_enum_act_length(level_env));
	      else
	       {
                ttemp1= conv_int_to_real(R, 2);                      
	        ttemp4= real_divide(R, lat_enum_ubound(level_env), ttemp1); 
	        ttemp5= real_subtract(R, lat_enum_act_length(level_env), ttemp4);
	        real_delete(&ttemp1);
	        real_delete(&ttemp4);
	       }      
	     real_write(lat_chol_ring(level_lat), ttemp5,20);
	     real_delete(&ttemp5);
	     printf("  --> R\n");			
	    }    

	   return TRUE;
	  }
	 else
	  {
	  /**  Set level= level-1: s6               **/  

	   level= level - 1;

	  /**  part_sums for all conjugates         **/

           if (anf_print_level >= 5)
  	     printf("\nrel_lat_enum, s6: calculation of part_sums (level= %d)\n", level);

	   for (i=1; i<= r1r2; i++)
	    {         
	     /* S_i= sum_{j=i+1}^k q_{ij} x_j               */
             
	     ctemp1=  comp_incref(czero);
	     mtemp1= rel_lat_chol_con(rel_lat,i);
 	     for (l=level+1; l<= rank; l++)
	      {                         
	       anftemp1= rel_lat_enum_act_coefs_con_entry(rel_env,l);
	       ctemp2= anf_elt_ith_con(sub_order, anftemp1, i);

	       ctemp3= ctemp2;
	       ctemp2= comp_mult(C, ctemp3, mat_elt(mtemp1,level,l) );
	       comp_elt_delete(C, &ctemp3);

	       ctemp3= ctemp1;
	       ctemp1= comp_add(C, ctemp1, ctemp2);
	       comp_elt_delete(C, &ctemp3);
	       comp_elt_delete(C, &ctemp2);

	      } /*  for: l  */
	       
	      comp_elt_delete(C, &rel_lat_enum_part_sums_con_level(rel_env,i,level));

              rel_lat_enum_part_sums_con_level(rel_env,i,level) = 
	                                                  comp_incref(ctemp1);
	      comp_elt_delete(C, &ctemp1);


              if (anf_print_level >= 5)
	       {
	        printf("\n\npart_sums_con_level(%d,%d):  \n", i, level); 
	        comp_write_aj(R,rel_lat_enum_part_sums_con_level(rel_env,i,level),20); 
	        printf("\n\n");
	       }


	    } /*  for: i  */         

	  /**  tmp_bounds for all conjugates         **/

           if (anf_print_level >= 5)
	     printf("\nrel_lat_enum, s6: calculation of tmp_bounds (level= %d)\n", level);
                                                       
	   /* T_i= T_{i+1}  - q_{i+1,i+1} |x_{i+1} +S_{i+1}|^2      */

	   for (i=1; i<= r1r2; i++)
	    {                          
	     anftemp1= rel_lat_enum_act_coefs_con_entry(rel_env,level+1);
	     ctemp1= anf_elt_ith_con(sub_order, anftemp1, i);
                                                        
	     ctemp2= comp_add(C, ctemp1, 
	                  rel_lat_enum_part_sums_con_level(rel_env,i,level+1));
	     ttemp1= comp_norm(C, ctemp2);

             if (anf_print_level > 3)
	      {
	       printf("|x_l +S_l|^2=             ");
	       real_write(R, ttemp1, 20);
	       printf("\n");
	      }

	     ttemp3= comp_re(C,
	                 mat_elt(rel_lat_chol_con(rel_lat,i),level+1,level+1));
	     ttemp2= real_mult(R, ttemp1, ttemp3);
	     comp_elt_delete(C, &ctemp1);
	     comp_elt_delete(C, &ctemp2);
	     real_delete(&ttemp1);
	     real_delete(&ttemp3);
                                                               
                                               

	     real_delete(&rel_lat_enum_tmp_bounds_con_level(rel_env,i,level));

	     rel_lat_enum_tmp_bounds_con_level(rel_env,i,level)= real_subtract(R, 
	            rel_lat_enum_tmp_bounds_con_level(rel_env,i,level+1), ttemp2);

             if (anf_print_level >= 5)
	      {
	       printf("\n\ntmp_bounds_con_level(%d,%d):  \n", i, level); 
	       real_write(R,rel_lat_enum_tmp_bounds_con_level(rel_env,i,level),20); 
	       printf(" =  ");
	       real_write(R,rel_lat_enum_tmp_bounds_con_level(rel_env,i,level+1),20); 
	       printf(" -  ");
	       real_write(R,ttemp2,20); 
	       printf("\n \n");
	      }


	     if (real_compare_eps(R, ttemp2, 
		             rel_lat_enum_tmp_bounds_con_level(rel_env,i,level+1), 
	                                                                loceps)==1)  
	      {
	       real_delete(&ttemp2);

	       if (anf_print_level >= 99)
  	        {
	         printf("level= %d, lat_enum:    ", level+1);
  	         for(i=1;i<=lat_rank(level_lat);i++)
	           cay_print(" %d  ", lat_elt_coef(lat_enum_act_coefs(level_env),i));		
       		 if (lat_rank(level_lat) == number_con)
		    ttemp5= real_incref(lat_enum_act_length(level_env));
		  else
		   {
                    ttemp1= conv_int_to_real(R, 2);                      
		    ttemp4= real_divide(R, lat_enum_ubound(level_env), ttemp1); 
		    ttemp5= real_subtract(R, lat_enum_act_length(level_env), ttemp4);
		    real_delete(&ttemp1);
		    real_delete(&ttemp4);
		   }      
	         real_write(lat_chol_ring(level_lat), ttemp5,20);
		 real_delete(&ttemp5);
	         printf("  --> F\n");			
	        }    

	       goto s3;
	      }


	     real_delete(&ttemp2);
	    }

	   if (anf_print_level >= 99)
  	    {
	     printf("level= %d, lat_enum:    ", level+1);
  	     for(i=1;i<=lat_rank(level_lat);i++)
	       cay_print(" %d  ", lat_elt_coef(lat_enum_act_coefs(level_env),i));		
       	     if (lat_rank(level_lat) == number_con)
	       ttemp5= real_incref(lat_enum_act_length(level_env));
	      else
	       {
                ttemp1= conv_int_to_real(R, 2);                      
	        ttemp4= real_divide(R, lat_enum_ubound(level_env), ttemp1); 
	        ttemp5= real_subtract(R, lat_enum_act_length(level_env), ttemp4);
	        real_delete(&ttemp1);
	        real_delete(&ttemp4);
	       }      
	     real_write(lat_chol_ring(level_lat), ttemp5,20);
	     real_delete(&ttemp5);
	     printf("  --> R\n");			
	    }    

	   goto s2;
	  }  
	




/***    End    *********************************************************/



}		






