/*******************************************************************************
  regula_falsi_zero.c 
    find_intervall
    my_value
    regula_falsi_zero
********************************************************************************/


#include "kant.h"
#include "anf_rel_sort.h"


t_void
add_anf_elt_to_norm_sol_list ();

t_logical 
order_lat_norm_equation_aj WITH_14_ARGS (
				      order             , ord       ,
				      order             , sub_ord   ,
                                      anf_ideal         , ideal     ,
                                      lattice           , lat       ,
                                      lat_enum_env      , env       ,
                                      integer_big       , K         ,
                                      anf_elt *         , gamma     ,
                                      dyn_arr_handle *  , all       ,
                                      t_logical         , find_all  ,
                                      t_logical         , is_ideal  ,
                                      t_logical         , abs_value ,
                     	              anf_rel_sort      , sort      ,
			              vector            , rel_K     ,
                                      anf_elt           , norm_elt
)
/*******************************************************************************
 
Description:
                                         
      The basis programm for solving norm - equations.
      Tries to solve the eqaution 
      (*)                         N(x) = K        
      in either an order or in an ideal. This is indicated by the flag is_ideal.
      If "is_ideal" ist TRUE the procedure tries to solve (*) in the ideal 
      "ideal", in the other case the search is done in the order "ord". All not -
      associated solutions are returned iff "find_all" ist TRUE. Moreover if 
      "abs_value" is TRUE we solve (*) exactly, and if "abs_value" is FALSE we 
      solve
      (**)                        |N(x)| = K
      If "find_all" is TRUE we return all solutions in the dynamic array all and
      gamma will remain empty. If just one solution is required we return it to 
      the calling function in gamma.
                           
      The lattice "lat" has to be the lattice given by "ideal" or "ord". This 
      depends on the value of "is_ideal". "env" contains the environment 
      associated to ideal. 

 
Calling sequence:
 
 
      	order  	        ord            = t_handle of an order (maybe the checked one) 
        anf_ideal       ideal          = checked ideal.
        lattice         lat            = lattice of (ord or ideal)                      
        lat_env         env            = environment of lattice                                       

        integer_big     K              = as desc. in (*).

        anf_elt         gamma          = Element solving (*).
        dyn_arr_handle  list           = If you need all sol. of (*) they
                                            will be stored in this dyn. array.

	t_logical         find_all     = switch as desc. above.
        t_logical         is_ideal     = dito.
        t_logical         abs_value    = dito.
                                                                  

            order_lat_norm_equation (ord,ideal,lat,env,K,&gamma,&list,
                                     find_all,is_ideal,abs_value      );
 
History:
 
	92-07-13 MD     written

 
*******************************************************************************/
{ 

          	block_declarations;         

                t_handle      C, R,Z;
                lattice       new_lat,lll_lat;
                lat_enum_env  lll_lat_env;                    
                 

                anf_ceiling   ceil;   
                matrix        trans,inv_trans;

                     
                lat_elt       lat_vec;
                anf_elt       alpha, elt_h1;
                t_real        gamma_k,bound;
                t_real        temp1,temp2,temp3, loceps;  
                t_comp        ctemp1,ctemp2,ctemp3, ctemp4, ctemp5, norm_elt_c;  
                integer_big   norm,den,temp;

                                  
                integer_small no_of_ell,no_found,no_found_norm;
                integer_small n,i, sub_r1, sub_r2, sub_r1r2,j,l;
                t_logical     ok,end, erg;
                                

		vector        rbounds_lower, rbounds_upper, norms;
                                                     
                                                       

  order_reals_assure (ord);
  R = order_reals (ord);
  Z= m_z_str_incref(structure_z);
  loceps= real_make(R, 10, -real_dec_prec(R)+2 );  
  C = comp_create(real_dec_prec(R));
  n = order_abs_degree (ord);
  sub_r1=  order_r1(sub_ord);
  sub_r2=  order_r2(sub_ord);
  sub_r1r2=  sub_r1+sub_r2; 

  norm_elt_c= anf_elt_ith_con(sub_ord, norm_elt,1);

/****************************************************************/
/* New                                                          */
/****************************************************************/

  if (!order_fincke_lambda_known(ord))
    order_fincke_lambda_calc (ord);

/*  exit(1);*/

  order_fincke_rbounds_calc_aj (ord, sub_ord, rel_K, sort, &rbounds_lower, &rbounds_upper);

/****************************************************************/

 
/* Now calc . the value of gamma + k */
  temp1   = conv_int_to_real (R,K);   
  temp2   = real_mult (R,order_fincke_gamma1 (ord),temp1);
  gamma_k = real_add (R,temp1,temp2);
                                   
  real_delete (&temp1);
  real_delete (&temp2);
                  

/* Now calc. the bound for the T2 norm */
  
  temp1 = conv_double_to_real ( R,(double) (2.0/(1.0*n)) ); 
  temp2 = real_real_power (R,gamma_k,temp1);
  temp3 = conv_int_to_real (R,n+4);

  bound = real_mult (R,temp2,temp3);

  real_delete (&temp1);
  real_delete (&temp2);
  real_delete (&temp3);




  if (anf_print_level >= 0)
  {
    printf ("(n = %d, r1 = %d)\n",n,order_r1(ord));
    printf ("TASK : \n");
    cay_print ("solving N(x) = %d   (With (gamma + k ) = ",K);real_write (R,gamma_k,10);
    if (find_all) 
      printf (" and find ALL sol.");                     
    else
      printf (" and find ONE sol.");                     
 
    printf    ("\nand t2 bound = ");real_write (R,bound,10);

    printf ("\nlambda  : ");real_write (R,order_fincke_lambda (ord),20);puts ("");       
    printf ("rbounds (lower, upper):\n\n ");
    for (i=1; i<=n;i++)
      printf(" (%d, %d)\n ", vec_entry(rbounds_lower,i), vec_entry(rbounds_upper,i));
    printf("\n\n");
  }
      

  *gamma    = MEM_NH;                       
  *all      = MEM_NH;

  no_found       = 0;    /* No. of alg. numbers found */
  no_found_norm  = 0;    /* No. of alg. numbers with norm K found */
  no_of_ell      = 0;    /* No. of ell. considerd.                */ 

                                     
  end       = FALSE;





                      
  ok = anf_ceiling_fincke_init_aj (ord,&ceil,rbounds_lower, rbounds_upper);

  if (!ok) 
     anf_ceiling_fincke_next_aj (ord,&ceil,rbounds_lower, rbounds_upper);

  if (!ok) 
    error_internal ("ORDER_LAT_NORM_EQUATION : Can't initialize ceiling");
 
  
  do 
  {                                                                 
    no_of_ell++;  

    if (anf_print_level >= 2)
    {
      anf_ceiling_write (ord,ceil);puts ("");
    }


/****/

    printf("\nno_of_ell: %d \n", no_of_ell);
    if (no_of_ell==2) 
     {
      puts ("Statistics :");
      printf (" No of ellip. considered             : %d\n",no_of_ell);
      printf (" No of numbers found in these ellip. : %d\n",no_found);
      printf (" No of numbers found with right norm : %d\n",no_found_norm);
      if ((find_all) && (*all != MEM_NH))
        printf (" No of non associated numbers        : %d\n",dyn_arr_curr_length (*all));
      printf("\n \n");
      exit(1);
     } 

/****/

    if (anf_print_level<=3)
    {
    new_lat = order_lat_ceiling_mult (ord,lat,ceil);
       
    lll_lat = lat_lll_reduce(new_lat,&trans,&inv_trans);
    lll_lat_env = lat_enum_create(lll_lat);

    lat_enum_status_set_new   (lll_lat_env);
    lat_enum_request_set_next (lll_lat_env);
    lat_enum_strategy_set_up  (lll_lat_env);          
    lat_enum_ubound (lll_lat_env) = real_incref (bound);
  
    while ( lat_enum (lll_lat, lll_lat_env) && (!end) )
    {    
    
      no_found++;      

      lat_vec  = lat_elt_move (lll_lat,lat_enum_act_coefs(lll_lat_env),trans);
                              
      if (is_ideal)
        alpha = lat_elt_ideal_to_anf_elt (new_lat, lat_vec, ord, ideal);
      else
        alpha = lat_elt_to_anf_elt (new_lat, lat_vec, ord);
          
                                         
/**********************************************************************/
/**********************************************************************/

      norms= anf_elt_rel_norms(ord, sub_ord, alpha, sort, abs_value); 

      if ( (anf_print_level >3) && (abs_value==FALSE) )
       {
        printf("norm:   ");
        temp1= conv_int_to_real(R, 1);
        for (l=1;l<=sub_r1;l++) 
         {                                                            
          temp2= temp1;
          temp1= real_mult(R,temp2,vec_entry(norms,l));
          real_delete(&temp2);
          real_write_aj(R, vec_entry(norms,l), 15);
          if (l!=sub_r1r2)  printf(" * ");
         }                         
        for (l=sub_r1+1;l<=sub_r1r2;l++) 
         {                                                            
          temp2= temp1;  
          temp3= real_power(R, vec_entry(norms,l), 2);
          temp1= real_mult(R,temp2,temp3);
	  real_delete(&temp2);
	  real_delete(&temp3);
     	  real_write_aj(R, vec_entry(norms,l), 15);
	  printf("^2");
	  if (l!=sub_r1r2)  printf("  * ");
     	 }                          

     	printf(" =  "); 
      	real_write_aj(R, temp1, 15);
	elt_h1= anf_elt_con(ord, alpha);
	anf_norm(ord, elt_h1, &norm, &den);
	anf_elt_delete(ord, &elt_h1);
	printf("   (absolute= ");
	integer_write(norm);
	printf(")\n\n");
        integer_delref(norm);
        integer_delref(den);
	real_delete(&temp1);   
       }   

      if ( (anf_print_level >3) && (abs_value==FALSE) )
       {
        printf("norm:   ");
	ctemp1= conv_int_to_comp(C, 1);
     	for (l=1;l<=sub_r1;l++) 
     	 {                                                            
	  ctemp2= ctemp1;
	  ctemp1= comp_mult(C,ctemp2,vec_entry(norms,l));
	  comp_elt_delete(C, &ctemp2);
     	  comp_write_aj(C, vec_entry(norms,l), 15);
	  if (l!=sub_r1r2)  printf("\n * ");
     	 }                         
	for (l=sub_r1+1;l<=sub_r1r2;l++) 
     	 {                                                            
	  ctemp2= ctemp1;  
	  ctemp3= comp_incref(vec_entry(norms,l));
	  ctemp4= comp_conjugate(C, ctemp3);
	  printf("(");
     	  comp_write_aj(C, ctemp3, 15);
	  printf(" * ");
     	  comp_write_aj(C, ctemp4, 15);
	  printf(")");
	  ctemp5= comp_mult(C, ctemp3, ctemp4);
	  ctemp1= comp_mult(C,ctemp2,ctemp5);
	  comp_elt_delete(C, &ctemp2);
	  comp_elt_delete(C, &ctemp3);
	  comp_elt_delete(C, &ctemp4);
	  comp_elt_delete(C, &ctemp5);
	  if (l!=sub_r1r2)  printf("\n       * ");
         }                          
   	printf(" =  "); 
      	comp_write_aj(C, ctemp1, 15);
	elt_h1= anf_elt_con(ord, alpha);
	anf_norm(ord, elt_h1, &norm, &den);
	anf_elt_delete(ord, &elt_h1);
	printf("   (absolute= ");
	integer_write(norm);
	printf(")\n\n");
        integer_delref(norm);
        integer_delref(den);
	comp_elt_delete(C, &ctemp1);   
       }

      if (abs_value==FALSE)
        {
 	 erg= TRUE;
     	 for (j=1;j<=sub_r1r2;j++) 
          { 
     	   if (real_equality_eps(R,vec_entry(norms,j),vec_entry(rel_K,j),loceps)==0)
	    {
	     erg= FALSE;
	     break;
	    }
          }
	 vec_delete(R, &norms);
        }
       else
        {            
         erg= TRUE;
         if (comp_equality_eps(C, R, vec_entry(norms,1), norm_elt_c,loceps)==0)
           erg= FALSE;
         vec_delete(C, &norms);
        }



/**********************************************************************/
/**********************************************************************/

      if (erg) 
      {                     
        no_found_norm++;      
                           
        if (anf_print_level >3)
        {
          printf (" FOUND : ");anf_elt_write (ord,alpha);puts ("");        
        }

        if (find_all) 
        {
          add_anf_elt_to_norm_sol_list (ord,alpha,all);
        }
        else
          {       
             *gamma = anf_elt_incref (alpha);
             end    = TRUE;
          }                                   
      }
        
      lat_elt_delete (lll_lat,&lat_vec);
      anf_elt_delete (ord, &alpha);
    }

    Z = m_z_str_incref(structure_z);
    mat_delref(Z,&trans);
    mat_delref(Z,&inv_trans);
    ring_delete(&Z);	


    lat_enum_delete(lll_lat, &lll_lat_env);

    lat_delete(&new_lat);                  
    lat_delete(&lll_lat); 
    } /* end if */                 
           
    if (anf_print_level >1)
    {
      puts ("------------------------------------------------------------------------");
    }
  }
  while ( (!end) && (ok = anf_ceiling_fincke_next_aj (ord,&ceil,rbounds_lower, rbounds_upper)) );
                
  anf_ceiling_delete (ord,&ceil);

  real_delete (&gamma_k);                                  
  real_delete (&bound);                                  
  real_delete (&loceps);                                  
  comp_elt_delete(C, &norm_elt_c);  
  vec_delete(Z,&rbounds_lower);
  vec_delete(Z,&rbounds_upper);

  ring_delete(&Z);
                       
  if (anf_print_level >=0)
  {
    puts ("Statistics :");
    printf (" No of ellip. considered             : %d\n",no_of_ell);
    printf (" No of numbers found in these ellip. : %d\n",no_found);
    printf (" No of numbers found with right norm : %d\n",no_found_norm);
    if ((find_all) && (*all != MEM_NH))
      printf (" No of non associated numbers        : %d\n",dyn_arr_curr_length (*all));
    printf("\n \n");
  }


  if ( (anf_print_level >3) && (!find_all) && (end) )
  {
      printf ("SOLUTION FOUND :  ");anf_elt_write (ord,*gamma); puts ("");      
  }

}





t_void 
add_anf_elt_to_norm_sol_list WITH_3_ARGS (order           , ord   , 
                                          anf_elt         , a     ,
                                          dyn_arr_handle* , list   )
                                                               
{
        block_declarations;         

                                   
        anf_elt         b,c;
        integer_small   i,len;
       
        t_logical         is_ass;
 


/*    printf (" a= ");anf_elt_write (ord,a);  */


    if (*list == MEM_NH)
    {
      *list  = dyn_arr_alloc (1); 
      dyn_arr_element (*list,0)   = anf_elt_incref (a);
      dyn_arr_curr_length (*list) = 1;
      if (anf_print_level >3) 
      {
        printf ("New element :  ");anf_elt_write (ord,a); puts ("");      
      }
    }
    else
      {          
        len    = dyn_arr_curr_length (*list);
        i      = 0;
        is_ass = FALSE;
            
        while ((!is_ass) && (i<len))
        {
          b = dyn_arr_element (*list,i);
          c = anf_div (ord,a,b);
                                
          if ( (anf_elt_is_integer (c))  || (anf_elt_den (c) == 1) )
            is_ass = TRUE ;
        
          anf_elt_delete (ord,&c);

          i++;
        }                       

        if (!is_ass)
        {
          dyn_arr_assure_space (*list,len+1,1);
          
          dyn_arr_element (*list,len) = anf_elt_incref (a);
          dyn_arr_curr_length (*list) = len+1;
         
          if (anf_print_level >3)
          {
            printf ("New element :  ");anf_elt_write (ord,a); puts ("");      
          }
        }
      }            
/*   printf ("\n");      */
}

