#include "kant.h" 



extern t_void pchar();

t_void
real_write_aj WITH_3_ARGS(
	t_handle,		r,
	t_real,		x,
	integer_small,	wid
)
/*
Prints out x.
*/
{
    mp_float	f;

    real_make_mp(x, f);
    mp_break(f, 10, wid, -(wid-6), pchar);
}




t_real
real_read_aj WITH_2_ARGS(
        t_handle,  R,
        char*,   str
)
/*******************************************************************************
 
AJ January 1992
Last modification: -

 
 
 
Description:
 
	This routine reads exactly one t_real from the string str.
 
Calling sequence:
 
	real_read_aj(r, x, wid);
 
	t_handle		r	= real ring       
	char*		str	= string with t_real number
 
History:
 
	92-02-04 AJ    written
 
*******************************************************************************/
{
        mp_float       m; 
        mp_length      base, base_places;
        t_real         rvar;  
        integer_small  prec;
                  
        prec=  real_dec_prec(R);
        mp_decimal(prec, &base, &base_places);
        m= mp_alloc(base, base_places); 
        mp_a_to_mp(str, m);  

/*  Output of the mp_float m  
        mp_break(m,10,50,prec,pchar);
        puts("");
*/
        rvar= mp_to_real(m); 

/*  Output of the t_real rvar
        real_write(R, rvar, 50);
        puts("");
*/

        return rvar;
} 


 



matrix 
mat_real_read_aj WITH_3_ARGS(
        t_handle,     R,
        integer_small,   matrix_row,
        integer_small,   matrix_col
)       
/*******************************************************************************
 
AJ January 1992
Last modification: -

 
 
 
Description:
 
	This routine reads a t_real matrix from the standard input stream
	row by row. The matrix elements in one row must be seperated by blanks.
 
Calling sequence:
 
	mat= mat_real_read_aj(r, row, col);
 
	t_handle		r	= real ring       
	integer_small	row	= number of rows of mat
	integer_small	col	= number of columns of mat
 
History:
 
	92-02-04 AJ    written
 
*******************************************************************************/
{        
        block_declarations;

        matrix     rmat; 
        char       str_read[256], *str;
        char       token[256];
        int        num, i, j, first, next,l;

       
/*** Initialisation  **********************************************************/
          
 	rmat = mat_new(matrix_row, matrix_col);

/*** Input loop  **************************************************************/
        
        for (j=1; j<=matrix_row; j++)
         {       
          i=1;
          gets(str_read); 
          
          for (first=0; str_read[first]!=0; first++)
           /*  This loop seperates the matrix elements in str_read */
           {                     
            if (str_read[first]!=' ')  
             {
              for (next=first; (str_read[next]!=' ')&&(str_read[next]!=0); next++);
              num= next-first; 
              for (l=first; l<next; l++)  token[l-first]= str_read[l];
              token[l-first]= '\0';
              mat_elt(rmat, j, i)= real_read_aj(R, token);
              if (str_read[next]=='\0') break;
              first= next;
              i++; 
             } /* endif */
           }  /* for: first */
         }  /* for: j */

        return rmat;
}    

                          







                                                                
t_void
mat_real_write_aj WITH_3_ARGS(
	t_handle,		reals,
	matrix,	        mat,
        integer_small,  wid
)
/*******************************************************************************
 
AJ January 1992
Last modification: -

 
 
 
Description:
 
	Prints a matrix over the reals with format wid.
 
Calling sequence:
 
	mat_real_write_aj(r, mat, wid);
 
	t_handle		r	= real ring       
	matrix 		mat	= a matrix
	integer_small	wid	= mat is printed in format wid
 
History:
 
	92-02-04 AJ    written
 
*******************************************************************************/
{
	integer_small	m, n, i, j;
 
        m = mat_row(mat);
        n = mat_col(mat);
                                  
	for (i=1; i<=m; ++i)
	 {
	  for (j=1; j<=n; ++j)
	   {
	    real_write_aj(reals, mat_elt(mat, i, j), wid);
	    printf("    ");
	   }
	  if (i<m)  
            printf("\n");
	 }
 
	return;
}
 


