/******************************************************************************
  anf_rel_sort_create.c
******************************************************************************/
#include "kant.h"
#include "anf_rel_sort.h"


anf_rel_sort
anf_rel_sort_create WITH_2_ARGS(
	order,		ord,
	order,		sub_ord
)
/*******************************************************************************
 
Description:	Allocating space for the structure anf_rel_sort.
 
		The task of this routine is to allocate sufficient space 
		for the table which describes a anf_rel_sort. 
 
Calling sequence:
 

 
History:
 
	92-06-25 AJ	written
 
*******************************************************************************/
{
	block_declarations;

	anf_rel_sort		sort;
        integer_small   	i, nm, m, n, r1_sub;
                                

	sort= mem_alloc_zero(sizeof(anf_rel_sort_struct));
	block_init(sort, ANF_REL_SORT_BLOCK_TYPE);
 
        nm=  order_abs_degree(ord);  
        n=  order_abs_degree(sub_ord);  
        r1_sub= order_r1(sub_ord);  

	anf_rel_sort_m(sort)= nm/n;  

	anf_rel_sort_ordering(sort)= vec_new(nm);

        anf_rel_sort_real_zeroes(sort)= vec_new(r1_sub);

        anf_rel_sort_comp_zeroes(sort)= vec_new(r1_sub);

	for (i=1; i<= r1_sub; i++)      
	 {
	  anf_rel_sort_real_zeroes_elt(sort,i)= 0;
	  anf_rel_sort_comp_zeroes_elt(sort,i)= 0;
	 }
 
        return sort;
}
