#include "kant.h"

faclst
anf_elt_factorization_md WITH_2_ARGS (order   ,  ord,
			  	      anf_elt ,  alpha )
/*******************************************************************************
 
Description:
 
        Factorizes an alg. number (resp. it's principal ideal) into
        prime ideals and return this factorization. 
        There are some diff. to anf_elt_factorize :
                1) This function returns faclst.
                2) This function will always return a factorization.
 
Calling sequence:
 
 
      	order  	      ord         : Maximal order of a field.
        anf_elt       alpha       : We fac. alpha*ord.

        alpha_fac     faclst      : The fac. of alpha*ord.
  

        alpha_fac = anf_elt_factorization_md (ord,alpha);

History:                                          
 
	92-09-07 MD     written
 
*******************************************************************************/

{      
                 block_declarations;

                 faclst          norm_fac;         
                 dyn_arr_handle  rem=0;


                 anf_elt         alphan,rel;
                                        
                 integer_big     norm,den,abs_norm;
                 integer_small   rcnt,i,max;
                 t_logical       ok; 
  
/* just check if alpha is already in the factorbasis .. */

  rcnt  = order_relation_count(ord);

  if (rcnt > 0)
  {
    alphan = anf_elt_negate(ord, alpha);
    for (i=1; i<=order_relation_count(ord); i++)
    {
      rel = vec_entry(order_relation_numbers(ord), i);

      if (anf_elt_equal(ord, alpha,  rel) ||
          anf_elt_equal(ord, alphan, rel))
      {
        anf_elt_delete(ord, &alphan);
        return   create_faclst_from_relation_mat (ord,i);
      }
    }
    anf_elt_delete(ord, &alphan);
  }
	
/*  alpha has'nt been treated so far ... */
             
/* So we make sure that every rational prime dividing norm (alpha) */
/* is in the factor-basis.                                         */
        
   

  anf_elt_norm (ord,alpha,&norm,&den);
  abs_norm = integer_abs (norm);

  integer_delref (norm);
  integer_delref (den);

  integer_lst_factorise   (abs_norm, &norm_fac, &rem, 
                                     50, 1000, 262144, 0, 0, 0, 0, abs_norm, 0);
  max = faclst_num_prime (norm_fac);   
           
  for (i=0;i<max;i++)  
    order_fac_basis_extend (ord,faclst_prime (norm_fac,i));


  integer_delref (abs_norm);
  faclst_delete (&norm_fac);
  if (rem) 
    dyn_arr_delete (&rem);

  

/* Ok all rat. primes are stored in the fac_bas. */

  ok = anf_elt_factorize_md (ord,alpha);


  if (!ok) 
    return MEM_NH;
  else  
    return create_faclst_from_relation_mat (ord,order_relation_count (ord));
}
