#ifndef KANT

#include "alg.e"
#include "zm.e"
#include "gf.e"
#include "bind.h"
#include "error.e"
#include "ring.e"

t_logical
zm_elt_coerce(zmring, str, elt, itm, nelt, nitm, do_error)
t_handle       zmring;
t_handle       str;
t_handle       elt;
t_int          itm;
t_handle	*nelt;
t_int 		*nitm;
t_logical	do_error;
/*
** lift element into Z_m ring.
*/
{
    block_declarations;

	ASSERT (structure_repnum (zmring) == REP_ZM);

    if (structure_varnum(str) != VAR_RING)
        return FALSE;
    switch (ring_type (str))
    {
    case RING_Z:
        *nelt = modint_hom( zm_modulus(zmring), elt);
        break;

    case RING_ZM:
	/*
        ** if (integer_ne (zm_modulus (zmring), zm_modulus (str)))
        **     return FALSE;
	*/
        *nelt = modint_hom (zm_modulus(zmring), elt);
        break;

    case RING_GFP:
    case RING_GFQ:
        if (gf_expon(str) != 1 || integer_ne (zm_modulus (zmring), gf_character (str)))
            return FALSE;
        *nelt = integer_incref (gf_convert_to_int (str, elt));
        if (*nelt < 0)
            return FALSE;
        break;

    default :
        return FALSE;
    }
    *nitm = 0;
    return TRUE;
}

#else /* KANT */

#include "defs.h"
#include "zm.e"
#include "error.e"
#include "ring.e"

t_logical
zm_elt_coerce(zmring, str, elt, itm, nelt, nitm, do_error)
t_handle       zmring;
t_handle       str;
t_handle       elt;
t_int          itm;
t_handle	*nelt;
t_int 		*nitm;
t_logical	do_error;
/*
** lift element into Z_m ring.
*/
{
	block_declarations;

	ASSERT (structure_repnum (zmring) == REP_ZM);

	switch (ring_type (str))
	{
	case RING_Z:
		*nelt = modint_hom( zm_modulus(zmring), elt);
		break;

	case RING_ZM:
		/*
		** if (integer_ne (zm_modulus (zmring), zm_modulus (str)))
		**     return FALSE;
		*/
		*nelt = modint_hom (zm_modulus(zmring), elt);
		break;

	default :
		return FALSE;
	}
	*nitm = 0;
	return TRUE;
}

#endif /* KANT */

