#include "defs.h"
#include "real.e"

mp_base_type	real_base;

void
real_start WITH_2_ARGS(
	mp_round_type,	r,
	void_func,	callback /*(char *)*/
)
/*
Initializes the real package and sets the internal rounding type to r.
The real callback function is set to the parameter callback.  This function will
be called with a string containing a message when an error occurs.
*/
{
	mp_length	t;

	mp_start(r, callback);
	mp_decimal(10, &real_base, &t);
}


mp_length
real_beta_digits WITH_1_ARG(
	t_int,	prec
)
/*
Returns the number of beta digits to store a float with prec decimal digits.
*/
{
    mp_base_type	dummy;
    mp_length		result;

    mp_decimal(prec, &dummy, &result);

    return result;
}
