#include "q.h"
#include "ring.e"
#include "globals.e"
#include "structure.e"
#include "alg.e"

public t_handle q_str_create()
/*
** Create the ring of rationals.
*/
{
	t_handle	r;

	r = structure_alloc( sizeof( t_q_table ), 0, 1, REP_Q , FALSE);
	ring_put_type( r, RING_Q );
	ring_set_is_field_true(r);
	ring_set_is_quotient_false(r);

	Q_ONE = conv_int_to_q( r, 1 );
	Q_MINUS_ONE = conv_int_to_q( r, -1 );

	return r;
}

