#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "modint.e"
#include "error.e"

extern t_poly poly_z_resultant();
extern Int      primes[];

#define ASSIGN(var, exp)    temp = (var);\
                            (var) = (exp);\
                            integer_delref( temp )

t_poly
poly_z_resultant_top WITH_3_ARGS (
    t_handle,       pring,
    t_poly,      apoly,
    t_poly,      bpoly
)
{
    t_handle     aph;
    t_handle     resph;
    t_poly  res;

    res = poly_z_resultant (pring, apoly, bpoly);
    aph = m_poly_poly_to_handle (apoly);
    m_poly_create_empty(&resph, m_poly_princvar (aph),
                                             m_poly_least_pvar (aph), 1);
    m_poly_coefft (resph, 0) = res;
    m_poly_expt (resph, 0) = 0;
    return (m_poly_handle_to_poly (resph));
}
    
t_poly
poly_z_resultant WITH_3_ARGS(
    t_handle,       pring,
    t_poly,      apoly,
    t_poly,      bpoly
)
/*
** IPOLY_RESULTANT:  integer polynomial resultant.
** apoly, bpoly are polynomials over Z of positive degree,
** returns : resultant of apoly and bpoly
*/
{
    block_declarations;
    t_handle             aph;
    integer_big        d;
    integer_big        e;
    integer_big        f;
    integer_big        Q;
    integer_big        temp;
    t_int      i;
    t_int      m;
    t_int      n;
    t_int      p;
    t_int      q;
    t_poly          astar;
    t_poly          bstar;
    t_poly          cstar;
    t_poly          cpoly;
    t_poly          tpoly;

    if (m_poly_const( apoly ))
    {
        if ((!apoly) && (!bpoly))
            return 0;
        return 1;
    }
 
    /* both polynomials non_constant */
    /* calculate princ_var */
    aph = m_poly_poly_to_handle( apoly );

    /* Compute coefficient bound. */
    m = poly_deg( apoly);
    n = poly_deg( bpoly);

    d = poly_z_max_norm (pring, apoly);
    e = poly_z_max_norm (pring, bpoly);
    f = integer_nfactorial(m+n);

    /* f = (m+n)! * (d^n) * (e^m) */

    ASSIGN(d, integer_power(d,n));
    ASSIGN(e, integer_power(e,m));
    ASSIGN(f, integer_mult(e,f));
    ASSIGN(f, integer_mult(d,f));
    ASSIGN(f, integer_mult(2,f));

    integer_delref( d );
    integer_delref( e );

    /* Initialize. */

    Q = 1;
    cpoly = poly_z_zero_poly (pring, m_poly_coefft(aph, 0));
    p = primes[100];

    /* Loop */

    for (i = 100; i > 0; p = primes[--i])
    {
#if 0
        cay_print("Entering poly_z_resultant loop Prime = %d\n",p);
#endif
        astar = modpoly_hom (pring, p, apoly);
        if (poly_deg( astar) == m)
        {
            bstar = modpoly_hom (pring, p, bpoly);
            if (poly_deg( bstar) == n)
            {
                cstar = modpoly_resultant (pring, p, astar, bstar);
                q = modint_hom (p, Q);
                q = modint_invert (p, q);
                tpoly = cpoly;
#if 0
                cay_print("Calling poly_z_chinese_rem with M = ");
                integer_write(Q);
                cay_print(" m = %d   m' = %d\n A = ",p,q);
                poly_z_write (pring, cpoly);
                cay_print("\na = ");
                poly_z_write (pring, cstar);
#endif
                cpoly = poly_z_chinese_rem (pring, Q,p,q,cpoly,cstar);
#if 0
                cay_print("\nA*= ");
                poly_z_write (pring, cpoly);
                cay_print("\n");
#endif
                m_poly_z_delref( pring, tpoly );
                m_poly_z_delref( pring, cstar );
                ASSIGN(Q, integer_mult(Q,p));
                if (integer_compare (Q, f) >= 0)
                {
                    cstar = poly_z_shift_range(pring, cpoly,Q);
                    integer_delref( f );
                    integer_delref( Q );
                    m_poly_z_delref( pring, astar );
                    m_poly_z_delref( pring, bstar );
                    m_poly_z_delref( pring, cpoly );
                    return (cstar);
                }
            }
            m_poly_z_delref( pring, bstar );
        }
        m_poly_z_delref( pring, astar );
    }

    error_internal ("Algorithm fails for poly_z_resultant");
    m_poly_z_delref( pring, cpoly );
    integer_delref( f );
    integer_delref( Q );
    return (0);
}
