
#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_integer_add WITH_3_ARGS(
    t_handle,    pring,
    t_poly,   apoly,
    t_int,       number
)
{
    block_declarations;
    t_handle           temp;
    t_handle           resp;
    t_handle           aph;
    t_int    nterms;      /* no. terms in apoly */

    if ( m_poly_const( apoly ) )
    {
        /* constant polynomial */
        return  integer_add( apoly, number );
    }

    /* general case: non_trivial polynomial */

    if ( number == 0 )
        return  m_poly_z_incref (pring, apoly);

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );
    temp = poly_z_constant_poly (pring, apoly, number);
    resp = poly_z_add (pring, apoly, temp);
	m_poly_z_delref (pring, temp);
    return resp;
}

