#include "defs.h"
#include "poly.h"
#include "poly_z_faclst.h"

t_void
poly_z_faclst_delete WITH_2_ARGS(
        t_handle,               pring,
	dyn_arr_handle *,	ph
)
/*
** Deletes a faclst of integer polynomials
*/
{
	block_declarations;

	if ( ! block_has_other_refs( *ph ))
	{
		t_int	i;
		t_poly	temp;

		for ( i = m_poly_z_faclst_len( *ph ) - 1; i >= 0; --i )
		{
			temp = m_poly_z_faclst_factor( *ph, i );
			m_poly_z_delref( pring, temp );
		}
	}

	block_decref_delete( *ph );
	*ph = 0;
}

