#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

t_int
poly_u_zm_different WITH_4_ARGS(
        t_handle,       pring,
        integer_big,    pdig,
        t_poly,      apoly,
        t_poly,      bpoly
)
/*
** poly_u_zm_different: check if two modular univariate polynomials are
** different, returning 1 if they are different, 0 otherwise
*/
{
    t_int    nterms;
    t_int    termno;
    t_handle           aph;
    t_int    aexpt;
    t_poly        acoefft;
    t_handle           bph;
    t_int    bexpt;
    t_poly        bcoefft;

    DENY (  m_poly_const( apoly ) ||  m_poly_const( bpoly ));

    if (apoly == bpoly)
    {
        return FALSE;
    }
    aph = m_poly_poly_to_handle( apoly );
    bph = m_poly_poly_to_handle( bpoly );

    ASSERT ( m_poly_univariate( aph ) && m_poly_univariate( bph ));
    ASSERT ( m_poly_princvar( aph ) == m_poly_princvar( bph ) );

    nterms = m_poly_nterms( aph );

    if ( nterms != m_poly_nterms (bph))
    {
        return TRUE;
    }

    for ( termno = 0; termno < nterms; termno ++ )
    {
        aexpt = m_poly_expt( aph, termno );
        bexpt = m_poly_expt( bph, termno );

        if ( aexpt != bexpt )
        {
            return TRUE;
        }
        acoefft = m_poly_coefft( aph, termno );
        bcoefft = m_poly_coefft( bph, termno );

        if ( integer_compare( acoefft, bcoefft ) != 0 )
        {
            return TRUE;
        }
    }

    return FALSE;
}

