#include "defs.h"
#include "poly.h"

t_poly
poly_scalar_add_crf(context, apoly, number)
t_poly_ctx	context;
t_poly		apoly;
t_handle	number;
{
	t_handle	cring;
	t_poly		res, temp;
	t_pfl		elt_is_zero;

	elt_is_zero = m_poly_ctx_is_zero(context);
	

	DENY ( m_poly_const( apoly ) );

	/* general case: non_trivial polynomial */

	if ((*elt_is_zero)(cring,  number))
		return  poly_elt_incref_crf(context, apoly);

	temp = poly_constant_poly_crf(context, apoly, number);
	res = poly_add_crf (context, apoly, temp);
	poly_elt_delete_crf(context, &temp);
	return res;
}

t_poly
poly_scalar_add(pring, apoly, number)
t_handle    	pring;
t_poly   	apoly;
t_handle       	number;
{
	t_poly_context	context;

	poly_init_context(pring, &context);

	return poly_scalar_add_crf(&context, apoly, number);
}

