#include "poly.h"

t_logical
poly_is_zero(pring, apoly)
t_handle	pring;
t_poly		apoly;
{
	t_poly_context	context;

        poly_init_context(pring, &context);
	return poly_is_zero_crf(&context, apoly);
}

t_logical
poly_is_zero_crf(context, apoly)
t_poly_ctx	context;
t_poly		apoly;
{
	t_polyp    	ap;
	t_handle	cring;
	t_pfl		is_zero;
     
	cring = m_poly_ctx_cring(context);
	is_zero = m_poly_ctx_is_zero(context);
	DENY (m_poly_const (apoly));
 
	ap = m_poly_to_ptr (apoly);
 
	for (;;)
	{
		if (m_polyp_nterms (ap) != 1)
			return FALSE;
		if (m_polyp_expt (ap, 0) != 0)
			return FALSE;
		if (m_polyp_univariate (ap))
			return (*is_zero)(cring,m_polyp_coefft (ap, 0));
		ap = m_poly_to_ptr (m_polyp_coefft (ap, 0));
	}
}
 

t_logical
poly_is_one(pring, apoly)
t_handle	pring;
t_poly		apoly;
{
	t_poly_context	context;

        poly_init_context(pring, &context);
	return poly_is_one_crf(&context, apoly);
}

t_logical
poly_is_one_crf(context, apoly)
t_poly_ctx	context;
t_poly		apoly;
{
	t_polyp    	ap;
	t_handle	cring;
	t_pfl		is_one;
     
	cring = m_poly_ctx_cring(context);
	is_one = m_poly_ctx_is_one(context);
	DENY (m_poly_const (apoly));
 
	ap = m_poly_to_ptr (apoly);
 
	for (;;)
	{
		if (m_polyp_nterms (ap) != 1)
			return FALSE;
		if (m_polyp_expt (ap, 0) != 0)
			return FALSE;
		if (m_polyp_univariate (ap))
			return (*is_one)(cring,m_polyp_coefft (ap, 0));
		ap = m_poly_to_ptr (m_polyp_coefft (ap, 0));
	}
}
 


t_logical
poly_is_minus_one(pring, apoly)
t_handle	pring;
t_poly		apoly;
{
	t_poly_context	context;

        poly_init_context(pring, &context);
	return poly_is_minus_one_crf(&context, apoly);
}

t_logical
poly_is_minus_one_crf(context, apoly)
t_poly_ctx	context;
t_poly		apoly;
{
	t_polyp    	ap;
	t_handle	cring;
	t_pfl		is_minus_one;
     
	cring = m_poly_ctx_cring(context);
	is_minus_one = m_poly_ctx_is_minus_one(context);
	DENY (m_poly_const (apoly));
 
	ap = m_poly_to_ptr (apoly);
 
	for (;;)
	{
		if (m_polyp_nterms (ap) != 1)
			return FALSE;
		if (m_polyp_expt (ap, 0) != 0)
			return FALSE;
		if (m_polyp_univariate (ap))
			return (*is_minus_one)(cring,m_polyp_coefft (ap, 0));
		ap = m_poly_to_ptr (m_polyp_coefft (ap, 0));
	}
}
 

