#include "defs.h"
#include "mp.e"
#include "mp.h"


mp_int
mp_priv_change_base	WITH_3_ARGS(
	mp_base_type,	b1,
	mp_base_type,	b2,
	mp_int,		n
)
/*
Returns j such that b1^int_abs(j) >= b2^int_abs(n),
i.e. int_abs(j) >= int_abs(n)*log(b2)/log(b1)
     and sign(j) == sign(n),
assuming that b1 > 1, b2 >= 1, and b1 * b2 <= MAX_INT.
Usually the value of j returned is close to minimal.
*/
{
    mp_int	j, k, q, mul, n2, limit = MAX_INT / b1;

    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+change_base {\n");
    DEBUG_PRINTF_4("b1 = %d, b2 = %d, n = %d\n", b1, b2, n);

    if (b1 <= 1 || b2 <= 0 || b2 > limit)
	mp_error("mp_change_base: illegal arguments");

    if (n == 0 || b2 == 1)
	return 0;

    j = k = 0;
    q = 1;

    /*
    The constant 100 is large enough to give reasonable accuracy.
    If it is increased the time required will increase.
    */

    mul = (int_abs(n) - 1) / 100 + 1;
    n2 = (int_abs(n) - 1) / mul + 1;

    /*
    Increase j & k, keeping q <= b1^j/b2^k.
    */

    while (k < n2)
    {
	while (q <= limit)
	{
	    q *= b1;
	    j++;
	}
	q /= b2;
	k++;
    }

    /*
    Final stage - may have overshot.
    */

    while (q >= b1)
    {
	q /= b1;
	j--;
    }

    /*
    Check if result would overflow.
    */

    if (j > MAX_INT / mul)
	mp_bug("mp_change_base: value of n (%d) too large", n);

    DEBUG_PRINTF_2("-} j = %d\n", j * mul * int_sign(n));
    DEBUG_END();

    return j * mul * int_sign(n);
}
