#include "defs.h" 
#include "integer.e"
#include "poly.h"
#include "modint.e"

t_poly
modpoly_symm_rep WITH_3_ARGS(
t_handle,	pring,
integer_big,    mint,
t_poly,	apoly
)
/*
** modpoly_symm_rep : SMFMIP in SAC code.
** "Wraps" the coefficients in Zm to an integer in the
** range [-m/2, m/2).
*/
{
	t_handle	aph, bph;
	t_int		nterms, i;

	if (m_poly_const(apoly))
		return modint_symm_rep(mint, apoly);


	aph = m_poly_poly_to_handle(apoly);
	nterms = m_poly_nterms(aph);
	m_poly_create_empty(&bph,m_poly_princvar(aph),m_poly_least_pvar(aph),nterms);
	for (i = 0; i < nterms; i++)
	{
		m_poly_coefft(bph, i) = modpoly_symm_rep(pring, mint, m_poly_coefft(aph, i));
		m_poly_expt(bph, i) = m_poly_expt(aph, i);
	}

	return m_poly_handle_to_poly(bph);
}

