#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "modint.e"

t_poly
modpoly_evaluate WITH_5_ARGS(
        t_handle,       pring,
	integer_big,	mdig,
	t_poly,	apoly,
	t_int,	i,
	integer_big,	aint
)
/*
*	MODPOLY_EVALUATE : modular polynomial evaluation.
*	apoly is a polynomial in r variables over Zmdig, mdig a beta-integer.
*	1 <= i <= r, aint is an element of Zmdig.
*	returns A(x1,x2,...x(i-1),aint,x(i+1),...xr) mod mdig
*/
{
	block_declarations;
	t_handle		resph;
	t_handle		aph;
	t_int	nterms;
	t_int	termno;
	t_int	restermno;
	t_poly	acoefft;

	if ( m_poly_const( apoly ) )
	{
		return  integer_incref( apoly );
	}

	aph = m_poly_poly_to_handle( apoly );
	
	if ( i == m_poly_princvar( aph ) )
	{
		/* evaluation of principal variable */
		return  modpoly_eval_princvar( pring, mdig, apoly, aint );
	}

	if ( i < m_poly_princvar( aph ) )
	{
		/* polynomial constant w.r.t. required variable */
		/* no evaluation necessary			*/

		return  m_modpoly_incref( pring, apoly );
	}

	/* general case : evaluation in var of lower precedence than */
	/* princvar, i.e.  i > m_poly_princvar( aph )		     */

	nterms = m_poly_nterms( aph );
	m_poly_create_empty( &resph, m_poly_princvar (aph),
                                       m_poly_least_pvar (aph), nterms );
	restermno = 0;

	for ( termno = 0; termno < nterms; termno++, restermno++ )
	{
		/* evaluate each term w.r.t. ith variable */

		m_poly_expt (resph, restermno) = m_poly_expt (aph, termno);
		acoefft = m_poly_coefft (aph, termno);
		m_poly_coefft( resph, restermno ) =
		     modpoly_evaluate( pring, mdig, acoefft, i, aint );
	}

	return poly_z_clean (pring, m_poly_handle_to_poly (resph ));
}


t_poly
modpoly_eval_lpvar WITH_4_ARGS (
        t_handle,     pring,
        integer_big,  mdig,
        t_poly,    apoly,
        integer_big,  aint
)
/*
 * evaulate the least principal variableto of apoly to be aint.
 * If apoly is a poly in r variables, modpoly_eval_lpvar returns
 * a poly in r-1 variables.
 */
{
	block_declarations;
	t_handle		resph;
	t_handle		aph;
	t_int	nterms;
	t_int	termno;
	t_poly	acoefft;

	if ( m_poly_const( apoly ) )
	{
		return  integer_incref( apoly );
	}

	aph = m_poly_poly_to_handle( apoly );

	if (m_poly_univariate (aph))
	{
		return modpoly_eval_princvar (pring, mdig, apoly, aint);
	}
	else
	{
		nterms = m_poly_nterms (aph);
		m_poly_create_empty (&resph, m_poly_princvar (aph),
                                     m_poly_least_pvar (aph) - 1, nterms);
		for (termno = 0; termno < nterms; termno ++)
		{
			acoefft = m_poly_coefft (aph, termno);
			m_poly_coefft (resph, termno) =
                        modpoly_eval_lpvar (pring, mdig, acoefft, aint);
			m_poly_expt (resph, termno) = m_poly_expt (aph, termno);
		}
	}
	return poly_z_clean (pring, m_poly_handle_to_poly (resph ));
}


t_poly
modpoly_eval_princvar WITH_4_ARGS(
        t_handle,       pring,
	integer_big,	mdig,
	t_poly,	apoly,
	integer_big,	aint
)
/*
** MODPOLY_EVAL_PRINCVAR : modular polynomial evaluation of principal
** variable. apoly is apolynomial over Zmdig
** aint is an element of Zmdig
** returns apoly[x1,x2,...x(r-1),aint] mod mdig.
*/
{
	block_declarations;
	t_handle		aph;
	t_int	nterms;
	t_int	termno;
	t_poly	acoefft;
	t_int	aexpt;
	t_poly	respoly;
	t_poly	temp;
	t_poly	temp2;

	if ( m_poly_const( apoly ) )
	{
		return  integer_incref( apoly );
	}

	/* general case for non-trivial polynomial */

	aph = m_poly_poly_to_handle( apoly );
	nterms = m_poly_nterms( aph );
	respoly = poly_z_zero_poly (pring, m_poly_coefft (aph, 0));

	for ( termno = 0; termno < nterms; termno++ )
	{
		/* This is *not* Horner's method - should be changed to it! */

		acoefft = m_poly_coefft( aph, termno );
		aexpt = m_poly_expt( aph, termno );

		if (aexpt)
		{
		    temp2 = modint_exp( mdig, aint, aexpt );
		    temp = modpoly_integer_mult( pring, mdig, acoefft, temp2 );
		    integer_delref( temp2 );
		}
		else
		{
		    temp = m_modpoly_incref (pring, acoefft);
		}

		temp2 = respoly;
		respoly = modpoly_add( pring, mdig, temp, temp2 );
		m_modpoly_delref( pring, temp2 );
		m_modpoly_delref( pring, temp );
	}

	return  respoly;
}

