#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"
#include "error.e"

t_poly
modpoly_div WITH_4_ARGS(
        t_handle,       pring,
	integer_big,	pdig,
	t_poly,	apoly,
	t_poly,	bpoly
)
/*
** modpoly_div : modular polynomial quotient.
** apoly and bpoly are polynomials over Zpdig,
** pdig is any  integer.
** bpoly is a non-zero divisor of apoly.
** returns : ( apoly / bpoly ) mod pdig.
*/
{
	block_declarations;
	t_poly	 rempoly;
	t_poly	 qpoly;

#ifdef DEBUG
	if ( poly_z_is_zero_poly (pring, bpoly))
	{
		error_internal( "division by zero in modpoly_div" );
	}
#endif /* DEBUG */

	if ( ( m_poly_not_const( apoly ) ) && ( m_poly_not_const( bpoly ) ) )
	{
		modpoly_quot_rem( pring, pdig, apoly, bpoly, &qpoly, &rempoly );

#ifdef DEBUG
		if ( !poly_z_is_zero_poly (pring, rempoly) )
		{
			error_internal( "b not a divisor of a in modpoly_div" );
		}
#endif /* DEBUG */

                m_modpoly_delref (pring, rempoly);
		return  qpoly;
	}

#ifdef DEBUG
	if (( m_poly_not_const( apoly ) ) || ( m_poly_not_const( bpoly ) ))
	{
		error_internal( "modpoly_div: polys not lifted" );
	}
#endif /* DEBUG */

	/* both apoly and bpoly constant */

	return  modint_div( pdig, apoly, bpoly );
}

