#include "modint.e"

integer_big
modint_negate_f WITH_2_ARGS(
	integer_big,	mint,
	integer_big,	aint
)
/*
** modint_negate_f : modular integer negation
** function sitting under macro modint_negate().
** mint: positive integer ( single or infinite precision ).
** aint is an element of Zmint.
** returns -aint
*/
{

	if ( integer_is_single( mint ) )
	{
		if ( aint == 0 )
		{
			return 0;
		}

		return  mint - aint;
	}

	/* big integers required */

	if ( integer_sign( aint ) == 0 )
	{
		return  0;
	}

	/* aint != 0 */

	return  integer_subtract( mint, aint );
}

