#include "defs.h"
#include "ring.h"
#include "integer.e"
#include "mat.h"
#include "zm.e"

void
mat_z_col_hnf_mod_sub WITH_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	q,
	matrix *,	hnf
)
/*
** Calculates Modular Column Hermite Normal Form of a over the integers, with
** modulus q, placing result into *hnf.
*/
{
	block_declarations;
	matrix		adash;
	matrix		hnfdash;
	integer_small	m;
	integer_small	n;
	integer_small	mdash;
	integer_small	ndash;
	integer_big	temp;
	integer_small	r;
	integer_big	hii;
	integer_big	hij;
	integer_small	i;
	integer_small	j;
	integer_small	k;
	integer_big	rat;
	integer_big	smallest;
	t_handle		zmring;

	zmring = zm_str_create( q, 0 );

	m = mat_row( a );	mdash = m;
	n = mat_col( a );	ndash = n + m;

	hnfdash = mat_buff_alloc( mdash, ndash );

	adash = 0;
	mat_create_unpkd( cring, a, adash, m, n );

/* Step 1: Initialisation */

	for ( i=1; i<=m; ++i )
	{
		for ( j=1; j<=n; ++j )
		{
			temp = mat_elt( adash, i, j );
			mat_elt( hnfdash, i, j ) = integer_rem( temp, q );
		}

		for ( j=1; j<=m; ++j )
		{
			mat_elt( hnfdash, i, n+j ) = 0;
		}

		mat_elt( hnfdash, i, n+i ) = integer_incref( q );
	}

	r = ( mdash > ndash ? ndash : mdash );

	for ( i=1; i<=r; ++i )
	{

/* Step 2: Determination of smallest element in row i */

		k = (-1);

		for ( j=i; j<=i+n; ++j )
		{
			if ( k == -1 )
			{
				temp = mat_elt( hnfdash, i, j );
				if ( temp != 0 )
				{
					smallest = temp;
					k = j;
				}
			}
			else
			{
				temp = mat_elt( hnfdash, i, j );
				if ( temp != 0 )
				{
					if ( integer_compare( smallest, temp ) > 0 )
					{
						smallest = temp;
						k = j;
					}
				}
			}
		}

		if ( k == -1 )
		{
			continue;
		}

/* Step 3: Change of columns i and k */

		if ( i != k )
		{
			mat_ring_col_swap( cring, hnfdash, i, k, 1, m );
		}

/* Step 4: Reduction of elements h_{ij} modulo h_{ii} for j > i */

		hii = mat_elt( hnfdash, i, i );

		for ( j=i+1; j<=i+n; ++j )
		{
			hij = mat_elt( hnfdash, i, j );
			integer_quot_rem( hij, hii, &temp, &rat );
			integer_delref( hij );
			mat_elt( hnfdash, i, j ) = rat;

			if (( i+1 <= m ) && (( j != i+n ) || integer_compare( temp, q )))
			{
				/*
				** Column operation: col j += rat * col i.
				*/

				rat = modint_negate( q, temp );
				mat_zm_col_add( zmring, hnfdash, i, j, rat, i+1, m );
				integer_delref( rat );
			}

			integer_delref( temp );
		}

		for ( j=i+1; j<=i+n; ++j )
		{
			hij = mat_elt( hnfdash, i, j );
			if ( hij != 0 )
			{
				break;
			}
		}

		if ( j <= i+n )
		{
			/*
			** Return to beginning of loop without
			** incrementing i.
			*/

			--i;
			continue;
		}

/* Step 5: Reduction of elements h_{ij} modulo h_{ii} for j < i */

		hii = mat_elt( hnfdash, i, i );
		if ( integer_sign( hii ) < 0 )
		{
			error_internal( "negative hii" );
		}

		if ( integer_compare( hii, q ) != 0 )
		{
			for ( j=1; j<i; ++j )
			{
				hij = mat_elt( hnfdash, i, j );

				temp = integer_div( hij, hii );
				rat = modint_negate( q, temp );
				integer_delref( temp );

				/*
				** Column operation: col j -= rat * col i.
				*/

				mat_zm_col_add( zmring, hnfdash, i, j, rat, i, m );

				integer_delref( rat );
			}
		}

/* Step 6: Increase i */

	}

	mat_ring_submat_sub( cring, hnfdash, 1, 1, hnf, m, n );

	mat_delete_entries( cring, hnfdash );
	mat_buff_free( &hnfdash );
	mat_free_unpkd( a, adash );

	ring_delete( &zmring );
}

