
#include "defs.h"
#include "ring.h"
#include "mat.h"

matrix 
mat_ring_inverse WITH_2_ARGS(
	t_handle,	crg,
	matrix,	a
)
/*
 * calculate the inverse of a matrix.
 */
{
	switch (ring_type(crg))
	{
	case RING_Z:
		return mat_z_inverse(crg, a);
	case RING_ZM:
		return mat_zm_inverse(crg, a);
	/*
	case RING_POLY:
	*/
	case RING_Q:
		return mat_fld_inverse(crg, a);
	default:
		break;
	}

	if ( ring_is_field( crg ) )
		return  mat_fld_inverse( crg, a );

	error_internal("Can't do matrix inverse of type %d", ring_type(crg));
}
